/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;

public abstract class AbstractInteractive
implements Interactive {
    public Color color = new Color(255, 128, 128, 128);
    protected double x = 0.0;
    protected double y = 0.0;
    boolean enabled = true;

    @Override
    public abstract void draw(DrawingPanel var1, Graphics var2);

    public abstract boolean isInside(DrawingPanel var1, int var2, int var3);

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.isInside(panel, xpix, ypix) && this.enabled) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    @Override
    public double getXMin() {
        return this.x;
    }

    @Override
    public double getXMax() {
        return this.x;
    }

    @Override
    public double getYMin() {
        return this.y;
    }

    @Override
    public double getYMax() {
        return this.y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double _x) {
        this.x = _x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double _y) {
        this.y = _y;
    }
}

