/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Measurable;

public abstract class AbstractTrail
implements Drawable,
Measurable {
    public Color color = Color.black;
    protected boolean enableMeasure = false;
    protected double xmin = Double.MAX_VALUE;
    protected double xmax = -1.7976931348623157E308;
    protected double ymin = Double.MAX_VALUE;
    protected double ymax = -1.7976931348623157E308;
    protected double xmaxLogscale = -1.7976931348623157E308;
    protected double ymaxLogscale = -1.7976931348623157E308;
    protected double xminLogscale = Double.MAX_VALUE;
    protected double yminLogscale = Double.MAX_VALUE;
    protected int numpts = 0;
    protected boolean closed = false;
    protected Stroke drawingStroke;

    public abstract void addPoint(double var1, double var3);

    public abstract void closeTrail();

    public abstract void clear();

    public void setStroke(Stroke stroke) {
        this.drawingStroke = stroke;
    }

    public void setDashedStroke(int dashPoint, int dashLength) {
        this.drawingStroke = dashLength == 0 ? new BasicStroke(dashPoint, 0, 1, 0.0f, null, 0.0f) : new BasicStroke(dashPoint, 0, 1, 0.0f, new float[]{dashLength}, 0.0f);
    }

    public Stroke getStroke() {
        return this.drawingStroke;
    }

    public int getNumberOfPoints() {
        return this.numpts;
    }

    public void setMeasured(boolean _enableMeasure) {
        this.enableMeasure = _enableMeasure;
    }

    @Override
    public boolean isMeasured() {
        return this.enableMeasure && this.numpts > 0;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    public double getXMinLogscale() {
        return this.xminLogscale;
    }

    public double getXMaxLogscale() {
        return this.xmaxLogscale;
    }

    public double getYMinLogscale() {
        return this.yminLogscale;
    }

    public double getYMaxLogscale() {
        return this.ymaxLogscale;
    }
}

