/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.ArrowLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Arrow
implements Drawable {
    protected float headSize = 8.0f;
    protected Color color = Color.black;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double a = 0.0;
    protected double b = 0.0;
    Point2D.Double ptA = new Point2D.Double();
    private double lastTheta = Double.NaN;
    private double lastX;
    private double lastY;
    private double lastHeadSize;
    private Shape head;
    private AffineTransform trA = new AffineTransform();

    public Arrow(double _x, double _y, double _a, double _b) {
        this.x = _x;
        this.y = _y;
        this.a = _a;
        this.b = _b;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.setXY(x, this.y);
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.setXY(this.x, y);
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setXlength(double dx) {
        this.a = dx;
    }

    public void setYlength(double dy) {
        this.b = dy;
    }

    public double getXlength() {
        return this.a;
    }

    public double getYlength() {
        return this.b;
    }

    public float getHeadSize() {
        return this.headSize;
    }

    public void setHeadSize(float size) {
        this.headSize = size;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = panel.getPixelTransform();
        g2.setPaint(this.color);
        g2.draw(tr.createTransformedShape(new Line2D.Double(this.x, this.y, this.x + this.a, this.y + this.b)));
        this.ptA.setLocation(this.x + this.a, this.y + this.b);
        tr.transform(this.ptA, this.ptA);
        double aspect = panel.isSquareAspect() ? 1.0 : -tr.getScaleX() / tr.getScaleY();
        Shape temp = this.getHead(this.ptA, Math.atan2(this.b, aspect * this.a));
        g2.fill(temp);
        g2.setPaint(Color.BLACK);
    }

    protected Shape getHead(Point2D.Double ptA, double theta) {
        if (theta == this.lastTheta && this.lastX == ptA.x && this.lastY == ptA.y && (double)this.headSize == this.lastHeadSize) {
            return this.head;
        }
        this.lastTheta = theta;
        this.lastX = ptA.x;
        this.lastY = ptA.y;
        this.lastHeadSize = this.headSize;
        GeneralPath path = new GeneralPath();
        path.moveTo(1.0f, 0.0f);
        path.lineTo(-this.headSize, -this.headSize / 2.0f);
        path.lineTo(-this.headSize, this.headSize / 2.0f);
        path.closePath();
        this.trA.setToTranslation(ptA.x, ptA.y);
        this.trA.rotate(-theta);
        this.head = this.trA.createTransformedShape(path);
        return this.head;
    }

    public static XML.ObjectLoader getLoader() {
        return new ArrowLoader();
    }
}

