/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class BoundedImage
extends BoundedShape
implements ImageObserver {
    protected Image image;
    private AffineTransform trBI = new AffineTransform();
    Rectangle2D.Double rectBI = new Rectangle2D.Double();

    public BoundedImage(Image image, double x, double y) {
        super(null, x, y);
        this.image = image;
        this.width = image.getWidth(this);
        this.width = Math.max(0.0, this.width);
        this.height = image.getHeight(this);
        this.height = Math.max(0.0, this.height);
        this.shapeClass = image.getClass().getName();
        this.setPixelSized(true);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        this.getPixelPt(panel);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(this.pixelPt.x, this.pixelPt.y);
        this.trBI.setToTranslation(-this.width / 2.0, -this.height / 2.0);
        this.trBI.rotate(-this.theta, this.width / 2.0, this.height / 2.0);
        this.trBI.scale(this.width / (double)this.image.getWidth(null), this.height / (double)this.image.getHeight(null));
        g2.drawImage(this.image, this.trBI, null);
        g2.translate(-this.pixelPt.x, -this.pixelPt.y);
        this.getFixedBounds();
        if (this.selected) {
            this.drawFixedBounds(g);
        }
    }

    private void getFixedBounds() {
        this.rectBI.setFrame(this.pixelPt.x - this.width / 2.0, this.pixelPt.y - this.height / 2.0, this.width, this.height);
        this.pixelBounds = this.computeFixedHotSpots(this.rectBI);
        if (this.theta != 0.0) {
            this.pixelBounds = this.getRotateInstance(-this.theta, this.pixelPt.x, this.pixelPt.y).createTransformedShape(this.pixelBounds);
        }
    }

    private void drawFixedBounds(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[0].getX() - this.delta, (int)this.hotSpots[0].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[0].getX() - 1, (int)this.hotSpots[0].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[5].getX() - this.delta, (int)this.hotSpots[5].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[3].getX() - this.delta, (int)this.hotSpots[3].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[1].getX() - this.delta, (int)this.hotSpots[1].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[2].getX() - this.delta, (int)this.hotSpots[2].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[4].getX() - this.delta, (int)this.hotSpots[4].getY() - this.delta, this.d2, this.d2);
        }
        g.setColor(Color.BLACK);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 1) == 1) {
            this.width = width;
        }
        if ((infoflags & 2) == 1) {
            this.height = height;
        }
        return (infoflags & 0x20) != 1;
    }
}

