/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.BoundedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveArrow;
import org.opensourcephysics.display.InteractiveCenteredArrow;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display.Selectable;

public class BoundedShape
extends InteractiveShape
implements Selectable {
    static final int CENTER = 0;
    static final int BOTTOM = 1;
    static final int LEFT = 2;
    static final int TOP = 3;
    static final int RIGHT = 4;
    static final int CORNER = 5;
    static final int NONE = 6;
    int hotspot = 6;
    int delta = 3;
    int deltaSqr = this.delta * this.delta;
    int d2 = 2 * this.delta + 1;
    boolean selected = false;
    boolean hideBounds = false;
    Color boundsColor = new Color(128, 128, 255);
    boolean widthDrag = false;
    boolean heightDrag = false;
    boolean xyDrag = true;
    boolean rotateDrag = false;
    Shape pixelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    Point2D.Double[] hotSpots = new Point2D.Double[6];
    XYDelegate xyDelegate = new XYDelegate();
    Point2D.Double pt00 = new Point2D.Double();

    public BoundedShape(Shape s, double x, double y) {
        super(s, x, y);
        int i = 0;
        int n = this.hotSpots.length;
        while (i < n) {
            this.hotSpots[i] = this.pt00;
            ++i;
        }
    }

    public static BoundedShape createBoundedRectangle(double x, double y, double w, double h) {
        Rectangle2D.Double shape = new Rectangle2D.Double(-w / 2.0, -h / 2.0, w, h);
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedTriangle(double x, double y, double b, double h) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(-b / 2.0), (float)(-h / 2.0));
        path.lineTo((float)(b / 2.0), (float)(-h / 2.0));
        path.lineTo(0.0f, (float)(h / 2.0));
        path.closePath();
        GeneralPath shape = path;
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedArrow(double x, double y, double w, double h) {
        InteractiveArrow ia = new InteractiveArrow(x, y, w, h);
        ia.hideBounds = false;
        return ia;
    }

    public static BoundedShape createBoundedCenteredArrow(double x, double y, double w, double h) {
        InteractiveCenteredArrow ica = new InteractiveCenteredArrow(x, y, w, h);
        ica.hideBounds = false;
        return ica;
    }

    public static BoundedShape createBoundedImage(Image image, double x, double y) {
        return new BoundedImage(image, x, y);
    }

    public static BoundedShape createBoundedEllipse(double x, double y, double w, double h) {
        Ellipse2D.Double shape = new Ellipse2D.Double(-w / 2.0, -h / 2.0, w, h);
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedCircle(double x, double y, double d) {
        Ellipse2D.Double shape = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
        return new BoundedShape(shape, x, y);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setXYDrag(boolean enable) {
        this.xyDrag = enable;
    }

    public boolean isXYDrag() {
        return this.xyDrag;
    }

    public void setRotateDrag(boolean enable) {
        this.rotateDrag = enable;
    }

    public boolean isRotateDrag() {
        return this.rotateDrag;
    }

    public void setWidthDrag(boolean enable) {
        this.widthDrag = enable;
    }

    public boolean isWidthDrag() {
        return this.widthDrag;
    }

    public void setHeightDrag(boolean enable) {
        this.heightDrag = enable;
    }

    public boolean isHeightDrag() {
        return this.heightDrag;
    }

    @Override
    public Cursor getPreferredCursor() {
        int c = 12;
        if (this.xyDrag && this.hotspot == 0) {
            c = 13;
        } else if (!this.rotateDrag || this.hotspot != 5) {
            if (this.widthDrag && this.hotspot == 2) {
                if (this.theta == 0.0) {
                    c = 10;
                }
            } else if (this.widthDrag && this.hotspot == 4) {
                if (this.theta == 0.0) {
                    c = 11;
                }
            } else if (this.heightDrag && this.hotspot == 3) {
                if (this.theta == 0.0) {
                    c = 8;
                }
            } else if (this.heightDrag && this.hotspot == 1) {
                if (this.theta == 0.0) {
                    c = 9;
                }
            } else if (this.selected) {
                c = 1;
            }
        }
        return Cursor.getPredefinedCursor(c);
    }

    @Override
    public void toggleSelected() {
        this.selected = !this.selected;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.isInside(panel, xpix, ypix)) {
            return this.xyDelegate;
        }
        return null;
    }

    @Override
    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        this.hotspot = 6;
        if (!this.enabled) {
            return false;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(xpix, ypix, this.hotSpots);
            return true;
        }
        return this.pixelBounds.contains(xpix, ypix);
    }

    int getHotSpotIndex(int xpix, int ypix, Point2D.Double[] hotSpots) {
        int i = 0;
        int n = hotSpots.length;
        while (i < n) {
            double dx = (double)xpix - hotSpots[i].x;
            double dy = (double)ypix - hotSpots[i].y;
            if (dx * dx + dy * dy <= (double)this.deltaSqr) {
                return i;
            }
            ++i;
        }
        return 6;
    }

    Rectangle2D.Double computeScaledHotSpots(Shape temp, double ar) {
        Rectangle2D.Double rect = this.getBounds2D(temp);
        double sin = Math.sin(this.theta);
        double cos = Math.cos(this.theta);
        double w2 = rect.width / 2.0;
        double h2 = rect.height / 2.0;
        double xoff = this.xoff * this.toPixels.getScaleX();
        double yoff = this.yoff * this.toPixels.getScaleY();
        double left = xoff - w2;
        double right = xoff + w2;
        double top = yoff - h2;
        double bottom = yoff + h2;
        double cx = rect.x - left;
        double cy = rect.y - top;
        this.hotSpots[0].setLocation(cx, cy);
        this.hotSpots[1].setLocation(cx + xoff * cos + bottom * sin / ar, cy - xoff * sin + bottom * cos);
        this.hotSpots[2].setLocation(cx + left * cos + yoff * sin, cy - left * sin * ar + yoff * cos);
        this.hotSpots[3].setLocation(cx + xoff * cos + top * sin / ar, cy - xoff * sin + top * cos);
        this.hotSpots[4].setLocation(cx + right * cos + yoff * sin, cy - right * sin * ar + yoff * cos);
        this.hotSpots[5].setLocation(cx + right * cos + top * sin / ar, cy - right * sin * ar + top * cos);
        return rect;
    }

    Rectangle2D.Double computeFixedHotSpots(Shape temp) {
        Rectangle2D.Double rect = this.getBounds2D(temp);
        double sin = Math.sin(this.theta);
        double cos = Math.cos(this.theta);
        double w2 = rect.width / 2.0;
        double h2 = rect.height / 2.0;
        double xoff = this.xoff;
        double yoff = this.yoff;
        double left = xoff - w2;
        double right = xoff + w2;
        double top = yoff + h2;
        double bottom = yoff - h2;
        double cx = rect.x - left;
        double cy = rect.y + top;
        this.hotSpots[0].setLocation(cx, cy);
        this.hotSpots[1].setLocation(cx + xoff * cos - bottom * sin, cy - xoff * sin - bottom * cos);
        this.hotSpots[2].setLocation(cx + left * cos - yoff * sin, cy - left * sin - yoff * cos);
        this.hotSpots[3].setLocation(cx + xoff * cos - top * sin, cy - xoff * sin - top * cos);
        this.hotSpots[4].setLocation(cx + right * cos - yoff * sin, cy - right * sin - yoff * cos);
        this.hotSpots[5].setLocation(cx + right * cos - top * sin, cy - right * sin - top * cos);
        return rect;
    }

    protected Rectangle2D.Double getBounds2D(Shape temp) {
        return (Rectangle2D.Double)(temp instanceof Rectangle2D.Double ? temp : temp.getBounds2D());
    }

    void setHotSpotXY(double x, double y) {
        if (this.hideBounds) {
            this.setXY(x, y);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == 0) {
            this.setXY(x, y);
        } else if (this.rotateDrag && this.selected && this.hotspot == 5) {
            if (this.pixelSized) {
                double r = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
                double dx = x - this.x;
                double dy = y - this.y;
                this.theta = Math.atan2(r * dy, dx) - Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
            } else {
                double dx = x - this.x;
                double dy = y - this.y;
                double theta1 = Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
                double theta2 = Math.atan2(dy, dx);
                this.setTheta(theta2 - theta1);
            }
        } else if (this.widthDrag && this.selected && (this.hotspot == 2 || this.hotspot == 4)) {
            if (this.pixelSized) {
                double dx = this.toPixels.getScaleX() * (x - this.x) - this.xoff;
                double dy = this.toPixels.getScaleY() * (y - this.y) + this.yoff;
                this.setWidth(2.0 * Math.sqrt(dx * dx + dy * dy));
            } else {
                double dx = x - this.x - this.xoff;
                double dy = y - this.y - this.yoff;
                this.setWidth(2.0 * Math.sqrt(dx * dx + dy * dy));
            }
        } else if (this.heightDrag && this.selected && (this.hotspot == 3 || this.hotspot == 1)) {
            if (this.pixelSized) {
                double dx = this.toPixels.getScaleX() * (x - this.x) - this.xoff;
                double dy = this.toPixels.getScaleY() * (y - this.y) + this.yoff;
                this.setHeight(2.0 * Math.sqrt(dx * dx + dy * dy));
            } else {
                double dx = x - this.x - this.xoff;
                double dy = y - this.y - this.yoff;
                this.setHeight(2.0 * Math.sqrt(dx * dx + dy * dy));
            }
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        super.draw(panel, g);
        if (this.pixelSized) {
            this.getFixedBounds();
            if (!this.selected || this.hideBounds) {
                return;
            }
            this.drawFixedBounds(g);
        } else {
            this.getScaledBounds(panel);
            if (!this.selected || this.hideBounds) {
                return;
            }
            this.drawScaledBounds(g);
        }
    }

    private void getScaledBounds(DrawingPanel panel) {
        double ar = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
        if (this.theta == 0.0) {
            Shape temp = this.toPixels.createTransformedShape(this.getBounds2D(this.shape));
            this.pixelBounds = this.computeScaledHotSpots(temp, ar);
        } else {
            Shape temp = this.getRotateInstance(-this.theta, this.x, this.y).createTransformedShape(this.shape);
            temp = this.toPixels.createTransformedShape(temp);
            temp = this.computeScaledHotSpots(temp, ar);
            double px = ((Rectangle2D.Double)temp).getCenterX() - this.xoff * this.toPixels.getScaleX();
            double py = ((Rectangle2D.Double)temp).getCenterY() - this.yoff * this.toPixels.getScaleY();
            if (panel.isSquareAspect()) {
                this.pixelBounds = this.getRotateInstance(-this.theta, px, py).createTransformedShape(temp);
            } else {
                this.trIS.setToTranslation(px, py);
                this.trIS.scale(1.0, ar);
                this.trIS.rotate(-this.theta);
                this.trIS.scale(1.0, 1.0 / ar);
                this.trIS.translate(-px, -py);
                this.pixelBounds = this.trIS.createTransformedShape(temp);
            }
        }
    }

    private void drawScaledBounds(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[5].getX() - this.delta, (int)this.hotSpots[5].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[3].getX() - this.delta, (int)this.hotSpots[3].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[1].getX() - this.delta, (int)this.hotSpots[1].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[2].getX() - this.delta, (int)this.hotSpots[2].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[4].getX() - this.delta, (int)this.hotSpots[4].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[0].getX() - this.delta, (int)this.hotSpots[0].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[0].getX() - 1, (int)this.hotSpots[0].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        g.setColor(Color.BLACK);
    }

    private void getFixedBounds() {
        if (this.theta == 0.0) {
            Shape temp = this.getTranslateInstance(-this.x + this.pixelPt.x + this.xoff, -this.y + this.pixelPt.y - this.yoff).createTransformedShape(this.getBounds2D(this.shape));
            this.pixelBounds = this.computeFixedHotSpots(temp);
        } else {
            Shape temp = this.getTranslateInstance(-this.x + this.pixelPt.x + this.xoff, -this.y + this.pixelPt.y - this.yoff).createTransformedShape(this.shape);
            this.pixelBounds = this.getRotateInstance(-this.theta, this.pixelPt.getX(), this.pixelPt.getY()).createTransformedShape(this.computeFixedHotSpots(temp));
        }
    }

    private void drawFixedBounds(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[5].getX() - this.delta, (int)this.hotSpots[5].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[3].getX() - this.delta, (int)this.hotSpots[3].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[1].getX() - this.delta, (int)this.hotSpots[1].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[2].getX() - this.delta, (int)this.hotSpots[2].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[4].getX() - this.delta, (int)this.hotSpots[4].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[0].getX() - this.delta, (int)this.hotSpots[0].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[0].getX() - 1, (int)this.hotSpots[0].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        g.setColor(Color.BLACK);
    }

    @Override
    public String toString() {
        return "BoundedShape:\n \t shape=" + this.shapeClass + "\n \t x=" + this.x + "\n \t y=" + this.y + "\n \t width=" + this.width + "\n \t height=" + this.height + "\n \t theta=" + this.theta;
    }

    public static XML.ObjectLoader getLoader() {
        return new BoundedShapeLoader();
    }

    protected static class BoundedShapeLoader
    extends InteractiveShape.InteractiveShapeLoader {
        protected BoundedShapeLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            BoundedShape boundedShape = (BoundedShape)obj;
            control.setValue("xy drag", boundedShape.isXYDrag());
            control.setValue("width drag", boundedShape.isWidthDrag());
            control.setValue("height drag", boundedShape.isHeightDrag());
            control.setValue("rotate drag", boundedShape.isRotateDrag());
        }

        @Override
        public Object createObject(XMLControl control) {
            return new BoundedShape(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0), 0.0, 0.0);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            BoundedShape boundedShape = (BoundedShape)obj;
            boundedShape.setXYDrag(control.getBoolean("xy drag"));
            boundedShape.setWidthDrag(control.getBoolean("width drag"));
            boundedShape.setHeightDrag(control.getBoolean("height drag"));
            boundedShape.setRotateDrag(control.getBoolean("rotate drag"));
            super.loadObject(control, obj);
            return boundedShape;
        }
    }

    class XYDelegate
    extends AbstractInteractive
    implements Selectable {
        XYDelegate() {
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
        }

        @Override
        public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
            return BoundedShape.this.isInside(panel, xpix, ypix);
        }

        @Override
        public void setXY(double x, double y) {
            BoundedShape.this.setHotSpotXY(x, y);
        }

        @Override
        public void setSelected(boolean selectable) {
            BoundedShape.this.setSelected(selectable);
        }

        @Override
        public void toggleSelected() {
            BoundedShape.this.toggleSelected();
        }

        @Override
        public boolean isSelected() {
            return BoundedShape.this.isSelected();
        }

        @Override
        public Cursor getPreferredCursor() {
            return BoundedShape.this.getPreferredCursor();
        }
    }
}

