/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.BoundedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TextLine;

public class BoundedTextLine
extends BoundedImage {
    Font defaultFont = new Font("Dialog", 1, 12);
    TextLine textLine;
    int desent = 0;
    int gutter = 6;

    public BoundedTextLine(String text, double x, double y) {
        super(new BufferedImage(1, 1, 2), x, y);
        this.textLine = new TextLine(text);
        this.textLine.setFont(this.defaultFont);
        this.color = Color.BLACK;
    }

    public void setFont(Font font) {
        this.textLine.setFont(font);
    }

    public Font getFont() {
        return this.textLine.getFont();
    }

    void checkImageSize(DrawingPanel panel, Graphics g) {
        Font oldFont = g.getFont();
        Rectangle2D rect = oldFont.getStringBounds(this.textLine.text, ((Graphics2D)g).getFontRenderContext());
        this.gutter = (int)rect.getHeight() / 2;
        if (this.image.getWidth(null) != (int)rect.getWidth() + 1 || this.image.getHeight(null) != (int)rect.getHeight() + 1 + this.gutter) {
            this.image = new BufferedImage((int)rect.getWidth() + 1, (int)rect.getHeight() + 1 + this.gutter, 2);
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
            this.desent = -((int)rect.getY());
        }
        g.setFont(oldFont);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        this.checkImageSize(panel, g);
        Graphics ig = this.image.getGraphics();
        this.textLine.setColor(this.color);
        this.textLine.drawText(ig, 0, this.desent + this.gutter / 2);
        ig.dispose();
        Composite composite = ((Graphics2D)g).getComposite();
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(10));
        super.draw(panel, g);
        ((Graphics2D)g).setComposite(composite);
    }
}

