/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.CircleLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Circle
implements Drawable {
    public Color color = Color.red;
    public int pixRadius = 6;
    protected double x = 0.0;
    protected double y = 0.0;

    public Circle() {
        this(0.0, 0.0);
    }

    public Circle(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Circle(double _x, double _y, int _r) {
        this.x = _x;
        this.y = _y;
        this.pixRadius = _r;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        int xpix = panel.xToPix(this.x) - this.pixRadius;
        int ypix = panel.yToPix(this.y) - this.pixRadius;
        g.setColor(this.color);
        g.fillOval(xpix, ypix, 2 * this.pixRadius, 2 * this.pixRadius);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        String name = this.getClass().getName();
        name = String.valueOf(name.substring(1 + name.lastIndexOf("."))) + '[';
        name = String.valueOf(name) + "x=" + this.x;
        name = String.valueOf(name) + ",y=" + this.y;
        name = String.valueOf(name) + ",r_pix=" + this.pixRadius + ']';
        return name;
    }

    public static XML.ObjectLoader getLoader() {
        return new CircleLoader();
    }
}

