/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Circle;

public class CircleLoader
extends XMLLoader {
    @Override
    public void saveObject(XMLControl control, Object obj) {
        Circle circle = (Circle)obj;
        control.setValue("x", circle.x);
        control.setValue("y", circle.y);
        control.setValue("drawing r", circle.pixRadius);
        control.setValue("color", circle.color);
    }

    @Override
    public Object createObject(XMLControl control) {
        return new Circle();
    }

    @Override
    public Object loadObject(XMLControl control, Object obj) {
        Circle circle = (Circle)obj;
        circle.x = control.getDouble("x");
        circle.y = control.getDouble("y");
        int r = 6;
        if (control.getObject("drawing r") != null) {
            r = control.getInt("drawing r");
        } else if (control.getObject("r") != null) {
            r = control.getInt("r");
        }
        circle.pixRadius = r <= 0 ? 6 : r;
        circle.color = (Color)control.getObject("color");
        return obj;
    }
}

