/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;

public class DataClip
extends OSPRuntime.Supported {
    public static final String PROPERTY_DATACLIP_CLIPLENGTH = "clip_length";
    public static final String PROPERTY_DATACLIP_STARTINDEX = "clip_start";
    public static final String PROPERTY_DATACLIP_CLIPSTRIDE = "clip_stride";
    public static final String PROPERTY_DATACLIP_CLIPADJUSTING = "clip_adjusting";
    private int dataLength = 2;
    private int startIndex = 0;
    private int clipLength = 0;
    private int stride = 1;
    private boolean isAdjusting = false;

    public void setDataLength(int length) {
        this.dataLength = length = Math.max(length, 1);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int setClipLength(int length) {
        int prev = this.getClipLength();
        if ((length = Math.min(length, this.dataLength)) == this.dataLength) {
            length = 0;
        }
        this.clipLength = length;
        this.firePropertyChange(PROPERTY_DATACLIP_CLIPLENGTH, prev, this.getClipLength());
        return this.getClipLength();
    }

    public int getClipLength() {
        if (this.clipLength <= 0) {
            return this.dataLength;
        }
        return this.clipLength;
    }

    public int setStartIndex(int start) {
        int prev = this.getStartIndex();
        start = Math.max(start, 0);
        this.startIndex = start = Math.min(start, this.dataLength - 1);
        this.firePropertyChange(PROPERTY_DATACLIP_STARTINDEX, prev, start);
        return this.getStartIndex();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int setStride(int stride) {
        int prev = this.getStride();
        stride = Math.min(stride, this.dataLength - 1);
        this.stride = stride = Math.max(stride, 1);
        this.firePropertyChange(PROPERTY_DATACLIP_CLIPSTRIDE, prev, stride);
        return this.getStride();
    }

    public int getStride() {
        return this.stride;
    }

    public int getAvailableClipLength() {
        int stepCount = this.getClipLength();
        int i = stepCount - 1;
        while (i > 0) {
            if (this.stepToIndex(i) < this.dataLength) {
                return i + 1;
            }
            --i;
        }
        return 1;
    }

    public int stepToIndex(int stepNumber) {
        return this.startIndex + stepNumber * this.stride;
    }

    public int indexToStep(int index) {
        return (index - this.startIndex) / this.stride;
    }

    public boolean includesIndex(int n) {
        int stepCount = this.getClipLength();
        int i = 0;
        while (i < stepCount) {
            if (this.stepToIndex(i) == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAdjusting(boolean adjusting) {
        if (this.isAdjusting == adjusting) {
            return;
        }
        this.isAdjusting = adjusting;
        this.firePropertyChange(PROPERTY_DATACLIP_CLIPADJUSTING, this, adjusting);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DataClip clip = (DataClip)obj;
            control.setValue("start", clip.getStartIndex());
            control.setValue(DataClip.PROPERTY_DATACLIP_CLIPLENGTH, clip.getClipLength());
            control.setValue("stride", clip.getStride());
            control.setValue("data_length", clip.getDataLength());
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DataClip();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DataClip clip = (DataClip)obj;
            clip.setDataLength(control.getInt("data_length"));
            clip.setStartIndex(control.getInt("start"));
            clip.setClipLength(control.getInt(DataClip.PROPERTY_DATACLIP_CLIPLENGTH));
            clip.setStride(control.getInt("stride"));
            return obj;
        }
    }
}

