/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataAdapter;
import org.opensourcephysics.tools.Resource;

public class DataFile
extends DataAdapter {
    List<Data> dataList = null;
    protected static String[] delimiters = new String[]{" ", "\t", ",", ";"};

    public DataFile(File file) {
        super(null);
        if (file != null) {
            this.open(file);
        }
    }

    @Override
    public List<Data> getDataList() {
        return this.dataList;
    }

    public void open(File file) {
        this.dataList = null;
        this.data = null;
        OSPLog.fine("opening " + file);
        Resource res = new Resource(file);
        BufferedReader in = res.openReader();
        String firstLine = this.readFirstLine(in);
        if (firstLine.startsWith("<?xml")) {
            XMLControlElement control = new XMLControlElement(file);
            this.dataList = control.getObjects(Data.class);
        } else if (res.getString() != null) {
            this.data = this.parseData(res.getString(), file.toString());
        }
        OSPLog.finest("no data found");
    }

    public double[][] parseData(String dataString, String fileName) {
        BufferedReader input = new BufferedReader(new StringReader(dataString));
        String gnuPlotComment = "#";
        try {
            String textLine = input.readLine();
            int i = 0;
            while (i < delimiters.length) {
                ArrayList<double[]> rows = new ArrayList<double[]>();
                int columns = Integer.MAX_VALUE;
                String[] columnNames = null;
                String title = null;
                int lineCount = 0;
                while (textLine != null) {
                    int k;
                    if (textLine.contains(gnuPlotComment)) {
                        textLine = textLine.trim();
                    }
                    if (textLine.startsWith(gnuPlotComment)) {
                        int k2 = textLine.indexOf("name:");
                        if (k2 > -1) {
                            title = textLine.substring(k2 + 5).trim();
                        }
                        if ((k2 = textLine.indexOf("columnNames:")) > -1) {
                            textLine = textLine.substring(k2 + 12).trim();
                        } else {
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (textLine.indexOf("Vernier Format") > -1 || textLine.indexOf(".cmbl") > -1) {
                        textLine = input.readLine();
                        continue;
                    }
                    String[] strings = DataFile.parseStrings(textLine, delimiters[i]);
                    double[] rowData = DataFile.parseDoubles(strings);
                    if (rows.isEmpty() && strings.length > 0 && title == null) {
                        String s = "";
                        k = 0;
                        while (k < strings.length) {
                            if (Double.isNaN(rowData[k]) && !strings[k].equals("")) {
                                if (s.equals("")) {
                                    s = strings[k];
                                } else {
                                    s = "";
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (!s.equals("")) {
                            title = s;
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (rows.isEmpty() && strings.length > 0 && columnNames == null) {
                        boolean valid = true;
                        k = 0;
                        while (k < strings.length) {
                            if (!Double.isNaN(rowData[k]) || strings[k].equals("")) {
                                valid = false;
                                break;
                            }
                            ++k;
                        }
                        if (valid) {
                            columnNames = strings;
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (strings.length > 0) {
                        ++lineCount;
                        boolean validData = true;
                        boolean emptyData = true;
                        int k3 = 0;
                        while (k3 < strings.length) {
                            if (Double.isNaN(rowData[k3]) && !strings[k3].equals("")) {
                                validData = false;
                            }
                            if (!strings[k3].equals("")) {
                                emptyData = false;
                            }
                            ++k3;
                        }
                        if (rows.isEmpty() && emptyData) {
                            validData = false;
                        }
                        if (validData) {
                            rows.add(rowData);
                            columns = Math.min(rowData.length, columns);
                        }
                    }
                    if (rows.isEmpty() && lineCount > 10) break;
                    textLine = input.readLine();
                }
                if (!rows.isEmpty() && columns > 0) {
                    input.close();
                    double[][] dataArray = new double[columns][rows.size()];
                    int row = 0;
                    while (row < rows.size()) {
                        double[] next = (double[])rows.get(row);
                        int j = 0;
                        while (j < columns) {
                            dataArray[j][row] = next[j];
                            ++j;
                        }
                        ++row;
                    }
                    this.setName(title == null ? XML.getName(fileName) : title);
                    this.setColumnNames(columnNames);
                    OSPLog.finest("data found using delimiter \"" + delimiters[i] + "\"");
                    return dataArray;
                }
                input.close();
                input = new BufferedReader(new StringReader(dataString));
                textLine = input.readLine();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected String readFirstLine(Reader in) {
        String openingLine;
        BufferedReader input = null;
        input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        try {
            openingLine = input.readLine();
            while (openingLine == null || openingLine.equals("")) {
                openingLine = input.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return openingLine;
    }

    protected static String[] parseStrings(String text, String delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            String next = text;
            int i = text.indexOf(delimiter);
            if (i == -1) {
                tokens.add(DataFile.stripQuotes(next));
                text = null;
            } else {
                next = text.substring(0, i);
                text = text.substring(i + 1);
            }
            while (text != null) {
                tokens.add(DataFile.stripQuotes(next));
                i = text.indexOf(delimiter);
                if (i == -1) {
                    next = text;
                    tokens.add(DataFile.stripQuotes(next));
                    text = null;
                    continue;
                }
                next = text.substring(0, i).trim();
                text = text.substring(i + 1);
            }
        }
        return tokens.toArray(new String[0]);
    }

    protected static String[][] parseStrings(String text, String rowDelimiter, String colDelimiter) {
        String[] rows = DataFile.parseStrings(text, rowDelimiter);
        String[][] tokens = new String[rows.length][0];
        int i = 0;
        while (i < rows.length) {
            tokens[i] = DataFile.parseStrings(rows[i], colDelimiter);
            ++i;
        }
        return tokens;
    }

    protected static double[] parseDoubles(String[] strings) {
        double[] doubles = new double[strings.length];
        int i = 0;
        while (i < strings.length) {
            if (strings[i].indexOf("\t") > -1) {
                doubles[i] = Double.NaN;
            } else {
                try {
                    doubles[i] = Double.parseDouble(strings[i]);
                }
                catch (NumberFormatException e) {
                    doubles[i] = Double.NaN;
                }
            }
            ++i;
        }
        return doubles;
    }

    protected static double[][] parseDoubles(String text, String rowDelimiter, String colDelimiter) {
        String[][] strings = DataFile.parseStrings(text, rowDelimiter, colDelimiter);
        double[][] doubles = new double[strings.length][0];
        int i = 0;
        while (i < strings.length) {
            double[] row = new double[strings[i].length];
            int j = 0;
            while (j < row.length) {
                try {
                    row[j] = Double.parseDouble(strings[i][j]);
                }
                catch (NumberFormatException e) {
                    row[j] = Double.NaN;
                }
                ++j;
            }
            doubles[i] = row;
            ++i;
        }
        return doubles;
    }

    private static String stripQuotes(String text) {
        String stripped;
        int n;
        if (text.startsWith("\"") && (n = (stripped = text.substring(1)).indexOf("\"")) == stripped.length() - 1) {
            return stripped.substring(0, n);
        }
        return text;
    }

    protected static double[] getRowArray(int rowCount) {
        double[] rows = new double[rowCount];
        int i = 0;
        while (i < rowCount) {
            rows[i] = i;
            ++i;
        }
        return rows;
    }
}

