/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.display.DataRowTable;

public class DataPanel
extends JPanel {
    public DataRowTable dataRowTable = new DataRowTable();
    JScrollPane scrollPane = new JScrollPane(this.dataRowTable);

    public DataPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dataRowTable != null) {
            this.dataRowTable.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.dataRowTable != null) {
            this.dataRowTable.setForeground(color);
        }
    }

    public void refreshTable(String from) {
        this.dataRowTable.refreshTable(from);
    }

    public Component getVisual() {
        return this.dataRowTable;
    }

    public void setColumnNames(int column, String name) {
        if (this.dataRowTable.rowModel.setColumnNames(column, name)) {
            this.refreshTable("setColumnName");
        }
    }

    public void setColumnNames(String[] names) {
        boolean changed = false;
        int i = 0;
        int n = names.length;
        while (i < n) {
            if (this.dataRowTable.rowModel.setColumnNames(i, names[i])) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.refreshTable("setColumnNames");
        }
    }

    public void setRowNumberVisible(boolean vis) {
        if (this.dataRowTable.rowModel.setRowNumberVisible(vis)) {
            this.refreshTable("setRowNumberVis " + vis);
        }
    }

    public void setFirstRowIndex(int index) {
        if (this.dataRowTable.rowModel.firstRowIndex != index) {
            this.dataRowTable.rowModel.firstRowIndex = index;
            this.refreshTable("setFirstRowIndex " + index);
        }
    }

    public void setRefreshDelay(int delay) {
        this.dataRowTable.setRefreshDelay(delay);
    }

    public synchronized void appendArray(Object obj) throws IllegalArgumentException {
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("");
        }
        Class<?> componentType = obj.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        if (componentType == Double.TYPE) {
            double[][] array = (double[][])obj;
            double[] row = new double[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else if (componentType == Integer.TYPE) {
            int[][] array = (int[][])obj;
            int[] row = new int[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else if (componentType == Byte.TYPE) {
            byte[][] array = (byte[][])obj;
            byte[] row = new byte[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else {
            Object[][] array = (Object[][])obj;
            Object[] row = new Object[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        }
    }

    public synchronized void appendRow(double[] x) {
        this.dataRowTable.rowModel.appendDoubles(x);
        if (this.isShowing()) {
            this.dataRowTable.refreshTable("appendRow");
        }
    }

    public synchronized void appendRow(int[] x) {
        this.dataRowTable.rowModel.appendInts(x);
        if (this.isShowing()) {
            this.dataRowTable.refreshTable("appendRow");
        }
    }

    public synchronized void appendRow(Object[] x) {
        this.dataRowTable.rowModel.appendRow(x);
        if (this.isShowing()) {
            this.dataRowTable.refreshTable("appendRow");
        }
    }

    public synchronized void appendRow(byte[] x) {
        this.dataRowTable.rowModel.appendBytes(x);
        if (this.isShowing()) {
            this.dataRowTable.refreshTable("appendRow");
        }
    }

    public boolean isRowNumberVisible() {
        return this.dataRowTable.rowModel.rowNumberVisible;
    }

    public int getColumnCount() {
        return this.dataRowTable.rowModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataRowTable.rowModel.getRowCount();
    }

    public int getTotalRowCount() {
        return this.dataRowTable.rowModel.rowList.size();
    }

    public int getStride() {
        return this.dataRowTable.rowModel.stride;
    }

    public void setColumnFormat(int column, String format) {
        this.dataRowTable.setColumnFormat(column, format);
    }

    public void clearFormats() {
        this.dataRowTable.clearFormats();
    }

    public void setNumericFormat(String pattern) {
        this.dataRowTable.setNumericFormat(pattern);
    }

    public void setMaxPoints(int max) {
        this.dataRowTable.rowModel.setMaxPoints(max);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.dataRowTable.refreshTable(" vis " + vis);
        }
        super.setVisible(vis);
    }

    public void setStride(int stride) {
        this.dataRowTable.setStride(stride);
    }

    public void clearData() {
        this.dataRowTable.clearData();
    }

    public void clear() {
        this.dataRowTable.clear();
    }

    public void setAutoResizeMode(int mode) {
        this.dataRowTable.setAutoResizeMode(mode);
    }
}

