/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.DataRowModel;
import org.opensourcephysics.numerics.Util;

public class DataRowTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    protected int labelColumnWidth = 40;
    DataRowModel rowModel = new DataRowModel();
    RowNumberRenderer indexRenderer = new RowNumberRenderer();
    CellRenderer cellRenderer = new CellRenderer();
    String formatPattern = "0.000";
    DecimalFormat defaultFormat = Util.newDecimalFormat(this.formatPattern);
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    Dictionary<Integer, DecimalFormat> formats = new Hashtable<Integer, DecimalFormat>();

    public DataRowTable() {
        this.init();
    }

    protected void init() {
        TableColumn column;
        String name;
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(this.rowModel);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.rowModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DataRowTable.this.firePropertyChange("cell", null, e);
            }
        });
        this.setDefaultRenderer(Object.class, this.cellRenderer);
        this.getTableHeader().setForeground(Color.blue);
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.setAutoResizeMode(0);
        int width = 24;
        if (this.getColumnCount() > 0) {
            name = this.getColumnName(0);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(2 * width);
            column.setWidth(width);
        }
        width = 60;
        int i = 1;
        int n = this.getColumnCount();
        while (i < n) {
            name = this.getColumnName(i);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(3 * width);
            column.setWidth(width);
            ++i;
        }
    }

    public void setRefreshDelay(int delay) {
        if (delay > 0) {
            this.refreshTimer.setDelay(delay);
            this.refreshTimer.setInitialDelay(delay);
        } else if (delay <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = delay;
    }

    public void clearFormats() {
        this.formats = new Hashtable<Integer, DecimalFormat>();
    }

    public void setNumericFormat(String str) {
        if (str != null && !str.equals(this.formatPattern)) {
            this.formatPattern = str;
            this.defaultFormat = Util.newDecimalFormat(str);
            this.refreshTable("setNumericFormat " + str);
        }
    }

    public void setColumnFormat(int column, String format) {
        DecimalFormat f = Util.newDecimalFormat(format);
        DecimalFormat val = this.formats.get(column);
        if (val != null && val.equals(f)) {
            return;
        }
        this.formats.put(column, f);
        this.refreshTable("columnFormat");
    }

    public synchronized void clearData() {
        this.rowModel.rowList.clear();
        this.rowModel.colCount = 0;
        this.refreshTable("clearData");
    }

    public synchronized void clear() {
        this.rowModel.rowList.clear();
        this.rowModel.colNames.clear();
        this.rowModel.colCount = 0;
        this.formats = new Hashtable<Integer, DecimalFormat>();
        this.refreshTable("clear");
    }

    public void setStride(int stride) {
        if (this.rowModel.stride == (stride = Math.max(1, stride))) {
            return;
        }
        this.rowModel.setStride(stride);
        this.refreshTable("setStride");
    }

    public void refreshTable(String type) {
        this.rowModel.refreshModel(this, type);
    }

    public TableCellRenderer getCellRendererOrNull(int row, int column, boolean isScrolling) {
        return isScrolling ? null : (this.rowModel.mustPaint(row, column) ? this.getCellRenderer(row, column) : null);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.convertColumnIndexToModel(column);
        if (i == 0 && this.rowModel.rowNumberVisible) {
            return this.indexRenderer;
        }
        return this.cellRenderer;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    public void scrollToEnd() {
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public CellRenderer() {
            this.setHorizontalAlignment(4);
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
            this.setBackground(Color.WHITE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DecimalFormat f;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!DataRowTable.this.rowModel.rowNumberVisible) {
                ++column;
            }
            if ((f = DataRowTable.this.formats.get(column)) == null) {
                f = DataRowTable.this.defaultFormat;
            }
            if (value == null) {
                this.setText("");
            } else if (value instanceof String) {
                this.setText((String)value);
            } else if (f == null) {
                this.setText(value.toString());
            } else if (value instanceof Double && Double.isNaN((Double)value)) {
                this.setText("");
            } else {
                try {
                    this.setText(f.format(value));
                }
                catch (IllegalArgumentException ex) {
                    this.setText(value.toString());
                }
            }
            return this;
        }
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(columnIndex);
            }
            catch (Exception ex) {
                return new TableColumn(0);
            }
            String headerValue = (String)tableColumn.getHeaderValue();
            if (headerValue == null) {
                return tableColumn;
            }
            if (headerValue.equals("row")) {
                tableColumn.setMaxWidth(DataRowTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataRowTable.this.labelColumnWidth);
                tableColumn.setResizable(true);
            }
            return tableColumn;
        }
    }

    private class HeaderRenderer
    extends RowNumberRenderer {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setForeground(Color.BLUE);
            this.setBorder(BorderFactory.createLineBorder(new Color(224, 224, 224)));
        }
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(PANEL_BACKGROUND);
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isRowSelected(row)) {
                int[] i = table.getSelectedColumns();
                if (i.length == 1 && table.convertColumnIndexToModel(i[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            if (value == null) {
                this.setText("???");
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }
}

