/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoIO;

public class DataTable
extends JTable {
    public static final String PROPERTY_DATATABLE_FORMAT = "format";
    private static final int MODE_MASK_NEW = 15;
    public static final int MODE_CREATE = 1;
    public static final int MODE_CLEAR = 2;
    public static final int MODE_MODEL = 3;
    public static final int MODE_TAB = 4;
    private static final int MODE_MASK_TRACK = 4096;
    public static final int MODE_TRACK_REFRESH = 4352;
    public static final int MODE_TRACK_STATE = 4608;
    public static final int MODE_TRACK_STEP = 4864;
    public static final int MODE_TRACK_SELECTEDPOINT = 5120;
    public static final int MODE_TRACK_STEPS = 5376;
    public static final int MODE_TRACK_LOADED = 5632;
    public static final int MODE_COL_SETVISIBLE = 5888;
    public static final int MODE_TRACK_LOADER = 6144;
    public static final int MODE_TRACK_CHOOSE = 6400;
    public static final int MODE_TRACK_SELECT = 6656;
    public static final int MODE_TRACK_TRANSFORM = 6912;
    public static final int MODE_TRACK_DATA = 7168;
    public static final int MODE_TRACK_FUNCTION = 7424;
    public static final int MODE_TRACK_NEW = 7680;
    private static final int MODE_MASK_ROW = 8192;
    public static final int MODE_APPEND_ROW = 8448;
    public static final int MODE_INSERT_ROW = 8704;
    public static final int MODE_DELETE_ROW = 8960;
    public static final int MODE_UPDATE_ROWS = 9216;
    private static final int MODE_MASK_COL = 16384;
    public static final int MODE_COLUMN = 16640;
    public static final int MODE_CELLS = 16896;
    public static final int MODE_VALUES = 32768;
    private static final int MODE_MASK_STYLE = 0x800000;
    public static final int MODE_PATTERN = 0x810000;
    public static final int MODE_FUNCTION = 0x820000;
    public static final int MODE_FORMAT = 0x830000;
    public static final int MODE_HIGHLIGHT = 0x840000;
    public static final int MODE_SELECT = 0x1000000;
    public static final int MODE_HEADER = 0x2000000;
    public static final int MODE_SHOW = 0x4000000;
    public static final int MODE_REFRESH = 0x8000000;
    public static final int MODE_SET_TAINTED = 0x10000000;
    private static final int MODE_MASK_REBUILD = 0xF80F00F;
    public static final int MODE_CANCEL = 0;
    public static final int MODE_UNKNOWN = 0xF80F00F;
    private static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    private static final Color LIGHT_BLUE = new Color(204, 204, 255);
    protected static final String NO_PATTERN = DisplayRes.getString("DataTable.FormatDialog.NoFormat");
    public static final String rowName = DisplayRes.getString("DataTable.Header.Row");
    protected static final DoubleRenderer defaultDoubleRenderer = new DoubleRenderer();
    private HashMap<String, PrecisionRenderer> precisionRenderersByColumnName = new HashMap();
    private HashMap<String, UnitRenderer> unitRenderersByColumnName = new HashMap();
    protected OSPDataTableModel dataTableModel;
    protected RowNumberRenderer rowNumberRenderer;
    protected int maximumFractionDigits = 3;
    protected int labelColumnWidth = 40;
    protected int minimumDataColumnWidth = 24;
    protected NumberFormatDialog formatDialog;
    protected int clickCountToSort = 1;
    protected int mode;
    public boolean tainted;
    public boolean includeHeadersInCopiedData = true;
    public static final char SHIFTED = '`';
    static int test = 0;
    private static Comparator<Object[]> nCompare = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] a, Object[] b) {
            return a[0] != null && b[0] != null ? Double.compare(((Number)a[0]).doubleValue(), ((Number)b[0]).doubleValue()) : (a[0] != null ? -1 : (b[0] != null ? 1 : 0));
        }
    };
    private static Comparator<Object[]> sCompare = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] a, Object[] b) {
            return a[0] != null && b[0] != null ? a[0].toString().compareTo(b[0].toString()) : (a[0] != null ? 1 : (b[0] != null ? -1 : 0));
        }
    };

    public static String unshiftName(String name) {
        int pt = name.length() - 1;
        return pt >= 0 && name.charAt(pt) == '`' ? name.substring(0, pt) : name;
    }

    public DataTable() {
        this.init();
    }

    @Override
    public void setModel(TableModel dataModel) {
        this.dataTableModel = this.createTableModel();
        super.setModel(this.dataTableModel);
    }

    protected OSPDataTableModel createTableModel() {
        return new OSPDataTableModel();
    }

    @Override
    public void addColumnSelectionInterval(int index0, int index1) {
        this.dataTableModel.addColumnSelectionInterval(this.boundColumn(index0), this.boundColumn(index1));
    }

    protected void init() {
        this.setAutoCreateColumnsFromModel(false);
        this.setColumnModel(new DataTableColumnModel());
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader header = this.getTableHeader();
        header.setForeground(Color.blue);
        HeaderRenderer headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(headerRenderer);
        this.setSelectionForeground(Color.red);
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!(OSPRuntime.isPopupTrigger(e) || e.isControlDown() || e.isShiftDown() || e.getClickCount() != DataTable.this.clickCountToSort)) {
                    int vc = DataTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                    int mc = DataTable.this.convertColumnIndexToModel(vc);
                    if (DataTable.this.dataTableModel.getSortedColumn() != mc) {
                        DataTable.this.sort(mc);
                    }
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataTable.this.updateRowSelection(e.getFirstIndex(), e.getValueIsAdjusting());
            }
        });
    }

    protected void updateRowSelection(int firstIndex, boolean isAdjusting) {
        this.dataTableModel.setSelectedRowsFromJTable();
    }

    @Override
    public void addColumn(TableColumn c) {
        super.addColumn(c);
    }

    @Override
    public int convertColumnIndexToModel(int viewIndex) {
        return viewIndex < 0 ? viewIndex : ((DataTableColumnModel)this.getColumnModel()).convertColumnIndexToModel(viewIndex);
    }

    public void setMaximumFractionDigits(String columnName, int maximumFractionDigits) {
        this.precisionRenderersByColumnName.put(columnName, new PrecisionRenderer(maximumFractionDigits));
    }

    public void setFormatPattern(String columnName, String pattern) {
        if (pattern == null || pattern.equals("")) {
            this.precisionRenderersByColumnName.remove(columnName);
        } else {
            PrecisionRenderer renderer = this.precisionRenderersByColumnName.get(columnName);
            if (renderer == null || !pattern.equals(renderer.pattern)) {
                this.precisionRenderersByColumnName.put(columnName, new PrecisionRenderer(pattern));
            } else {
                return;
            }
        }
        this.firePropertyChange(PROPERTY_DATATABLE_FORMAT, null, columnName);
    }

    public void setUnits(String columnName, String units, String tooltip) {
        if (units == null) {
            this.unitRenderersByColumnName.remove(columnName);
        } else {
            UnitRenderer unitRenderer;
            TableCellRenderer renderer = this.precisionRenderersByColumnName.get(columnName);
            if (renderer == null) {
                renderer = this.getDefaultRenderer(Double.class);
            }
            if ((unitRenderer = this.unitRenderersByColumnName.get(columnName)) == null) {
                unitRenderer = new UnitRenderer(renderer, units, tooltip);
                this.unitRenderersByColumnName.put(columnName, unitRenderer);
            } else {
                unitRenderer.units = units;
                unitRenderer.tooltip = tooltip;
                unitRenderer.baseRenderer = renderer;
            }
        }
    }

    public String getFormatPattern(String columnName) {
        PrecisionRenderer r = this.precisionRenderersByColumnName.get(columnName);
        return r == null ? "" : r.pattern;
    }

    public String[] getFormattedColumnNames() {
        return this.precisionRenderersByColumnName.keySet().toArray(new String[0]);
    }

    public Object getFormattedValueAt(int row, int col) {
        Object value = this.getValueAt(row, col);
        if (value == null) {
            return null;
        }
        TableCellRenderer renderer = this.getCellRenderer(row, col);
        Component c = renderer.getTableCellRendererComponent(this, value, false, false, 0, col);
        if (c instanceof JLabel) {
            int n;
            String units;
            String s = ((JLabel)c).getText().trim();
            if (renderer instanceof UnitRenderer && !"".equals(units = ((UnitRenderer)renderer).units) && (n = s.lastIndexOf(units)) > -1) {
                s = s.substring(0, n);
            }
            return s;
        }
        return value;
    }

    public NumberFormatDialog getFormatDialog(String[] names, String[] selected) {
        if (this.formatDialog == null) {
            this.formatDialog = new NumberFormatDialog();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.formatDialog.getBounds().width) / 2;
            int y = (dim.height - this.formatDialog.getBounds().height) / 2;
            this.formatDialog.setLocation(x, y);
        }
        this.formatDialog.setColumns(names, selected);
        return this.formatDialog;
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.setDefaultRenderer(Double.class, new PrecisionRenderer(maximumFractionDigits));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMinimumTableWidth() {
        int n = this.getColumnCount();
        return (this.dataTableModel.rowNumberVisible ? this.labelColumnWidth - this.minimumDataColumnWidth : 0) + n * this.minimumDataColumnWidth;
    }

    public void setLabelColumnWidth(int w) {
        this.labelColumnWidth = w;
        ((DataTableColumnModel)this.getColumnModel()).invalidateWidths();
    }

    @Override
    public void resizeAndRepaint() {
        super.resizeAndRepaint();
    }

    public void setRowNumberVisible(boolean b) {
        if (this.dataTableModel.isRowNumberVisible() != b) {
            if (b && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(b);
        }
    }

    public void setColumnVisible(TableModel model, int columnIndex, boolean b) {
        this.dataTableModel.setColumnVisible(model, columnIndex, b);
    }

    public void refreshColumnModel() {
        this.dataTableModel.refreshColumnModel();
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        UnitRenderer unitRenderer = null;
        TableCellRenderer baseRenderer = null;
        try {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            if (tableColumn.getModelIndex() == 0 && this.dataTableModel.isRowNumberVisible()) {
                return this.rowNumberRenderer;
            }
            String key = (String)tableColumn.getHeaderValue();
            int k = key.indexOf("_{ ");
            if (k > 0) {
                key = key.substring(0, k);
            }
            unitRenderer = this.unitRenderersByColumnName.get(key);
            baseRenderer = tableColumn.getCellRenderer();
            if (baseRenderer == null && (baseRenderer = (TableCellRenderer)this.precisionRenderersByColumnName.get(key)) == null) {
                baseRenderer = this.precisionRenderersByColumnName.get(DataTable.unshiftName(key));
            }
        }
        catch (Exception tableColumn) {
            // empty catch block
        }
        if (baseRenderer == null) {
            Class<?> c = this.getColumnClass(column);
            TableCellRenderer tableCellRenderer = baseRenderer = c == Double.class ? defaultDoubleRenderer : this.getDefaultRenderer(c);
        }
        if (unitRenderer == null) {
            return baseRenderer;
        }
        unitRenderer.setBaseRenderer(baseRenderer);
        return unitRenderer;
    }

    public TableCellRenderer getPrecisionRenderer(String columnName) {
        return this.precisionRenderersByColumnName.get(columnName);
    }

    public void setRefreshDelay(int delay) {
    }

    public void dispose() {
        this.clear();
    }

    public void refreshTable() {
        this.refreshTable(0xF80F00F);
    }

    public void refreshTable(int mode) {
        this.refreshTableNow(mode);
    }

    protected void refreshTableNow(int mode) {
        boolean columnsChanged;
        boolean rowsChanged = false;
        int mask = this.mode = mode;
        switch (mode) {
            case 0: {
                return;
            }
            case 0x10000000: {
                this.dataTableModel.setTainted();
                return;
            }
            default: {
                this.dataTableModel.resetSort();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                mask = 15;
                columnsChanged = true;
                break;
            }
            case 4352: 
            case 4608: 
            case 5632: 
            case 6144: {
                mask = 4096;
                columnsChanged = true;
                break;
            }
            case 16640: 
            case 16896: {
                mask = 16384;
                columnsChanged = true;
                break;
            }
            case 0x8000000: {
                columnsChanged = true;
                break;
            }
            case 4864: 
            case 5376: 
            case 7168: {
                rowsChanged = true;
            }
            case 5120: 
            case 5888: 
            case 6400: 
            case 6656: 
            case 6912: 
            case 7424: 
            case 7680: {
                mask = 4096;
                columnsChanged = false;
                break;
            }
            case 8448: 
            case 8704: 
            case 8960: {
                mask = 8192;
                rowsChanged = true;
                columnsChanged = false;
                break;
            }
            case 0x810000: 
            case 0x820000: 
            case 0x830000: 
            case 0x840000: {
                mode = 0x800000;
                columnsChanged = false;
                break;
            }
            case 32768: 
            case 0x1000000: 
            case 0x2000000: 
            case 0x4000000: {
                columnsChanged = false;
            }
        }
        if (this.tainted) {
            rowsChanged = true;
            columnsChanged = true;
            this.tainted = false;
        }
        this.dataTableModel.refresh(mask);
        if (columnsChanged) {
            this.dataTableModel.fireTableStructureChanged();
        } else if (rowsChanged) {
            this.dataTableModel.fireTableRowsInserted(this.getRowCount() == 0 ? -1 : 0, this.getRowCount() - 1);
        } else {
            if (mode == 7680) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add((OSPTableModel)tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    public void sort(int col) {
        this.dataTableModel.sort(col);
    }

    public void setModelColumnOrder(int[] modelColumns) {
        ((DataTableColumnModel)this.getColumnModel()).setModelColumnOrder(modelColumns);
    }

    public int[] getModelColumnOrder() {
        return ((DataTableColumnModel)this.getColumnModel()).getModelColumnOrder();
    }

    @Override
    @Deprecated
    public void createDefaultColumnsFromModel() {
    }

    private void updateFormats() {
        try {
            for (String key : this.precisionRenderersByColumnName.keySet()) {
                PrecisionRenderer renderer = this.precisionRenderersByColumnName.get(key);
                renderer.numberFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSortedRow(int i) {
        return this.dataTableModel.getSortedRow(i);
    }

    public void resetSort() {
        this.dataTableModel.resetSort();
    }

    @Override
    public int getRowCount() {
        return this.dataTableModel.getRowCount();
    }

    protected void refreshTable(int mode, boolean resortAndReselect) {
        int col = this.dataTableModel.getSortedColumn();
        BitSet rows = this.getSelectedTableRowsBS();
        BitSet cols = this.getSelectedTableColumnsBS();
        this.refreshTableNow(mode);
        if (col >= 0) {
            switch (mode) {
                case 4864: {
                    break;
                }
                default: {
                    this.dataTableModel.resetSort();
                    this.sort(col);
                    this.selectTableRowsBS(rows, 0);
                    this.selectTableColsBS(cols);
                }
            }
        }
    }

    public void selectTableRowsBS(BitSet rows, int nRows) {
        if (nRows > 0) {
            this.removeRowSelectionInterval(0, nRows - 1);
        }
        int i = rows.nextSetBit(0);
        int j = 0;
        int n = this.getRowCount();
        while (i >= 0 && i < n) {
            j = Math.min(n, rows.nextClearBit(i + 1));
            this.addRowSelectionInterval(i, j - 1);
            i = rows.nextSetBit(j + 1);
        }
    }

    public void selectTableColsBS(BitSet cols) {
        int i = cols.nextSetBit(0);
        int j = 0;
        int n = this.getColumnCount();
        while (i >= 0 && i < n) {
            j = Math.min(n, cols.nextClearBit(i + 1));
            this.addColumnSelectionInterval(i, j - 1);
            i = cols.nextSetBit(j + 1);
        }
    }

    public void setSelectedColumnsFromModelBS() {
        BitSet bs = this.dataTableModel.selectedModelCols;
        int i = bs.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            j = bs.nextClearBit(i + 1);
            this.addColumnSelectionInterval(this.convertColumnIndexToView(i), this.convertColumnIndexToView(j));
            i = bs.nextSetBit(j + 1);
        }
    }

    public void updateColumnModel() {
        this.dataTableModel.setTainted();
        ((DataTableColumnModel)this.getColumnModel()).updateColumnModel();
    }

    private int boundColumn(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        return col;
    }

    protected int[] getSelectedModelRows() {
        return this.dataTableModel.getSelectedModelRows();
    }

    protected int getViewRow(int modelRow) {
        int col = this.convertColumnIndexToView(0);
        int i = 0;
        int n = this.getRowCount();
        while (i < n) {
            if (modelRow == (Integer)this.getValueAt(i, col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectModelRows(int[] modelRows) {
        int n = this.getRowCount();
        if (n == 0) {
            return;
        }
        if (modelRows.length == n) {
            this.addRowSelectionInterval(0, n - 1);
            return;
        }
        BitSet bs = new BitSet();
        int i = 0;
        while (i < modelRows.length) {
            int row = modelRows[i];
            if (row >= n) break;
            int j = 0;
            while (j <= n) {
                if (row == (Integer)this.dataTableModel.getValueAt(this.convertRowIndexToModel(j), 0)) {
                    bs.set(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.selectTableRowsBS(bs, n);
    }

    public void selectModelRowsBS(BitSet rows) {
        int n = this.getRowCount();
        if (n == 0) {
            return;
        }
        if (rows.cardinality() == n) {
            this.addRowSelectionInterval(0, n - 1);
            return;
        }
        BitSet bs = new BitSet();
        int i = rows.nextSetBit(0);
        while (i >= 0) {
            int j = 0;
            while (j <= n) {
                if (i == (Integer)this.dataTableModel.getValueAt(this.convertRowIndexToModel(j), 0)) {
                    bs.set(j);
                    break;
                }
                ++j;
            }
            i = rows.nextSetBit(i + 1);
        }
        this.selectTableRowsBS(bs, n);
    }

    private BitSet getSelectedTableRowsBS() {
        return DataTable.getSelectedTableBS(this.getSelectionModel());
    }

    private BitSet getSelectedTableColumnsBS() {
        return DataTable.getSelectedTableBS(this.columnModel.getSelectionModel());
    }

    private static BitSet getSelectedTableBS(ListSelectionModel sm) {
        BitSet bs = new BitSet();
        int min = sm.getMinSelectionIndex();
        int max = sm.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return bs;
        }
        int i = min;
        while (i <= max) {
            if (sm.isSelectedIndex(i)) {
                bs.set(i);
            }
            ++i;
        }
        return bs;
    }

    protected boolean haveSelectedRows() {
        return !this.dataTableModel.selectedModelRows.isEmpty();
    }

    public BitSet getSelectedModelRowsBS() {
        return this.dataTableModel.selectedModelRows;
    }

    public void setSelectedModelRowsBS(BitSet rows) {
        this.dataTableModel.selectedModelRows = rows;
    }

    protected int getModelRow(int i) {
        return this.dataTableModel.getModelRow(i);
    }

    public void scrollRowToVisible(int row) {
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    public void scrollColumnToVisible(int col) {
        this.scrollRectToVisible(this.getCellRect(0, col, true));
    }

    public StringBuffer getData(boolean asFormatted) {
        StringBuffer buf = new StringBuffer();
        int[] selectedRows = this.getSelectedRows();
        int[] selectedColumns = this.getSelectedColumns();
        int[] restoreRows = null;
        int[] restoreColumns = null;
        if (selectedRows.length == 0) {
            this.selectAll();
            restoreRows = selectedRows;
            restoreColumns = selectedColumns;
            selectedRows = this.getSelectedRows();
            selectedColumns = this.getSelectedColumns();
        }
        if (this.includeHeadersInCopiedData) {
            int j = 0;
            while (j < selectedColumns.length) {
                if (!this.isRowNumberVisible() || selectedColumns[j] != 0) {
                    String name = this.getColumnName(selectedColumns[j]);
                    name = TeXParser.removeSubscripting(name);
                    buf.append(name);
                    if (j < selectedColumns.length - 1) {
                        buf.append(VideoIO.getDelimiter());
                    }
                }
                ++j;
            }
            buf.append(XML.NEW_LINE);
        }
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.applyPattern("0.000000E0");
        nf.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        DateFormat df = DateFormat.getInstance();
        int i = 0;
        while (i < selectedRows.length) {
            int j = 0;
            while (j < selectedColumns.length) {
                int temp = this.convertColumnIndexToModel(selectedColumns[j]);
                if (!this.isRowNumberVisible() || temp != 0) {
                    Object value = null;
                    if (asFormatted) {
                        value = this.getFormattedValueAt(selectedRows[i], selectedColumns[j]);
                    } else {
                        value = this.getValueAt(selectedRows[i], selectedColumns[j]);
                        if (value != null) {
                            if (value instanceof Number) {
                                value = nf.format(value);
                            } else if (value instanceof Date) {
                                value = df.format(value);
                            }
                        }
                        if ("NaN".equals(value)) {
                            value = "";
                        }
                    }
                    if (value != null) {
                        int n = value.toString().indexOf("\u00b0");
                        if (n > 0) {
                            value = value.toString().substring(0, n);
                        }
                        buf.append(value);
                    }
                    if (j < selectedColumns.length - 1) {
                        buf.append(VideoIO.getDelimiter());
                    }
                }
                ++j;
            }
            buf.append(XML.NEW_LINE);
            ++i;
        }
        if (restoreRows != null && restoreColumns != null) {
            this.clearSelection();
            int[] nArray = restoreRows;
            int n = restoreRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                this.addRowSelectionInterval(row, row);
                ++n2;
            }
            nArray = restoreColumns;
            n = restoreColumns.length;
            n2 = 0;
            while (n2 < n) {
                int col = nArray[n2];
                this.addColumnSelectionInterval(col, col);
                ++n2;
            }
        }
        return buf;
    }

    public void copyTable(boolean asFormatted, String header) {
        StringBuffer buf = this.getData(asFormatted);
        if (!(header = header.replace(' ', '_')).endsWith(XML.NEW_LINE)) {
            header = String.valueOf(header) + XML.NEW_LINE;
        }
        if (this.includeHeadersInCopiedData) {
            OSPRuntime.copy(String.valueOf(header) + buf, null);
        } else {
            OSPRuntime.copy(buf.toString(), null);
        }
    }

    protected int findLastAddedModelIndex(StringBuffer names) {
        return -1;
    }

    public static abstract class DataModel {
        public abstract int getRowCount();

        public abstract int getColumnCount();

        public abstract String getColumnName(int var1);

        public abstract double getValueAt(int var1, int var2);
    }

    public class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        private void invalidateWidths() {
            int i = this.tableColumns.size();
            while (--i >= 0) {
                ((DataTableColumn)this.tableColumns.get(i)).isSizeSet = false;
            }
        }

        private void updateColumnModel() {
            int nTableCols = this.tableColumns.size();
            int nModelCols = DataTable.this.dataTableModel.getColumnCount();
            int i = nTableCols;
            while (--i >= 0) {
                DataTableColumn tc = this.getTableColumn(i);
                String colName = DataTable.this.getModel().getColumnName(tc.getModelIndex());
                if (colName.equals(tc.getHeaderValue())) continue;
                tc.setHeaderValue(colName);
            }
            if (nModelCols == nTableCols) {
                return;
            }
            StringBuffer names = nModelCols > nTableCols ? new StringBuffer(",") : null;
            int i2 = nTableCols;
            while (--i2 >= 0) {
                int modelIndex;
                DataTableColumn tc = this.getTableColumn(i2);
                String name = (String)tc.getHeaderValue();
                if (names != null) {
                    names.append(name).append(",");
                }
                if ((modelIndex = DataTable.this.dataTableModel.findColumn(name)) >= 0) {
                    tc.setModelIndex(modelIndex);
                    continue;
                }
                tc.removePropertyChangeListener(this);
                this.tableColumns.remove(i2);
                --nTableCols;
            }
            i2 = nTableCols;
            while (i2 < nModelCols) {
                int modelIndex = DataTable.this.findLastAddedModelIndex(names);
                DataTableColumn tc = new DataTableColumn(modelIndex < 0 ? i2 : modelIndex);
                tc.addPropertyChangeListener(this);
                this.tableColumns.add(tc);
                ++i2;
            }
            this.totalColumnWidth = -1;
            this.selectionModel.clearSelection();
            this.invalidateWidths();
        }

        public int convertColumnIndexToModel(int viewIndex) {
            if (DataTable.this.dataTableModel.getColumnCount() != this.tableColumns.size()) {
                this.updateColumnModel();
            }
            return this.getTableColumn(viewIndex).getModelIndex();
        }

        @Override
        public void addColumn(TableColumn c) {
            super.addColumn(c);
            DataTable.this.dataTableModel.columnCount = -1;
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            return columnIndex >= 0 && columnIndex < this.tableColumns.size() ? this.updateTableColumnSize(columnIndex) : new TableColumn(0);
        }

        private TableColumn updateTableColumnSize(int index) {
            DataTableColumn tableColumn = this.getTableColumn(index);
            if (!tableColumn.isSizeSet) {
                tableColumn.isSizeSet = true;
                String headerValue = (String)tableColumn.getHeaderValue();
                if (headerValue != null) {
                    if (headerValue.equals(rowName) && tableColumn.getModelIndex() == 0) {
                        tableColumn.setMaxWidth(DataTable.this.labelColumnWidth);
                        tableColumn.setMinWidth(DataTable.this.labelColumnWidth);
                        tableColumn.setResizable(false);
                    } else {
                        tableColumn.setMinWidth(DataTable.this.minimumDataColumnWidth);
                    }
                }
            }
            return tableColumn;
        }

        public DataTableColumn getTableColumn(int columnIndex) {
            return (DataTableColumn)super.getColumn(columnIndex);
        }

        private void setModelColumnOrder(int[] modelColumns) {
            this.selectionModel.clearSelection();
            int[] current = this.getModelColumnOrder();
            if (Arrays.equals(current, modelColumns)) {
                return;
            }
            int max = 0;
            int i = current.length;
            while (--i >= 0) {
                if (current[i] <= max) continue;
                max = current[i];
            }
            int[] map = new int[max + 1];
            int i2 = current.length;
            while (--i2 >= 0) {
                map[current[i2]] = i2 + 1;
            }
            Vector<DataTableColumn> newCols = new Vector<DataTableColumn>();
            BitSet mapped = new BitSet(max);
            int i3 = 0;
            int n = modelColumns.length;
            while (i3 < n) {
                int j;
                int mi = modelColumns[i3];
                int n2 = j = mi > max ? -1 : map[mi] - 1;
                if (j >= 0) {
                    DataTableColumn tc = (DataTableColumn)this.tableColumns.get(j);
                    tc.setModelIndex(mi);
                    newCols.add(tc);
                    mapped.set(j);
                }
                ++i3;
            }
            i3 = mapped.nextClearBit(0);
            n = this.tableColumns.size();
            while (i3 < n) {
                ((TableColumn)this.tableColumns.get(i3)).removePropertyChangeListener(this);
                i3 = mapped.nextClearBit(i3 + 1);
            }
            this.tableColumns = newCols;
        }

        private int[] getModelColumnOrder() {
            int n = DataTable.this.getModel().getColumnCount();
            int[] modelColumns = new int[n];
            int i = 0;
            while (i < n) {
                int d = this.getTableColumn(i).getModelIndex();
                modelColumns[i] = d == 0 ? i : d;
                ++i;
            }
            return modelColumns;
        }

        public String toString() {
            String s = "[DT columnModel ";
            int i = 0;
            while (i < this.tableColumns.size()) {
                s = String.valueOf(s) + this.getTableColumn(i).toString() + " " + "]";
                ++i;
            }
            return s;
        }

        public class DataTableColumn
        extends TableColumn {
            private boolean isSizeSet;

            private DataTableColumn(int modelIndex) {
                super(modelIndex);
                this.setHeaderValue(DataTable.this.getModel().getColumnName(modelIndex));
            }

            public String toString() {
                return "[DT column " + this.headerValue + " " + this.modelIndex + "]";
            }
        }
    }

    private static class DataTableElement
    implements TableModelListener {
        protected final OSPTableModel tableModel;
        protected int foundColumn = -1;
        protected final BitSet bsColVis = new BitSet();

        protected DataTableElement(OSPTableModel t) {
            this.tableModel = t;
            this.bsColVis.set(0, t.getColumnCount());
            if (t instanceof DatasetManager.Model) {
                t.addTableModelListener(this);
            }
        }

        protected void setColumnVisible(int columnIndex, boolean visible) {
            this.bsColVis.set(columnIndex, visible);
        }

        protected int getStride() {
            return 1;
        }

        protected int getVisibleColumnCount() {
            return this.bsColVis.cardinality();
        }

        public String toString() {
            return "DataTableElement " + this.tableModel.getRowCount() + "x" + this.tableModel.getColumnCount() + " vis=" + this.bsColVis;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.refresh();
        }

        public void refresh() {
            this.bsColVis.clear();
            int n = this.tableModel.getColumnCount();
            this.bsColVis.set(0, n);
        }
    }

    protected static class DoubleRenderer
    extends DefaultTableCellRenderer {
        NumberField numberField = new NumberField(0);

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        @Override
        public void setValue(Object value) {
            if (value == null || Double.isNaN((Double)value)) {
                this.setText("");
                return;
            }
            this.numberField.setValue((Double)value);
            this.setText(this.numberField.getText());
        }
    }

    public class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        String text = "";

        public HeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        public TableCellRenderer getBaseRenderer() {
            return this.renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String name = value == null ? "" : value.toString();
            Component c = this.renderer.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col);
            if (!(c instanceof JComponent)) {
                return c;
            }
            JComponent comp = (JComponent)c;
            int sortCol = DataTable.this.dataTableModel.getSortedColumn();
            Font font = comp.getFont();
            boolean isSortedCol = sortCol == DataTable.this.convertColumnIndexToModel(col);
            comp.setFont(!isSortedCol ? font.deriveFont(0) : font.deriveFont(1));
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                label.setHorizontalAlignment(0);
                if (label.getText().indexOf("{") >= 0) {
                    String s = TeXParser.toHTML(label.getText());
                    label.setText(s);
                }
                if (isSortedCol) {
                    font = label.getFont();
                    HashMap attributes = new HashMap(font.getAttributes());
                    attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    label.setFont(font.deriveFont(attributes));
                }
            }
            return comp;
        }
    }

    public class NumberFormatDialog
    extends JDialog {
        JButton closeButton;
        JButton cancelButton;
        JButton helpButton;
        JButton applyButton;
        JLabel patternLabel;
        JLabel sampleLabel;
        JTextField patternField;
        JTextField sampleField;
        DecimalFormat sampleFormat;
        String[] displayedNames;
        Map<String, String> realNames;
        Map<String, String> prevPatterns;
        JList<String> columnList;
        JScrollPane columnScroller;

        private NumberFormatDialog() {
            super(JOptionPane.getFrameForComponent(DataTable.this), true);
            this.realNames = new HashMap<String, String>();
            this.prevPatterns = new HashMap<String, String>();
            this.setLayout(new BorderLayout());
            this.setTitle(DisplayRes.getString("DataTable.NumberFormat.Dialog.Title"));
            this.sampleFormat = (DecimalFormat)NumberFormat.getNumberInstance();
            this.closeButton = new JButton(DisplayRes.getString("Dialog.Button.Close.Text"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.applyButton = new JButton(DisplayRes.getString("Dialog.Button.Apply.Text"));
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.this.formatAction();
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] stringArray = NumberFormatDialog.this.displayedNames;
                    int n = NumberFormatDialog.this.displayedNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String displayedName = stringArray[n2];
                        String name = NumberFormatDialog.this.realNames.get(displayedName);
                        DataTable.this.setFormatPattern(name, NumberFormatDialog.this.prevPatterns.get(name));
                        ++n2;
                    }
                    NumberFormatDialog.this.setVisible(false);
                    DataTable.this.refreshTableNow(0);
                }
            });
            this.helpButton = new JButton(DisplayRes.getString("GUIUtils.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String tab = "      ";
                    String nl = System.getProperty("line.separator", "/n");
                    JOptionPane.showMessageDialog(((NumberFormatDialog)NumberFormatDialog.this).DataTable.this.formatDialog, String.valueOf(DisplayRes.getString("DataTable.NumberFormat.Help.Message1")) + nl + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message2") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message3") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message4") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message5") + nl + nl + DisplayRes.getString("DataTable.NumberFormat.Help.Message6") + " PI.", DisplayRes.getString("DataTable.NumberFormat.Help.Title"), 1);
                }
            });
            this.patternLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Format"));
            this.sampleLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Sample"));
            this.patternField = new JTextField(6);
            this.patternField.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.this.formatAction();
                }
            });
            this.patternField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        NumberFormatDialog.this.patternField.setBackground(Color.white);
                    } else {
                        NumberFormatDialog.this.patternField.setBackground(Color.yellow);
                        SwingUtilities.invokeLater(() -> NumberFormatDialog.this.updatePatternAction());
                    }
                }
            });
            this.patternField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    NumberFormatDialog.this.formatAction();
                }
            });
            this.sampleField = new JTextField(6);
            this.sampleField.setEditable(false);
            this.columnScroller = new JScrollPane();
            this.columnScroller.setPreferredSize(new Dimension(160, 120));
            JPanel formatPanel = new JPanel(new GridLayout());
            JPanel patternPanel = new JPanel();
            patternPanel.add(this.patternLabel);
            patternPanel.add(this.patternField);
            formatPanel.add(patternPanel);
            JPanel samplePanel = new JPanel();
            samplePanel.add(this.sampleLabel);
            samplePanel.add(this.sampleField);
            formatPanel.add(samplePanel);
            this.add((Component)formatPanel, "North");
            JPanel columnPanel = new JPanel(new BorderLayout());
            columnPanel.setBorder(BorderFactory.createTitledBorder(DisplayRes.getString("DataTable.FormatDialog.ApplyTo.Title")));
            columnPanel.add((Component)this.columnScroller, "Center");
            this.add((Component)columnPanel, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.helpButton);
            buttonPanel.add(this.applyButton);
            buttonPanel.add(this.closeButton);
            buttonPanel.add(this.cancelButton);
            this.add((Component)buttonPanel, "South");
            this.pack();
        }

        protected void updatePatternAction() {
            String pattern = this.patternField.getText();
            if (pattern.indexOf(NO_PATTERN) > -1) {
                pattern = "";
            }
            int i = 1;
            while (i < 10) {
                pattern = pattern.replaceAll(String.valueOf(i), "0");
                ++i;
            }
            i = pattern.indexOf("0e0");
            if (i > -1) {
                pattern = String.valueOf(pattern.substring(0, i)) + "0E0" + pattern.substring(i + 3);
            }
            if (pattern.equals("") || pattern.equals(NO_PATTERN)) {
                TableCellRenderer renderer = DataTable.this.getDefaultRenderer(Double.class);
                Component c = renderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                if (c instanceof JLabel) {
                    String text = ((JLabel)c).getText();
                    this.sampleField.setText(text);
                }
            } else {
                try {
                    this.sampleFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
                    this.sampleFormat.applyPattern(pattern);
                    this.sampleField.setText(this.sampleFormat.format(Math.PI));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void formatAction() {
            String pattern = this.patternField.getText();
            if (pattern.indexOf(NO_PATTERN) > -1) {
                pattern = "";
            }
            int i = 1;
            while (i < 10) {
                pattern = pattern.replaceAll("" + i, "0");
                ++i;
            }
            i = pattern.indexOf("0e0");
            if (i > -1) {
                pattern = String.valueOf(pattern.substring(0, i)) + "0E0" + pattern.substring(i + 3);
            }
            try {
                this.showNumberFormatAndSample(pattern);
                List<String> selectedColumns = this.columnList.getSelectedValuesList();
                for (String displayedName : selectedColumns) {
                    String name = this.realNames.get(displayedName.toString());
                    DataTable.this.setFormatPattern(name, pattern);
                }
                DataTable.this.refreshTableNow(0x810000);
            }
            catch (RuntimeException ex) {
                this.patternField.setBackground(new Color(255, 153, 153));
                this.patternField.setText(pattern);
            }
        }

        private void showNumberFormatAndSample(int[] selectedIndices) {
            if (selectedIndices == null || selectedIndices.length == 0) {
                this.showNumberFormatAndSample("");
            } else if (selectedIndices.length == 1) {
                String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
                String pattern = DataTable.this.getFormatPattern(name);
                this.showNumberFormatAndSample(pattern);
            } else {
                String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
                String pattern = DataTable.this.getFormatPattern(name);
                int i = 1;
                while (i < selectedIndices.length) {
                    name = this.realNames.get(this.displayedNames[selectedIndices[i]]);
                    if (!pattern.equals(DataTable.this.getFormatPattern(name))) {
                        pattern = null;
                        break;
                    }
                    ++i;
                }
                this.showNumberFormatAndSample(pattern);
            }
        }

        private void showNumberFormatAndSample(String pattern) {
            if (pattern == null) {
                this.sampleField.setText("");
                this.patternField.setText("");
                return;
            }
            if (pattern.equals("") || pattern.equals(NO_PATTERN)) {
                TableCellRenderer renderer = DataTable.this.getDefaultRenderer(Double.class);
                Component c = renderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                if (c instanceof JLabel) {
                    String text = ((JLabel)c).getText();
                    this.sampleField.setText(text);
                }
                this.patternField.setText(NO_PATTERN);
            } else {
                this.sampleFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
                this.sampleFormat.applyPattern(pattern);
                this.sampleField.setText(this.sampleFormat.format(Math.PI));
                this.patternField.setText(pattern);
            }
        }

        private void setColumns(String[] names, String[] selected) {
            int j;
            this.displayedNames = new String[names.length];
            this.realNames.clear();
            int i = 0;
            while (i < names.length) {
                String s = TeXParser.removeSubscripting(names[i]);
                this.displayedNames[i] = "   " + s + " ";
                this.realNames.put(this.displayedNames[i], names[i]);
                if (selected != null) {
                    j = 0;
                    while (j < selected.length) {
                        if (selected[j] != null && selected[j].equals(names[i])) {
                            selected[j] = this.displayedNames[i];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.prevPatterns.clear();
            String[] stringArray = names;
            j = names.length;
            int s = 0;
            while (s < j) {
                String name = stringArray[s];
                this.prevPatterns.put(name, DataTable.this.getFormatPattern(name));
                ++s;
            }
            this.columnList = new JList<String>(this.displayedNames);
            this.columnList.setLayoutOrientation(2);
            this.columnList.setVisibleRowCount(-1);
            this.columnList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.columnList.getSelectedIndices());
                }
            });
            this.columnScroller.setViewportView(this.columnList);
            this.pack();
            int[] indices = null;
            if (selected != null) {
                indices = new int[selected.length];
                int j2 = 0;
                while (j2 < indices.length) {
                    int i2 = 0;
                    while (i2 < this.displayedNames.length) {
                        if (this.displayedNames[i2].equals(selected[j2])) {
                            indices[j2] = i2;
                            break;
                        }
                        ++i2;
                    }
                    ++j2;
                }
                this.columnList.setSelectedIndices(indices);
            } else {
                this.showNumberFormatAndSample(indices);
            }
        }
    }

    protected class OSPDataTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private final ArrayList<DataTableElement> dataTableElements;
        boolean rowNumberVisible;
        private SortDecorator decorator;
        protected TableModelEvent lastModelEvent;
        protected int columnCount;
        private int rowCount;
        protected boolean haveColumnClasses = true;
        private BitSet selectedModelRows = new BitSet();
        private BitSet selectedModelCols = new BitSet();
        private TableModel foundModel;

        protected OSPDataTableModel() {
            this.dataTableElements = new ArrayList();
            this.decorator = new SortDecorator();
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    OSPDataTableModel.this.setTainted();
                    OSPDataTableModel.this.decorator.reset();
                }
            });
        }

        protected void setTainted() {
            this.rowCount = -1;
            this.columnCount = -1;
            DataTable.this.tainted = true;
        }

        public void setColumnSelectionFromJTable() {
            this.selectedModelCols.clear();
            int[] selected = DataTable.this.getSelectedColumns();
            int labelCol = DataTable.this.convertColumnIndexToView(0);
            int i = 0;
            while (i < selected.length) {
                if (selected[i] != labelCol) {
                    this.selectedModelCols.set(DataTable.this.convertColumnIndexToModel(selected[i]));
                }
                ++i;
            }
            if (this.selectedModelCols.isEmpty() || this.selectedModelRows.isEmpty()) {
                DataTable.this.clearSelection();
            }
        }

        public void setSelectedRowsFromJTable() {
            this.selectedModelRows.clear();
            BitSet bs = DataTable.this.getSelectedTableRowsBS();
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.selectedModelRows.set(this.getModelRow(i));
                i = bs.nextSetBit(i + 1);
            }
        }

        protected int getModelRow(int row) {
            return this.decorator.getModelRow(row);
        }

        protected void addColumnSelectionInterval(int coli, int colj) {
            DataTable.this.columnModel.getSelectionModel().addSelectionInterval(coli, colj);
            int labelCol = DataTable.this.convertColumnIndexToView(0);
            this.selectedModelCols.clear();
            int[] selected = DataTable.this.getSelectedColumns();
            int i = 0;
            while (i < selected.length) {
                if (selected[i] != labelCol) {
                    int modelCol = DataTable.this.convertColumnIndexToModel(selected[i]);
                    this.selectedModelCols.set(modelCol);
                }
                ++i;
            }
            if (this.selectedModelCols.isEmpty()) {
                DataTable.this.clearSelection();
            }
        }

        protected DataTableElement find(int icol) {
            if (this.rowNumberVisible) {
                --icol;
            }
            int i = 0;
            int ncol = 0;
            int n = this.dataTableElements.size();
            while (i < n) {
                DataTableElement dte = this.dataTableElements.get(i);
                int nvis = dte.getVisibleColumnCount();
                if (ncol + nvis > icol) {
                    i = icol - ncol;
                    BitSet bs = dte.bsColVis;
                    int j = ncol;
                    while (j < icol) {
                        if (!bs.get(j - ncol)) {
                            ++i;
                        }
                        ++j;
                    }
                    dte.foundColumn = i;
                    this.foundModel = dte.tableModel;
                    return dte;
                }
                ncol += nvis;
                ++i;
            }
            this.foundModel = null;
            return null;
        }

        protected void sort(int col) {
            DataTableElement dte;
            if (col < 0 || this.dataTableElements.size() == 0 || (dte = this.find(col)) == null) {
                return;
            }
            dte.tableModel.getValueAt(0, dte.foundColumn);
            this.decorator.sort(dte, col);
        }

        public int getSortedColumn() {
            return this.decorator.getSortedColumn();
        }

        protected void resetSort() {
            this.decorator.reset();
        }

        protected int getSortedRow(int j) {
            return this.decorator.getSortedRow(j);
        }

        protected void setColumnVisible(TableModel model, int columnIndex, boolean b) {
            DataTableElement dte = this.findElementContaining(model);
            dte.setColumnVisible(columnIndex, b);
        }

        protected void refreshColumnModel() {
            int i = this.dataTableElements.size();
            while (--i >= 0) {
                this.dataTableElements.get(i).refresh();
            }
        }

        public void setRowNumberVisible(boolean b) {
            this.rowNumberVisible = b;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.decorator.setValueAt(value, rowIndex, columnIndex);
        }

        protected void setElementValue(Object value, int rowIndex, int columnIndex) {
            if (this.dataTableElements.size() == 0 || this.rowNumberVisible && columnIndex == 0) {
                return;
            }
            DataTableElement dte = this.find(columnIndex);
            int stride = dte.getStride();
            if ((rowIndex *= stride) >= dte.tableModel.getRowCount()) {
                return;
            }
            dte.tableModel.setValueAt(value, rowIndex, dte.foundColumn);
        }

        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return "unknown";
            }
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return rowName;
            }
            DataTableElement dte = this.find(columnIndex);
            return dte.tableModel.getColumnName(dte.foundColumn);
        }

        @Override
        public synchronized int getRowCount() {
            if (this.rowCount > 0) {
                return this.rowCount;
            }
            int n = 0;
            int i = this.dataTableElements.size();
            while (--i >= 0) {
                DataTableElement dte = this.dataTableElements.get(i);
                int stride = dte.getStride();
                n = Math.max(n, (dte.tableModel.getRowCount() + stride - 1) / stride);
            }
            this.rowCount = n;
            return this.rowCount;
        }

        @Override
        public synchronized int getColumnCount() {
            if (this.columnCount >= 0) {
                return this.columnCount;
            }
            int n = 0;
            int i = this.dataTableElements.size();
            while (--i >= 0) {
                n += this.dataTableElements.get(i).getVisibleColumnCount();
            }
            this.columnCount = this.rowNumberVisible ? n + 1 : n;
            return this.columnCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.decorator.getValueAt(rowIndex, columnIndex);
        }

        protected Object getElementValue(int rowIndex, int columnIndex) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return rowIndex;
            }
            DataTableElement dte = this.find(columnIndex);
            int stride = dte.getStride();
            if ((rowIndex *= stride) >= dte.tableModel.getRowCount()) {
                return null;
            }
            return dte.tableModel.getValueAt(rowIndex, dte.foundColumn);
        }

        protected Object[] getElementValues(DataTableElement dte, int columnIndex, Object[] objects) {
            boolean asRow = this.rowNumberVisible && columnIndex == 0;
            int stride = dte.getStride();
            int i = 0;
            int rowIndex = 0;
            int n = objects.length;
            int nr = dte.tableModel.getRowCount();
            while (i < n && rowIndex < nr) {
                objects[i] = asRow ? Integer.valueOf(rowIndex) : dte.tableModel.getValueAt(i, dte.foundColumn);
                ++i;
                rowIndex += stride;
            }
            return objects;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex >= this.getColumnCount()) {
                return Object.class;
            }
            if (!this.haveColumnClasses) {
                return super.getColumnClass(columnIndex);
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return Integer.class;
            }
            DataTableElement dte = this.find(columnIndex);
            return dte.tableModel.getColumnClass(dte.foundColumn);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex < this.getColumnCount() && this.isElementEditable(rowIndex, columnIndex);
        }

        protected boolean isElementEditable(int row, int col) {
            return false;
        }

        public void remove(TableModel tableModel) {
            tableModel.removeTableModelListener(this);
            this.dataTableElements.remove(this.findElementContaining(tableModel));
        }

        public void clear() {
            int i = this.dataTableElements.size();
            while (--i >= 0) {
                this.dataTableElements.get((int)i).tableModel.removeTableModelListener(this);
            }
            this.dataTableElements.clear();
        }

        protected void add(OSPTableModel tableModel) {
            this.setTainted();
            this.dataTableElements.add(new DataTableElement(tableModel));
            tableModel.addTableModelListener(this);
        }

        protected DataTableElement findElementContaining(TableModel tableModel) {
            int i = this.dataTableElements.size();
            while (--i >= 0) {
                DataTableElement dte = this.dataTableElements.get(i);
                if (dte.tableModel != tableModel) continue;
                return dte;
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.lastModelEvent = e;
        }

        public boolean isFoundOrdered() {
            return this.foundModel != null && this.foundModel instanceof Dataset && ((Dataset)((Object)this.foundModel)).model.isFoundOrdered();
        }

        protected void refresh(int mask) {
            switch (mask) {
                default: {
                    String type = "rebuild";
                    break;
                }
                case 15: {
                    String type = "new";
                    break;
                }
                case 4096: {
                    String type = "track";
                    break;
                }
                case 0x2000000: {
                    String type = "header";
                    break;
                }
                case 8192: {
                    String type = "row";
                    break;
                }
                case 16384: {
                    String type = "col";
                    break;
                }
                case 32768: {
                    String type = "values";
                    break;
                }
                case 0x800000: {
                    String type = "style";
                    break;
                }
                case 0x1000000: {
                    String type = "select";
                    break;
                }
                case 0x4000000: {
                    String type = "show";
                }
            }
            DataTable.this.updateFormats();
            DataTable.this.updateColumnModel();
        }

        protected int[] getSelectedModelRows() {
            int[] rows = new int[this.selectedModelRows.cardinality()];
            int pt = 0;
            int i = this.selectedModelRows.nextSetBit(0);
            while (i >= 0) {
                rows[pt++] = i;
                i = this.selectedModelRows.nextSetBit(i + 1);
            }
            return rows;
        }

        private class SortDecorator {
            private int[] viewRowToModel = new int[0];
            private int[] modelToViewRow = new int[0];
            private int sortedColumn;

            private SortDecorator() {
            }

            protected int getModelRow(int row) {
                return this.viewRowToModel[row];
            }

            protected int getSortedRow(int realModelRow) {
                if (realModelRow >= OSPDataTableModel.this.rowCount) {
                    OSPDataTableModel.this.setTainted();
                }
                this.allocate(realModelRow);
                return this.modelToViewRow[realModelRow];
            }

            protected Object getValueAt(int viewRow, int viewCol) {
                if (viewCol >= OSPDataTableModel.this.getColumnCount()) {
                    return null;
                }
                this.allocate(viewRow);
                return OSPDataTableModel.this.getElementValue(this.viewRowToModel[viewRow], viewCol);
            }

            protected void setValueAt(Object aValue, int viewRow, int viewCol) {
                this.allocate(viewRow);
                OSPDataTableModel.this.setElementValue(aValue, this.viewRowToModel[viewRow], viewCol);
            }

            protected void sort(DataTableElement dte, int column) {
                if (dte.tableModel.isFoundOrdered()) {
                    this.allocate(Integer.MAX_VALUE);
                    this.sortedColumn = column;
                    return;
                }
                this.sortedColumn = column;
                this.allocate(Integer.MAX_VALUE);
                try {
                    Object[] data = OSPDataTableModel.this.getElementValues(dte, column, new Object[OSPDataTableModel.this.rowCount]);
                    Object[][] sortArray = new Object[OSPDataTableModel.this.rowCount][2];
                    int i = 0;
                    while (i < OSPDataTableModel.this.rowCount) {
                        sortArray[i][0] = data[i];
                        sortArray[i][1] = this.viewRowToModel[i];
                        ++i;
                    }
                    Class<?> c = OSPDataTableModel.this.getColumnClass(column);
                    if (Number.class.isAssignableFrom(c)) {
                        Arrays.sort(sortArray, nCompare);
                    } else {
                        Arrays.sort(sortArray, sCompare);
                    }
                    int i2 = 0;
                    while (i2 < OSPDataTableModel.this.rowCount) {
                        this.viewRowToModel[i2] = (Integer)sortArray[i2][1];
                        ++i2;
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }

            protected int getSortedColumn() {
                return this.sortedColumn;
            }

            private void allocate(int min) {
                if (this.viewRowToModel.length <= min) {
                    int n = OSPDataTableModel.this.getRowCount();
                    this.viewRowToModel = new int[n];
                    this.modelToViewRow = new int[n];
                    int i = 0;
                    while (i < this.viewRowToModel.length) {
                        this.viewRowToModel[i] = this.modelToViewRow[i] = i;
                        ++i;
                    }
                }
            }

            protected void reset() {
                this.allocate(Integer.MAX_VALUE);
                this.sortedColumn = -1;
            }
        }
    }

    public static abstract class OSPTableModel
    extends AbstractTableModel {
        public int getStride() {
            return 1;
        }

        public boolean isFoundOrdered() {
            return false;
        }
    }

    protected static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getInstance();
        String pattern;

        private PrecisionRenderer(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        private PrecisionRenderer(String pattern) {
            this.numberFormat.applyPattern(pattern);
            this.pattern = pattern;
            this.setHorizontalAlignment(4);
        }

        public void setPrecision(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null || value.toString().equals("NaN") ? "" : this.numberFormat.format(value));
        }
    }

    protected static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        private RowNumberRenderer(JTable _table) {
            this.table = _table;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isRowSelected(row)) {
                int[] i = table.getSelectedColumns();
                if (i.length == 1 && table.convertColumnIndexToModel(i[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(value.toString());
            return this;
        }
    }

    protected static class UnitRenderer
    implements TableCellRenderer {
        private TableCellRenderer baseRenderer;
        private String units;
        private String tooltip;

        private UnitRenderer(TableCellRenderer renderer, String units, String tooltip) {
            this.units = units;
            this.tooltip = tooltip;
            this.setBaseRenderer(renderer);
        }

        private void setBaseRenderer(TableCellRenderer renderer) {
            this.baseRenderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel && this.units != null) {
                JLabel label = (JLabel)c;
                String s = label.getText();
                if (s != null && !s.equals("")) {
                    label.setText(String.valueOf(s) + this.units);
                }
                label.setToolTipText(this.tooltip);
            }
            return c;
        }
    }
}

