/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.TableModelEvent;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;

public class Dataset
extends DataTable.DataModel
implements Measurable,
LogMeasurable,
Data {
    public final Model model;
    protected static int id = 0;
    protected int datasetID = this.hashCode();
    protected int columnID = 0;
    public static final int NO_MARKER = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int AREA = 5;
    public static final int PIXEL = 6;
    public static final int BAR = 7;
    public static final int POST = 8;
    public static final int CUSTOM = -1;
    public static double maxPointsMultiplier = 1.0;
    private static int defaultMaxPoints = 16384;
    int foundColumn = 0;
    protected double[] xpoints = new double[10];
    protected double[] ypoints = new double[10];
    protected double shift;
    protected GeneralPath generalPath;
    protected double xmax;
    protected double ymax;
    protected double xmin;
    protected double ymin;
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    protected int index;
    protected boolean sorted = false;
    private static final Rectangle2D.Double tmpRect = new Rectangle2D.Double();
    public int update = ++id;
    private static final int initialSize = 10;
    private int markerSize = 2;
    private int markerShape = 2;
    private Color lineColor;
    private Color fillColor;
    private Color edgeColor;
    private Color errorBarColor;
    private boolean connected;
    private String name = null;
    private String xColumnName;
    private String yColumnName;
    protected String xColumnDescription;
    protected String yColumnDescription;
    private BitSet bsColVis = new BitSet();
    protected boolean visible = true;
    protected int maxPoints = defaultMaxPoints;
    protected ArrayList<ErrorBar> errorBars = new ArrayList();
    protected Shape customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);
    private Shape myShape;
    private AffineTransform pixelTransform;
    private AffineTransform trD = new AffineTransform();

    private void updateID() {
        this.update = ++id;
    }

    public Dataset() {
        this(Color.black, Color.black, false);
    }

    public Dataset(Color _markerColor) {
        this(_markerColor, Color.black, false);
    }

    public Dataset(Color markerColor, Color _lineColor, boolean _connected) {
        this.fillColor = markerColor;
        this.edgeColor = markerColor;
        this.errorBarColor = markerColor;
        this.lineColor = _lineColor;
        this.connected = _connected;
        this.markerSize = 2;
        this.xColumnName = "x";
        this.yColumnName = "y";
        this.generalPath = new GeneralPath();
        this.index = 0;
        this.bsColVis.set(0, 2);
        this.clear();
        this.model = new Model();
    }

    public Dataset set(double[] x, double[] y) {
        this.clear();
        this.append(x, y, y.length);
        return this;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    public void setColumnID(int id) {
        this.columnID = id;
    }

    public int getColumnID() {
        return this.columnID;
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
        if (this.connected) {
            this.recalculatePath();
        }
    }

    public void setMarkerColor(Color markerColor) {
        this.fillColor = markerColor;
        this.edgeColor = markerColor;
        this.errorBarColor = markerColor;
    }

    public void setMarkerColor(Color _fillColor, Color _edgeColor) {
        this.fillColor = _fillColor;
        this.edgeColor = _edgeColor;
        this.errorBarColor = _edgeColor;
    }

    public void setMarkerColor(Color _fillColor, Color _edgeColor, Color _errorBarColor) {
        this.fillColor = _fillColor;
        this.edgeColor = _edgeColor;
        this.errorBarColor = _errorBarColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{Color.BLACK, this.fillColor};
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.lineColor};
    }

    public void setCustomMarker(Shape marker) {
        this.customMarker = marker;
        if (this.customMarker == null) {
            this.markerShape = 2;
            this.customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);
        } else {
            this.markerShape = -1;
        }
    }

    public void setMarkerShape(int _markerShape) {
        this.markerShape = _markerShape;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerSize(int _markerSize) {
        this.markerSize = _markerSize;
    }

    public void setMaximumPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setLineColor(Color _lineColor) {
        this.lineColor = _lineColor;
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName) {
        this.xColumnName = TeXParser.parseTeX(_xColumnName);
        this.yColumnName = TeXParser.parseTeX(_yColumnName);
    }

    public void setXYColumnNames(String xColumnName, String yColumnName, String name) {
        this.setXYColumnNames(xColumnName, yColumnName);
        this.name = TeXParser.parseTeX(name);
    }

    public String getXColumnName() {
        return this.xColumnName;
    }

    public String getYColumnName() {
        return this.yColumnName;
    }

    public String getXColumnDescription() {
        return this.xColumnDescription;
    }

    public void setXColumnDescription(String desc) {
        this.xColumnDescription = desc;
    }

    public String getYColumnDescription() {
        return this.yColumnDescription;
    }

    public void setYColumnDescription(String desc) {
        this.yColumnDescription = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.xColumnName, this.yColumnName};
    }

    @Override
    public boolean isMeasured() {
        if (this.visible) {
            return this.ymin < Double.MAX_VALUE;
        }
        return false;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    @Override
    public double getXMinLogscale() {
        return this.xminLogscale;
    }

    @Override
    public double getXMaxLogscale() {
        return this.xmaxLogscale;
    }

    @Override
    public double getYMinLogscale() {
        return this.yminLogscale;
    }

    @Override
    public double getYMaxLogscale() {
        return this.ymaxLogscale;
    }

    public double[][] getPoints() {
        double[][] temp = new double[this.index][2];
        double[] xValues = this.xpoints;
        double[] yValues = this.ypoints;
        double shift = this.isShifted() ? this.shift : 0.0;
        int i = 0;
        while (i < this.index) {
            temp[i] = new double[]{xValues[i], yValues[i] + shift};
            ++i;
        }
        return temp;
    }

    public boolean isShifted() {
        return false;
    }

    public void setShifted(boolean shifted) {
        throw new UnsupportedOperationException();
    }

    public boolean setShift(double shift) {
        throw new UnsupportedOperationException();
    }

    public double getShift() {
        return 0.0;
    }

    public boolean setShiftedValue(int i, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getData2D() {
        double[][] data = new double[2][this.index];
        data[0] = this.getXPoints();
        data[1] = this.getYPoints();
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        list.add(this);
        return list;
    }

    public final double[] getXPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.xpoints, 0, temp, 0, this.index);
        return temp;
    }

    public final double[] getXPointsRaw() {
        return this.xpoints;
    }

    public double getYShifted(int i) {
        return this.isShifted() ? this.ypoints[i] + this.shift : this.ypoints[i];
    }

    public double[] getYPoints() {
        double[] temp = new double[this.index];
        if (this.isShifted()) {
            int i = 0;
            while (i < this.index) {
                temp[i] = this.ypoints[i] + this.shift;
                ++i;
            }
        } else {
            System.arraycopy(this.ypoints, 0, temp, 0, this.index);
        }
        return temp;
    }

    public final double[] getYPointsRaw() {
        return this.isShifted() ? this.getYPoints() : this.ypoints;
    }

    public double getY(int i) {
        return this.ypoints[i];
    }

    public double[] getValidXPoints() {
        return this.getValidPoints(this.xpoints);
    }

    public double[] getValidYPoints() {
        return this.getValidPoints(this.ypoints);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getColumnCount() {
        return this.bsColVis.cardinality();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getRowCount() {
        return (this.index + this.model.stride - 1) / this.model.stride;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return Dataset.convertTableColumnIndex(this.bsColVis, columnIndex) == 0 ? this.xColumnName : this.yColumnName;
    }

    @Override
    public double getValueAt(int rowIndex, int columnIndex) {
        this.foundColumn = columnIndex = Dataset.convertTableColumnIndex(this.bsColVis, columnIndex);
        rowIndex *= this.model.stride;
        if (columnIndex == 0) {
            return this.xpoints[rowIndex];
        }
        return this.ypoints[rowIndex] + this.shift;
    }

    public void append(double x, double y, double delx, double dely) {
        this.errorBars.add(new ErrorBar(x, y, delx, dely));
        this.append(x, y);
    }

    public void append(double x, double y) {
        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isInfinite(y)) {
            return;
        }
        this.updateID();
        this.myShape = null;
        if (this.addSorted(x, y)) {
            this.recalculatePath();
        }
    }

    private boolean addSorted(double x, double y) {
        if (!Double.isNaN(y)) {
            Point2D curPt = this.generalPath.getCurrentPoint();
            if (curPt == null) {
                this.generalPath.moveTo((float)x, (float)y);
            } else {
                this.generalPath.lineTo((float)x, (float)y);
            }
            this.ymax = Math.max(y, this.ymax);
            this.ymin = Math.min(y, this.ymin);
            if (y > 0.0) {
                this.ymaxLogscale = Math.max(y, this.ymaxLogscale);
                this.yminLogscale = Math.min(y, this.yminLogscale);
            }
        }
        this.xmax = Math.max(x, this.xmax);
        this.xmin = Math.min(x, this.xmin);
        if (x > 0.0) {
            this.xmaxLogscale = Math.max(x, this.xmaxLogscale);
            this.xminLogscale = Math.min(x, this.xminLogscale);
        }
        if (this.index >= this.xpoints.length) {
            this.increaseCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = x;
        this.ypoints[this.index] = y;
        if (++this.index > 1 && this.sorted && this.xpoints[this.index - 2] > x) {
            Dataset.moveDatum(this.xpoints, this.ypoints, this.index - 1);
            return true;
        }
        return false;
    }

    public void append(double[] xpoints, double[] ypoints, double[] delx, double[] dely) {
        int i = 0;
        int n = xpoints.length;
        while (i < n) {
            this.errorBars.add(new ErrorBar(xpoints[i], ypoints[i], delx[i], dely[i]));
            ++i;
        }
        this.append(xpoints, ypoints, xpoints.length);
    }

    public void append(double[] _xpoints, double[] _ypoints) {
        this.append(_xpoints, _ypoints, _xpoints.length);
    }

    public void append(double[] _xpoints, double[] _ypoints, int len) {
        this.updateID();
        boolean badData = false;
        this.myShape = null;
        int i = 0;
        while (i < len) {
            double xp = _xpoints[i];
            double yp = _ypoints[i];
            if (Double.isNaN(xp) || Double.isInfinite(xp) || Double.isInfinite(yp)) {
                badData = true;
            } else {
                this.xmax = Math.max(xp, this.xmax);
                this.xmin = Math.min(xp, this.xmin);
                if (xp > 0.0) {
                    this.xmaxLogscale = Math.max(xp, this.xmaxLogscale);
                    this.xminLogscale = Math.min(xp, this.xminLogscale);
                }
                if (!Double.isNaN(yp)) {
                    Point2D curPt;
                    this.ymax = Math.max(yp, this.ymax);
                    this.ymin = Math.min(yp, this.ymin);
                    if (yp > 0.0) {
                        this.ymaxLogscale = Math.max(yp, this.ymaxLogscale);
                        this.yminLogscale = Math.min(yp, this.yminLogscale);
                    }
                    if ((curPt = this.generalPath.getCurrentPoint()) == null) {
                        this.generalPath.moveTo((float)xp, (float)yp);
                    } else {
                        this.generalPath.lineTo((float)xp, (float)yp);
                    }
                }
            }
            ++i;
        }
        int pointsAdded = len;
        int availableSpots = this.xpoints.length - this.index;
        boolean increasedCapacity = false;
        if (pointsAdded > availableSpots) {
            this.increaseCapacity(this.xpoints.length + pointsAdded);
            increasedCapacity = true;
        }
        int maxPts = this.maxPoints == defaultMaxPoints ? (int)((double)this.maxPoints * maxPointsMultiplier) : this.maxPoints;
        pointsAdded = Math.min(pointsAdded, maxPts);
        System.arraycopy(_xpoints, Math.max(0, len - pointsAdded), this.xpoints, this.index, pointsAdded);
        System.arraycopy(_ypoints, Math.max(0, len - pointsAdded), this.ypoints, this.index, pointsAdded);
        this.index += pointsAdded;
        if (badData) {
            Dataset.removeBadData(this.xpoints, this.ypoints, this.index);
        }
        if (this.sorted) {
            this.insertionSort();
        }
        if (increasedCapacity) {
            this.resetXYMinMax(false);
        }
    }

    public void read(String inputFile) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            List<String> lines = Dataset.getLines(reader);
            int nlines = lines.size();
            double[][] xy = new double[2][nlines];
            int n = 0;
            int i = 0;
            while (i < nlines) {
                String s = lines.get(i).trim();
                if (s.length() != 0 && s.charAt(0) != '#') {
                    StringTokenizer st = new StringTokenizer(s, "\t");
                    switch (st.countTokens()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            xy[0][n] = Double.parseDouble(st.nextToken());
                            xy[1][n] = Double.parseDouble(st.nextToken());
                            ++n;
                            break;
                        }
                        default: {
                            throw new IOException();
                        }
                    }
                }
                ++i;
            }
            this.append(xy[0], xy[1], n);
            this.updateID();
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("File " + inputFile + " not found.");
        }
        catch (IOException ioe) {
            System.err.println("Error reading file " + inputFile);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Error reading file " + inputFile);
        }
    }

    private static List<String> getLines(BufferedReader reader) throws IOException {
        String s;
        ArrayList<String> list = new ArrayList<String>();
        while ((s = reader.readLine()) != null) {
            list.add(s);
        }
        return list;
    }

    public void write(String outputFile) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            int i = 0;
            while (i < this.index) {
                writer.println(String.valueOf(this.xpoints[i]) + "\t" + this.ypoints[i]);
                ++i;
            }
            writer.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("File " + outputFile + " not found.");
        }
        catch (IOException ioe) {
            System.err.println("Error writing file " + outputFile);
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        if (!this.drawable()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)(this.markerShape == 0 || this.markerShape == 5 ? g : g.create());
        if (this.markerShape != 0 && this.markerShape != 5) {
            Dataset.drawClip(g2, drawingPanel, this.markerSize);
        }
        this.drawData(drawingPanel, g2);
        if (g2 != g) {
            g2.dispose();
        }
    }

    protected static void drawClip(Graphics2D g2, DrawingPanel drawingPanel, int offset) {
        if (!OSPRuntime.allowDatasetClip) {
            return;
        }
        g2.setClip(drawingPanel.leftGutter - offset - 1, drawingPanel.topGutter - offset - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * offset, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * offset);
        Rectangle viewRect = drawingPanel.getViewRect();
        if (viewRect != null) {
            g2.clipRect(viewRect.x, viewRect.y, viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        }
    }

    protected boolean drawable() {
        if (this.visible) {
            int i = 0;
            while (i < this.index) {
                if (!Double.isNaN(this.ypoints[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void drawData(DrawingPanel drawingPanel, Graphics2D g2) {
        if (!drawingPanel.getPixelTransform().equals(this.pixelTransform)) {
            this.myShape = null;
            this.pixelTransform = drawingPanel.getPixelTransform();
        }
        try {
            if (this.myShape == null && (this.connected || this.markerShape == 5)) {
                this.myShape = drawingPanel.transformPath(this.generalPath);
            }
            switch (this.markerShape) {
                case 0: {
                    break;
                }
                case 5: {
                    g2.setColor(this.fillColor);
                    g2.fill(this.myShape);
                    g2.setColor(this.edgeColor);
                    g2.draw(this.myShape);
                    break;
                }
                default: {
                    this.drawScatterPlot(drawingPanel, g2);
                }
            }
            if (this.connected) {
                g2.setColor(this.lineColor);
                g2.draw(this.myShape);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawScatterPlot(DrawingPanel drawingPanel, Graphics2D g2) {
        g2.setColor(this.markerShape == 6 ? this.edgeColor : this.fillColor);
        double bottom = this.markerShape == 7 || this.markerShape == 8 ? Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin())) : 0;
        int width = this.markerSize * 2 + 1;
        int i = 0;
        while (i < this.index) {
            block13: {
                double x = this.xpoints[i];
                double y = this.getY(i);
                if (!(Double.isNaN(y) || x <= 0.0 && drawingPanel.isLogScaleX() || y <= 0.0 && drawingPanel.isLogScaleY())) {
                    int xp = drawingPanel.xToPix(x);
                    int yp = drawingPanel.yToPix(y);
                    Shape shape = tmpRect;
                    switch (this.markerShape) {
                        case 8: {
                            g2.setColor(this.edgeColor);
                            g2.drawLine(xp, yp, xp, (int)bottom);
                            g2.setColor(this.fillColor);
                            break;
                        }
                        default: {
                            tmpRect.setRect(xp - this.markerSize, yp - this.markerSize, width, width);
                            break;
                        }
                        case 6: {
                            tmpRect.setRect(xp, yp, 1.0, 1.0);
                            g2.draw(tmpRect);
                            break block13;
                        }
                        case 7: {
                            double barHeight = bottom - (double)yp;
                            if (barHeight > 0.0) {
                                tmpRect.setRect(xp - this.markerSize, yp, width, barHeight);
                                break;
                            }
                            tmpRect.setRect(xp - this.markerSize, bottom, width, -barHeight);
                            break;
                        }
                        case 1: {
                            shape = new Ellipse2D.Double(xp - this.markerSize, yp - this.markerSize, width, width);
                            break;
                        }
                        case -1: {
                            shape = this.getTranslateInstance(xp, yp).createTransformedShape(this.customMarker);
                        }
                    }
                    g2.fill(shape);
                    if (this.edgeColor != this.fillColor) {
                        g2.setColor(this.edgeColor);
                        g2.draw(shape);
                        g2.setColor(this.fillColor);
                    }
                }
            }
            ++i;
        }
        if (this.errorBars.size() > 0) {
            i = this.errorBars.size();
            while (--i >= 0) {
                this.errorBars.get(i).draw(drawingPanel, g2);
            }
        }
    }

    public void clear() {
        this.index = 0;
        this.generalPath.reset();
        this.errorBars.clear();
        this.resetXYMinMax(true);
        this.myShape = null;
    }

    public String toString() {
        String name = "(" + this.xColumnName + "," + this.getYColumnName() + ") " + this.bsColVis + " ";
        if (this.index == 0) {
            return String.valueOf(name) + "No data in dataset.";
        }
        String s = String.valueOf(this.xpoints[0]) + " " + this.ypoints[0] + "\n";
        StringBuffer b = new StringBuffer(this.index * s.length());
        int i = 0;
        while (i < this.index) {
            b.append(this.xpoints[i]);
            String eol = "\n";
            try {
                eol = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            b.append(" ");
            if (Double.isNaN(this.ypoints[i])) {
                b.append("null");
            } else {
                b.append(this.ypoints[i]);
            }
            b.append(eol);
            ++i;
        }
        return String.valueOf(name) + b.toString();
    }

    public static int countColumnsVisible(boolean[] visible) {
        int count = 0;
        int i = 0;
        while (i < visible.length) {
            if (visible[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void setXColumnVisible(boolean b) {
        this.bsColVis.set(0, b);
    }

    public void setYColumnVisible(boolean b) {
        this.bsColVis.set(1, b);
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setStride(int stride) {
        this.model.setStride(stride);
    }

    public boolean isXColumnVisible() {
        return this.bsColVis.get(0);
    }

    public boolean isYColumnVisible() {
        return this.bsColVis.get(1);
    }

    protected void recalculatePath() {
        this.myShape = null;
        this.generalPath.reset();
        if (this.index < 1) {
            return;
        }
        int i = 0;
        double[] xValues = this.xpoints;
        double[] yValues = this.ypoints;
        double shift = this.isShifted() ? this.shift : 0.0;
        while (i < this.index) {
            if (!Double.isNaN(yValues[i])) {
                this.generalPath.moveTo(xValues[i], yValues[i] + shift);
                break;
            }
            ++i;
        }
        ++i;
        while (i < this.index) {
            if (!Double.isNaN(yValues[i])) {
                this.generalPath.lineTo(xValues[i], yValues[i] + shift);
            }
            ++i;
        }
    }

    protected void insertionSort() {
        if (this.index >= 2 && Dataset.sort(this.xpoints, this.ypoints, this.index)) {
            this.recalculatePath();
        }
    }

    private static boolean sort(double[] xpoints, double[] ypoints, int index) {
        boolean dataChanged = false;
        int i = 1;
        while (i < index) {
            if (xpoints[i - 1] > xpoints[i]) {
                Dataset.moveDatum(xpoints, ypoints, i);
                dataChanged = true;
            }
            ++i;
        }
        return dataChanged;
    }

    private static void moveDatum(double[] xpoints, double[] ypoints, int loc) {
        if (loc < 1) {
            return;
        }
        double x = xpoints[loc];
        double y = ypoints[loc];
        int i = loc;
        while (--i >= 0 && xpoints[i] > x) {
        }
        if (++i == loc) {
            return;
        }
        System.arraycopy(xpoints, i, xpoints, i + 1, loc - i);
        System.arraycopy(ypoints, i, ypoints, i + 1, loc - i);
        xpoints[i] = x;
        ypoints[i] = y;
    }

    protected AffineTransform getTranslateInstance(double tx, double ty) {
        this.trD.setToTranslation(tx, ty);
        return this.trD;
    }

    private static int removeBadData(double[] ax, double[] ay, int n) {
        int off = 0;
        int i = 0;
        while (i < n) {
            double x = ax[i];
            double y = ay[i];
            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isInfinite(y)) {
                ++off;
            } else if (off > 0) {
                ax[i - off] = x;
                ay[i - off] = y;
            }
            ++i;
        }
        return n - off;
    }

    private synchronized void increaseCapacity(int newCapacity) {
        int pointsAdded = newCapacity - this.xpoints.length;
        int maxPts = this.maxPoints == defaultMaxPoints ? (int)((double)this.maxPoints * maxPointsMultiplier) : this.maxPoints;
        newCapacity = Math.min(newCapacity, maxPts);
        int newIndex = Math.min(this.index, 3 * newCapacity / 4);
        if ((newIndex = Math.min(newIndex, newCapacity - pointsAdded)) < 0) {
            newIndex = 0;
        }
        double[] tempx = this.xpoints;
        this.xpoints = new double[newCapacity];
        System.arraycopy(tempx, this.index - newIndex, this.xpoints, 0, newIndex);
        double[] tempy = this.ypoints;
        this.ypoints = new double[newCapacity];
        System.arraycopy(tempy, this.index - newIndex, this.ypoints, 0, newIndex);
        if (this.index != newIndex) {
            this.index = newIndex;
            this.resetXYMinMax(false);
            this.recalculatePath();
        }
        this.index = newIndex;
    }

    private void resetXYMinMax(boolean isCleared) {
        this.ymaxLogscale = -1.7976931348623157E308;
        this.xmaxLogscale = -1.7976931348623157E308;
        this.yminLogscale = Double.MAX_VALUE;
        this.xminLogscale = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        if (isCleared) {
            return;
        }
        double[] xValues = this.xpoints;
        double[] yValues = this.ypoints;
        double shift = this.isShifted() ? this.shift : 0.0;
        int i = 0;
        while (i < this.index) {
            if (!(Double.isNaN(xValues[i]) || Double.isInfinite(xValues[i]) || Double.isInfinite(yValues[i]))) {
                double yp;
                double xp = xValues[i];
                this.xmax = Math.max(xp, this.xmax);
                this.xmin = Math.min(xp, this.xmin);
                if (xp > 0.0) {
                    this.xmaxLogscale = Math.max(xp, this.xmaxLogscale);
                    this.xminLogscale = Math.min(xp, this.xminLogscale);
                }
                if (!Double.isNaN(yp = yValues[i] + shift)) {
                    this.ymax = Math.max(yp, this.ymax);
                    this.ymin = Math.min(yp, this.ymin);
                    if (yp > 0.0) {
                        this.ymaxLogscale = Math.max(yp, this.ymaxLogscale);
                        this.yminLogscale = Math.min(yp, this.yminLogscale);
                    }
                }
            }
            ++i;
        }
    }

    private double[] getValidPoints(double[] pts) {
        pts = Arrays.copyOf(pts, pts.length);
        int nans = 0;
        int i = 0;
        while (i < this.index) {
            if (nans > 0) {
                pts[i - nans] = pts[i];
            }
            if (Double.isNaN(this.ypoints[i])) {
                ++nans;
            }
            ++i;
        }
        if (this.index - nans == pts.length) {
            return pts;
        }
        double[] temp = new double[this.index - nans];
        System.arraycopy(pts, 0, temp, 0, this.index - nans);
        return temp;
    }

    public static Dataset findDataSet(ArrayList<Dataset> datasets, Data newData) {
        int id = newData.getID();
        int i = 0;
        int n = datasets.size();
        while (i < n) {
            Dataset ds = datasets.get(i);
            if (ds.getID() == id) {
                return ds;
            }
            ++i;
        }
        return null;
    }

    protected static int getNaNCount(double[] pts, int index) {
        int nans = 0;
        int i = 0;
        while (i < index) {
            if (Double.isNaN(pts[i])) {
                ++nans;
            }
            ++i;
        }
        return nans;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public static boolean[] toBoolArray(BitSet bs) {
        boolean[] b = new boolean[2];
        int i = bs.nextSetBit(0);
        while (i >= 0 && i < 2) {
            b[i] = true;
            i = bs.nextSetBit(i + 1);
        }
        return b;
    }

    public static int convertTableColumnIndex(BitSet visible, int columnIndex) {
        return visible.get(columnIndex) ? columnIndex : 1 - columnIndex;
    }

    public static void loadDatasets(ArrayList<Dataset> datasets, Iterator<Dataset> it) {
        while (it.hasNext()) {
            Dataset newData = it.next();
            Dataset ds = Dataset.findDataSet(datasets, newData);
            if (ds == null) continue;
            Dataset.getLoader().loadObject(new XMLControlElement(newData), ds);
        }
    }

    public double getMean(int xcol) {
        double[] data = xcol == 1 ? this.ypoints : this.xpoints;
        double sum = 0.0;
        int count = 0;
        int i = this.index;
        while (--i >= 0) {
            if (Double.isNaN(data[i])) continue;
            ++count;
            sum += data[i];
        }
        return sum / (double)count;
    }

    public double getX(int i) {
        return this.xpoints[i];
    }

    class ErrorBar
    implements Drawable {
        double x;
        double y;
        double delx;
        double dely;
        int tick = 3;

        ErrorBar(double _x, double _y, double _delx, double _dely) {
            this.x = _x;
            this.y = _y;
            this.delx = _delx;
            this.dely = _dely;
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            if (Double.isNaN(this.y)) {
                return;
            }
            int xpix = panel.xToPix(this.x);
            int xpix1 = panel.xToPix(this.x - this.delx);
            int xpix2 = panel.xToPix(this.x + this.delx);
            int ypix = panel.yToPix(this.y);
            int ypix1 = panel.yToPix(this.y - this.dely);
            int ypix2 = panel.yToPix(this.y + this.dely);
            g.setColor(Dataset.this.errorBarColor);
            g.drawLine(xpix1, ypix, xpix2, ypix);
            g.drawLine(xpix, ypix1, xpix, ypix2);
            g.drawLine(xpix1, ypix - this.tick, xpix1, ypix + this.tick);
            g.drawLine(xpix2, ypix - this.tick, xpix2, ypix + this.tick);
            g.drawLine(xpix - this.tick, ypix1, xpix + this.tick, ypix1);
            g.drawLine(xpix - this.tick, ypix2, xpix + this.tick, ypix2);
        }
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Dataset data = (Dataset)obj;
            control.setValue("points", data.getPoints());
            control.setValue("index", data.index);
            control.setValue("marker_shape", data.getMarkerShape());
            control.setValue("marker_size", data.getMarkerSize());
            control.setValue("sorted", data.isSorted());
            control.setValue("connected", data.isConnected());
            control.setValue("name", data.name);
            control.setValue("x_name", data.xColumnName);
            control.setValue("y_name", data.yColumnName);
            control.setValue("x_description", data.xColumnDescription);
            control.setValue("y_description", data.yColumnDescription);
            control.setValue("line_color", data.lineColor);
            control.setValue("fill_color", data.fillColor);
            control.setValue("edge_color", data.edgeColor);
            control.setValue("errorbar_color", data.errorBarColor);
            control.setValue("datasetID", data.datasetID);
            control.setValue("visible", Dataset.toBoolArray(data.bsColVis));
        }

        @Override
        public Object createObject(XMLControl control) {
            Class<?> type = control.getObjectClass();
            if (Dataset.class.isAssignableFrom(type) && !Dataset.class.equals(type)) {
                try {
                    return type.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return new Dataset();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            int n;
            Dataset data = (Dataset)obj;
            double[][] points = (double[][])control.getObject("points");
            double[] xPoints = null;
            double[] yPoints = null;
            if (points != null && (n = points.length) > 0 && points[0] != null) {
                xPoints = new double[n];
                yPoints = new double[n];
                int i = 0;
                while (i < n) {
                    xPoints[i] = points[i][0];
                    yPoints[i] = points[i][1];
                    ++i;
                }
            } else {
                xPoints = (double[])control.getObject("x_points");
                yPoints = (double[])control.getObject("y_points");
            }
            if (xPoints != null && yPoints != null) {
                data.clear();
                data.append(xPoints, yPoints);
            }
            data.index = control.getInt("index");
            if (control.getPropertyNamesRaw().contains("marker_shape")) {
                data.setMarkerShape(control.getInt("marker_shape"));
            }
            if (control.getPropertyNamesRaw().contains("marker_size")) {
                data.setMarkerSize(control.getInt("marker_size"));
            }
            data.setSorted(control.getBoolean("sorted"));
            data.setConnected(control.getBoolean("connected"));
            data.name = control.getString("name");
            data.xColumnName = control.getString("x_name");
            data.yColumnName = control.getString("y_name");
            data.xColumnDescription = control.getString("x_description");
            data.yColumnDescription = control.getString("y_description");
            Color color = (Color)control.getObject("line_color");
            if (color != null) {
                data.lineColor = color;
            }
            if ((color = (Color)control.getObject("fill_color")) != null) {
                data.fillColor = color;
            }
            if ((color = (Color)control.getObject("edge_color")) != null) {
                data.edgeColor = color;
            }
            if ((color = (Color)control.getObject("errorbar_color")) != null) {
                data.errorBarColor = color;
            }
            data.setID(control.getInt("datasetID"));
            boolean[] colVisible = (boolean[])control.getObject("visible");
            if (colVisible != null) {
                int i = 0;
                while (i < colVisible.length) {
                    data.bsColVis.set(i, colVisible[i]);
                    ++i;
                }
            }
            return obj;
        }
    }

    public class Model
    extends DataTable.OSPTableModel {
        protected int stride = 1;

        @Override
        public boolean isFoundOrdered() {
            double[] data = Dataset.this.foundColumn == 0 ? Dataset.this.xpoints : Dataset.this.ypoints;
            double d = Double.MAX_VALUE;
            int i = Dataset.this.index;
            while (--i >= 0) {
                if (data[i] > d) {
                    return false;
                }
                d = data[i];
            }
            return true;
        }

        @Override
        public int getStride() {
            return this.stride;
        }

        @Override
        public int getRowCount() {
            return Dataset.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return Dataset.this.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Dataset.this.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Double.class;
        }

        protected void setStride(int stride) {
            this.stride = stride;
            this.fireTableChanged(new TableModelEvent(this, 0, Integer.MAX_VALUE, stride, -1));
        }
    }
}

