/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.TableModelEvent;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.SuryonoParser;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetManager
extends DataTable.DataModel
implements Measurable,
LogMeasurable,
Data {
    public final Model model;
    ArrayList<Dataset> datasets = new ArrayList();
    boolean connected;
    boolean sorted;
    int markerShape;
    private int stride = 1;
    boolean linked = false;
    String xColumnName = "x";
    String yColumnName = "y";
    ArrayList<String> constantNames = new ArrayList();
    Map<String, Double> constantValues = new TreeMap<String, Double>();
    Map<String, String> constantExpressions = new TreeMap<String, String>();
    Map<String, String> constantDescriptions = new TreeMap<String, String>();
    String name = "";
    int datasetID = this.hashCode();
    public Dataset dsFound;
    private Dataset frameDataset;

    public DatasetManager() {
        this(false, false, false, 2);
    }

    public DatasetManager(boolean linked) {
        this(false, false, linked, 2);
    }

    public DatasetManager(boolean _connected, boolean _sorted) {
        this(_connected, _sorted, false, 2);
    }

    public DatasetManager(boolean _connected, boolean _sorted, boolean _linked, int _markerShape) {
        this.connected = _connected;
        this.sorted = _sorted;
        this.markerShape = _markerShape;
        this.linked = _linked;
        this.model = new Model();
    }

    public void setXPointsLinked(boolean _linked) {
        this.linked = _linked;
        int i = 1;
        while (i < this.datasets.size()) {
            Dataset dataset = this.datasets.get(i);
            dataset.setXColumnVisible(!this.linked);
            ++i;
        }
    }

    public boolean isXPointsLinked() {
        return this.linked;
    }

    public void setSorted(int datasetIndex, boolean _sorted) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setSorted(_sorted);
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        int i = 0;
        while (i < this.datasets.size()) {
            this.datasets.get(i).setSorted(_sorted);
            ++i;
        }
    }

    public void setConnected(int datasetIndex, boolean _connected) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setConnected(_connected);
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
        int i = 0;
        while (i < this.datasets.size()) {
            this.datasets.get(i).setConnected(_connected);
            ++i;
        }
    }

    public void setStride(int datasetIndex, int stride) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setStride(stride);
    }

    public void setStride(int _stride) {
        this.stride = _stride;
        int i = 0;
        while (i < this.datasets.size()) {
            this.datasets.get(i).setStride(this.stride);
            ++i;
        }
    }

    public void setMarkerColor(int datasetIndex, Color _markerColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setMarkerColor(_markerColor);
    }

    public void setMarkerColor(int datasetIndex, Color fillColor, Color edgeColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setMarkerColor(fillColor, edgeColor);
    }

    public void setMarkerShape(int datasetIndex, int _markerShape) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setMarkerShape(_markerShape);
    }

    public void setCustomMarker(int datasetIndex, Shape marker) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setCustomMarker(marker);
    }

    public void setXColumnVisible(int datasetIndex, boolean visible) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setXColumnVisible(visible);
    }

    public void setYColumnVisible(int datasetIndex, boolean visible) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setYColumnVisible(visible);
    }

    public void setMarkerSize(int datasetIndex, int _markerSize) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setMarkerSize(_markerSize);
    }

    public void setLineColor(int datasetIndex, Color _lineColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setLineColor(_lineColor);
    }

    @Override
    public Color[] getLineColors() {
        return null;
    }

    @Override
    public Color[] getFillColors() {
        return null;
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName, String datsetName) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setXYColumnNames(xColumnName, yColumnName, datsetName);
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.setXYColumnNames(xColumnName, yColumnName);
        if ("frame".equals(yColumnName)) {
            this.frameDataset = dataset;
        }
    }

    @Override
    public boolean isMeasured() {
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double getXMin() {
        double xmin = Double.MAX_VALUE;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                xmin = Math.min(xmin, d.getXMin());
            }
            ++i;
        }
        return xmin;
    }

    @Override
    public double getXMinLogscale() {
        double xmin = Double.MAX_VALUE;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                xmin = Math.min(xmin, d.getXMinLogscale());
            }
            ++i;
        }
        return Math.max((double)1.4E-45f, xmin);
    }

    @Override
    public double getXMax() {
        double xmax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                xmax = Math.max(xmax, d.getXMax());
            }
            ++i;
        }
        return xmax;
    }

    @Override
    public double getXMaxLogscale() {
        double xmax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                xmax = Math.max(xmax, d.getXMaxLogscale());
            }
            ++i;
        }
        return Math.max((double)1.4E-45f, xmax);
    }

    @Override
    public double getYMin() {
        double ymin = Double.MAX_VALUE;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                ymin = Math.min(ymin, d.getYMin());
            }
            ++i;
        }
        return ymin;
    }

    @Override
    public double getYMinLogscale() {
        double ymin = Double.MAX_VALUE;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                ymin = Math.min(ymin, d.getYMinLogscale());
            }
            ++i;
        }
        return Math.max((double)1.4E-45f, ymin);
    }

    @Override
    public double getYMax() {
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                ymax = Math.max(ymax, d.getYMax());
            }
            ++i;
        }
        return ymax;
    }

    @Override
    public double getYMaxLogscale() {
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d.isMeasured()) {
                ymax = Math.max(ymax, d.getYMaxLogscale());
            }
            ++i;
        }
        return Math.max((double)1.4E-45f, ymax);
    }

    public double[] getXPoints(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        return dataset.getXPoints();
    }

    public double[] getYPoints(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        return dataset.getYPoints();
    }

    public boolean isSorted(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        return dataset.isSorted();
    }

    public boolean isConnected(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        return dataset.isConnected();
    }

    @Override
    public int getColumnCount() {
        int columnCount = 0;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            if (d != null) {
                columnCount += d.getColumnCount();
            }
            ++i;
        }
        return columnCount;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        int i = 0;
        while (i < this.datasets.size()) {
            Dataset d = this.datasets.get(i);
            rowCount = Math.max(rowCount, d.getRowCount());
            ++i;
        }
        return rowCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = TeXParser.parseTeX(name);
        }
    }

    @Override
    public String getColumnName(int tableColumnIndex) {
        if (this.datasets.size() == 0) {
            return null;
        }
        Dataset ds = this.find(tableColumnIndex);
        return ds == null ? null : ds.getColumnName(ds.foundColumn);
    }

    @Override
    public double getValueAt(int row, int col) {
        if (this.datasets.size() == 0 || col < 0) {
            return Double.NaN;
        }
        Dataset ds = this.find(col);
        return ds == null || row >= ds.getRowCount() ? Double.NaN : ds.getValueAt(row, ds.foundColumn);
    }

    private Dataset find(int icol) {
        if (icol >= 0) {
            int i = 0;
            int ncol = 0;
            int n = this.datasets.size();
            while (i < n) {
                Dataset ds = this.datasets.get(i);
                int nVis = ds.getColumnCount();
                if (ncol + nVis > icol) {
                    ds.foundColumn = icol - ncol;
                    this.dsFound = ds;
                    return this.dsFound;
                }
                ncol += nVis;
                ++i;
            }
        }
        this.dsFound = null;
        return null;
    }

    public void append(int datasetIndex, double x, double y) {
        this.checkDatasetIndex(datasetIndex);
        this.datasets.get(datasetIndex).append(x, y);
    }

    public void append(int datasetIndex, double x, double y, double delx, double dely) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.append(x, y, delx, dely);
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.append(xpoints, ypoints);
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints, double[] delx, double[] dely) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.append(xpoints, ypoints, delx, dely);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        int i = 0;
        while (i < this.datasets.size()) {
            this.datasets.get(i).draw(drawingPanel, g);
            ++i;
        }
    }

    public void clear(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = this.datasets.get(datasetIndex);
        dataset.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.datasets.size()) {
            this.datasets.get(i).clear();
            ++i;
        }
    }

    public void removeDatasets() {
        this.clear();
        this.datasets.clear();
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, Integer.MAX_VALUE, -1, -1));
    }

    public Dataset getDataset(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        return this.datasets.get(datasetIndex);
    }

    @Override
    public final ArrayList<Dataset> getDatasets() {
        return new ArrayList<Dataset>(this.datasets);
    }

    public final ArrayList<Dataset> getDatasetsRaw() {
        return this.datasets;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        int n = this.datasets.size();
        String[] names = new String[n];
        int i = 0;
        while (i < n) {
            if (this.datasets.get(i) != null) {
                names[i] = this.datasets.get(i).getName();
            }
            ++i;
        }
        return names;
    }

    @Override
    public double[][] getData2D() {
        if (this.isXPointsLinked()) {
            int count = this.datasets.size();
            int index = 0;
            for (Dataset next : this.datasets) {
                index = Math.max(index, next.getIndex());
            }
            double[][] data = new double[count + 1][index];
            Dataset src = this.datasets.get(0);
            double[] d = src.getXPointsRaw();
            int n = src.getIndex();
            System.arraycopy(d, 0, data[0], 0, n);
            int i = 0;
            while (i < count) {
                src = this.datasets.get(i);
                d = src.isShifted() ? src.getYPoints() : src.getYPointsRaw();
                System.arraycopy(d, 0, data[i + 1], 0, n);
                ++i;
            }
            return data;
        }
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    public int addDataset(Dataset dataset) {
        if (this.linked && !this.datasets.isEmpty()) {
            dataset.setXColumnVisible(false);
        }
        int n = this.datasets.size();
        this.datasets.add(dataset);
        if ("frame".equals(dataset.getYColumnName())) {
            this.frameDataset = dataset;
        }
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, Integer.MAX_VALUE, n, 1));
        return n;
    }

    public Dataset removeDataset(int index) {
        if (index < 0 || index > this.datasets.size() - 1) {
            return null;
        }
        Dataset d = this.datasets.remove(index);
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, Integer.MAX_VALUE, index, -1));
        return d;
    }

    public int getDatasetIndex(String yColumnName) {
        int i = 0;
        while (i < this.datasets.size()) {
            if (this.datasets.get(i).getYColumnName().equals(yColumnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ArrayList<String> getConstantNames() {
        return this.constantNames;
    }

    public Double getConstantValue(String name) {
        return this.constantValues.get(name);
    }

    public String getConstantExpression(String name) {
        return this.constantExpressions.get(name);
    }

    public String getConstantDescription(String name) {
        return this.constantDescriptions.get(name);
    }

    public void setConstant(String name, double val, String expression) {
        if (!this.constantNames.contains(name)) {
            this.constantNames.add(name);
        }
        this.constantValues.put(name, val);
        this.constantExpressions.put(name, expression);
    }

    public void setConstant(String name, double val, String expression, String desc) {
        if (!this.constantNames.contains(name)) {
            this.constantNames.add(name);
        }
        this.constantValues.put(name, val);
        this.constantExpressions.put(name, expression);
        this.constantDescriptions.put(name, desc);
    }

    public void clearConstant(String name) {
        this.constantNames.remove(name);
        this.constantValues.remove(name);
        this.constantExpressions.remove(name);
        this.constantDescriptions.remove(name);
    }

    public String toString() {
        if (this.datasets.size() == 0) {
            return "No data in datasets.";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.datasets.size()) {
            b.append("Dataset ");
            b.append(i);
            b.append('\n');
            b.append(this.datasets.get(i).toString());
            ++i;
        }
        return b.toString();
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName) {
        this.xColumnName = _xColumnName;
        this.yColumnName = _yColumnName;
        int i = 0;
        int size = this.datasets.size();
        while (i < size) {
            this.datasets.get(i).setXYColumnNames(_xColumnName, _yColumnName);
            ++i;
        }
    }

    protected void checkDatasetIndex(int datasetIndex) {
        while (datasetIndex >= this.datasets.size()) {
            Dataset d = new Dataset(DisplayColors.getMarkerColor(datasetIndex), DisplayColors.getLineColor(datasetIndex), this.connected);
            if (this.linked && this.datasets.size() > 0) {
                d.setXColumnVisible(false);
            }
            d.setSorted(this.sorted);
            d.setXYColumnNames(this.xColumnName, this.yColumnName);
            d.setMarkerShape(this.markerShape);
            this.datasets.add(d);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public Dataset getFrameDataset() {
        return this.frameDataset;
    }

    public boolean isDuplicateName(Dataset d, String name) {
        if (this.datasets.isEmpty()) {
            return false;
        }
        if (this.getDataset(0).getXColumnName().equals(name)) {
            return true;
        }
        name = TeXParser.removeSubscripting(name);
        int i = 0;
        int n = this.datasets.size();
        while (i < n) {
            Dataset next = this.datasets.get(i);
            if (next != d && TeXParser.removeSubscripting(next.getYColumnName()).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getUniqueYColumnName(Component c, Dataset d, String proposed) {
        proposed = GUIUtils.showInputDialog(c, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, this.uniquifyColumnName(d, proposed));
        if (proposed == null || (proposed = proposed.trim()).length() == 0) {
            return null;
        }
        proposed = proposed.replaceAll(" ", "");
        boolean containsOperators = FunctionTool.arrayContains(FunctionTool.parserOperators, proposed);
        int tries = 0;
        int maxTries = 3;
        while (tries < maxTries) {
            String response;
            ++tries;
            if (this.isDuplicateName(d, proposed)) {
                response = GUIUtils.showInputDialog(c, "\"" + proposed + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2, proposed);
                String string = proposed = response == null ? null : response.toString();
            }
            if (proposed == null || proposed.equals("")) {
                return null;
            }
            if (FunctionTool.isReservedName(proposed)) {
                response = GUIUtils.showInputDialog(c, "\"" + proposed + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2, proposed);
                String string = proposed = response == null ? null : response.toString();
            }
            if (proposed == null || proposed.equals("")) {
                return null;
            }
            containsOperators = FunctionTool.arrayContains(FunctionTool.parserOperators, proposed);
            if (containsOperators) {
                response = GUIUtils.showInputDialog(c, ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Message"), ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Title"), 2, proposed);
                String string = proposed = response == null ? null : response.toString();
            }
            if (proposed != null && !proposed.equals("")) continue;
            return null;
        }
        return containsOperators ? null : this.uniquifyColumnName(d, proposed);
    }

    public String uniquifyColumnName(Dataset d, String name) {
        String subscript;
        double di;
        if (name == null) {
            return null;
        }
        int i = 0;
        if (!Double.isNaN(SuryonoParser.getNumber(name))) {
            name = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        boolean subscriptRemoved = false;
        if (this.isDuplicateName(d, name) && (di = SuryonoParser.getNumber(subscript = TeXParser.getSubscript(name))) == (double)((int)di)) {
            name = TeXParser.removeSubscript(name);
            subscriptRemoved = true;
        }
        while (subscriptRemoved || this.isDuplicateName(d, name) || FunctionTool.isReservedName(name)) {
            name = TeXParser.addSubscript(name, "" + ++i);
            subscriptRemoved = false;
        }
        return name;
    }

    public double get(String var, int row, int col) {
        return this.getDataset(this.getDatasetIndex(var)).getValueAt(row, col);
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DatasetManager dsm = (DatasetManager)obj;
            control.setValue("connected", dsm.connected);
            control.setValue("sorted", dsm.sorted);
            control.setValue("maker_shape", dsm.markerShape);
            control.setValue("stride", dsm.stride);
            control.setValue("linked", dsm.linked);
            control.setValue("x_column_name", dsm.xColumnName);
            control.setValue("y_column_name", dsm.yColumnName);
            control.setValue("data_name", dsm.name);
            control.setValue("datasets", dsm.datasets);
            control.setValue("id", dsm.datasetID);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DatasetManager();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DatasetManager dsm = (DatasetManager)obj;
            dsm.connected = control.getBoolean("connected");
            dsm.sorted = control.getBoolean("sorted");
            dsm.markerShape = control.getInt("maker_shape");
            dsm.stride = control.getInt("stride");
            dsm.linked = control.getBoolean("linked");
            dsm.xColumnName = control.getString("x_column_name");
            dsm.yColumnName = control.getString("y_column_name");
            dsm.setName(control.getString("data_name"));
            if (control.getPropertyNamesRaw().contains("id")) {
                dsm.setID(control.getInt("id"));
            }
            dsm.removeDatasets();
            Collection datasets = (Collection)Collection.class.cast(control.getObject("datasets"));
            if (datasets != null) {
                Iterator it = datasets.iterator();
                while (it.hasNext()) {
                    dsm.datasets.add((Dataset)it.next());
                }
            }
            return obj;
        }
    }

    public class Model
    extends DataTable.OSPTableModel {
        @Override
        public boolean isFoundOrdered() {
            return DatasetManager.this.dsFound == null || DatasetManager.this.dsFound.model.isFoundOrdered();
        }

        @Override
        public int getStride() {
            return DatasetManager.this.stride;
        }

        @Override
        public int getRowCount() {
            return DatasetManager.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return DatasetManager.this.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return DatasetManager.this.getValueAt(rowIndex, columnIndex);
        }

        public Class<Double> getColumnClass(int columnIndex) {
            return Double.class;
        }

        @Override
        public String getColumnName(int column) {
            return DatasetManager.this.getColumnName(column);
        }
    }
}

