/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class DrawableGroup
implements Drawable {
    protected double x = 0.0;
    protected double y = 0.0;
    protected double theta = 0.0;
    protected ArrayList<Drawable> drawableList = new ArrayList();
    AffineTransform trDG = new AffineTransform();

    public void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        int xpix = panel.xToPix(0.0);
        int ypix = panel.yToPix(0.0);
        Graphics2D g2 = (Graphics2D)g;
        double xt = this.x * panel.getXPixPerUnit() * Math.cos(this.theta) + this.y * panel.getYPixPerUnit() * Math.sin(this.theta);
        double yt = this.x * panel.getXPixPerUnit() * Math.sin(this.theta) - this.y * panel.getYPixPerUnit() * Math.cos(this.theta);
        AffineTransform at = g2.getTransform();
        this.trDG.setTransform(at);
        this.trDG.rotate(-this.theta, xpix, ypix);
        this.trDG.translate(xt, yt);
        g2.setTransform(this.trDG);
        int i = 0;
        int n = this.drawableList.size();
        while (i < n) {
            this.drawableList.get(i).draw(panel, g2);
            ++i;
        }
        g2.setTransform(at);
    }

    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public void setX(double _x) {
        this.x = _x;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double _y) {
        this.y = _y;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double _theta) {
        this.theta = _theta;
    }
}

