/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawableShapeLoader;
import org.opensourcephysics.display.DrawingPanel;

public class DrawableShape
implements Drawable {
    public Color color = new Color(255, 128, 128, 128);
    public Color edgeColor = Color.RED;
    Shape shape;
    double x;
    double y;
    double theta;
    public String shapeClass;
    AffineTransform trDS = new AffineTransform();

    public DrawableShape(Shape shape, double x, double y) {
        this.x = x;
        this.y = y;
        this.shapeClass = shape.getClass().getName();
        this.trDS.setToTranslation(x, y);
        this.shape = this.trDS.createTransformedShape(shape);
    }

    public static DrawableShape createCircle(double x, double y, double d) {
        return new DrawableShape(new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d), x, y);
    }

    public static DrawableShape createRectangle(double x, double y, double w, double h) {
        return new DrawableShape(new Rectangle2D.Double(-w / 2.0, -h / 2.0, w, h), x, y);
    }

    public void setMarkerColor(Color fillColor, Color edgeColor) {
        this.color = fillColor;
        this.edgeColor = edgeColor;
    }

    public void setTheta(double theta) {
        if (this.theta == theta) {
            return;
        }
        this.trDS.setToRotation(theta - this.theta, this.x, this.y);
        this.shape = this.trDS.createTransformedShape(this.shape);
        this.theta = theta;
    }

    public double getTheta() {
        return this.theta;
    }

    public void transform(AffineTransform transformation) {
        this.shape = transformation.createTransformedShape(this.shape);
    }

    public void tranform(double[][] mat) {
        this.trDS.setTransform(mat[0][0], mat[1][0], mat[0][1], mat[1][1], mat[0][2], mat[1][2]);
        this.shape = this.trDS.createTransformedShape(this.shape);
    }

    public void setXY(double _x, double _y) {
        if (this.x == _x && this.y == _y) {
            return;
        }
        this.trDS.setToTranslation(_x - this.x, _y - this.y);
        this.shape = this.trDS.createTransformedShape(this.shape);
        this.x = _x;
        this.y = _y;
    }

    public void setX(double _x) {
        if (this.x == _x) {
            return;
        }
        this.trDS.setToTranslation(_x - this.x, 0.0);
        this.shape = this.trDS.createTransformedShape(this.shape);
        this.x = _x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double _y) {
        if (this.y == _y) {
            return;
        }
        this.trDS.setToTranslation(0.0, _y - this.y);
        this.shape = this.trDS.createTransformedShape(this.shape);
        this.y = _y;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        String name = this.getClass().getName();
        name = String.valueOf(name.substring(1 + name.lastIndexOf("."))) + '[';
        name = String.valueOf(name) + "x=" + this.x;
        name = String.valueOf(name) + ",y=" + this.y + ']';
        return name;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        Shape temp = panel.transformShape(this.shape);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.color);
        g2.fill(temp);
        g2.setPaint(this.edgeColor);
        g2.draw(temp);
        g2.setPaint(Color.BLACK);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawableShapeLoader();
    }
}

