/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawableShape;
import org.opensourcephysics.display.GeneralPathLoader;

public class DrawableShapeLoader
extends XMLLoader {
    static {
        XML.setLoader(GeneralPath.class, new GeneralPathLoader());
    }

    @Override
    public void saveObject(XMLControl control, Object obj) {
        DrawableShape drawableShape = (DrawableShape)obj;
        control.setValue("geometry", drawableShape.shapeClass);
        control.setValue("x", drawableShape.x);
        control.setValue("y", drawableShape.y);
        control.setValue("theta", drawableShape.theta);
        control.setValue("fill color", drawableShape.color);
        control.setValue("edge color", drawableShape.edgeColor);
        Shape shape = AffineTransform.getRotateInstance(-drawableShape.theta, drawableShape.x, drawableShape.y).createTransformedShape(drawableShape.shape);
        control.setValue("general path", shape);
    }

    @Override
    public Object createObject(XMLControl control) {
        return new DrawableShape(new GeneralPath(), 0.0, 0.0);
    }

    @Override
    public Object loadObject(XMLControl control, Object obj) {
        DrawableShape drawableShape = (DrawableShape)obj;
        String geometry = control.getString("geometry");
        double x = control.getDouble("x");
        double y = control.getDouble("y");
        double theta = control.getDouble("theta");
        drawableShape.shape = (Shape)control.getObject("general path");
        drawableShape.shapeClass = geometry;
        drawableShape.x = x;
        drawableShape.y = y;
        drawableShape.color = (Color)control.getObject("fill color");
        drawableShape.edgeColor = (Color)control.getObject("edge color");
        drawableShape.setTheta(theta);
        return obj;
    }
}

