/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javajs.async.AsyncFileChooser;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;

public class DrawingFrame
extends OSPFrame
implements ClipboardOwner {
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem replaceItem;
    protected DrawingPanel drawingPanel;
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Window customInspector;
    protected Tool reply;
    private ArrayList<Drawable> EMPTY_LIST = new ArrayList();

    public DrawingFrame() {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), new InteractivePanel());
    }

    public DrawingFrame(DrawingPanel drawingPanel) {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), drawingPanel);
    }

    public DrawingFrame(String title, DrawingPanel _drawingPanel) {
        super(title);
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        if (!OSPRuntime.appletMode) {
            this.createMenuBar();
        }
        this.reply = new Tool(){

            @Override
            public void send(Job job, Tool noReply) {
                DrawingFrame.this.drawingPanel.receiveToolReply(job);
                DrawingFrame.this.drawingPanel.repaint();
            }
        };
    }

    @Override
    public void render() {
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        if (this.drawingPanel != null) {
            this.drawingPanel.render();
        } else {
            this.repaint();
        }
    }

    @Override
    public void invalidateImage() {
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public DrawingPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    public void setXLabel(String label) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(label);
        }
    }

    public void setYLabel(String label) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setYLabel(label);
        }
    }

    public void setPolar(String plotTitle, double deltaR) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setPolar(plotTitle, deltaR);
        }
    }

    public void setCartesian(String xLabel, String yLabel, String plotTitle) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setCartesian(xLabel, yLabel, plotTitle);
        }
    }

    public void limitAutoscaleX(double floor, double ceil) {
        if (this.drawingPanel != null) {
            this.drawingPanel.limitAutoscaleX(floor, ceil);
        }
    }

    public void limitAutoscaleY(double floor, double ceil) {
        if (this.drawingPanel != null) {
            this.drawingPanel.limitAutoscaleY(floor, ceil);
        }
    }

    public void setAutoscaleX(boolean autoscale) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleX(autoscale);
        }
    }

    public boolean isAutoscaleX() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleX();
        }
        return false;
    }

    public void setAutoscaleY(boolean autoscale) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleY(autoscale);
        }
    }

    public boolean isAutoscaleY() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleY();
        }
        return false;
    }

    public void setSquareAspect(boolean isSquare) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setSquareAspect(isSquare);
        }
    }

    public void setLogScale(boolean logX, boolean logY) {
        if (this.drawingPanel != null && this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(logX, logY);
        }
    }

    public void setPixelsPerUnit(boolean enable, double xPixPerUnit, double yPixPerUnit) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPixelsPerUnit(enable, xPixPerUnit, yPixPerUnit);
        }
    }

    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMax(xmin, xmax, ymin, ymax);
        }
    }

    public void setPreferredMinMaxY(double ymin, double ymax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxY(ymin, ymax);
        }
    }

    public void setPreferredMinMaxX(double xmin, double xmax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxX(xmin, xmax);
        }
    }

    @Override
    public void clearDataAndRepaint() {
        this.clearData();
        if (this.drawingPanel != null) {
            this.drawingPanel.repaint();
        }
    }

    public void clearDrawables() {
        if (this.drawingPanel != null) {
            this.drawingPanel.clear();
        }
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.addDrawable(drawable);
        }
    }

    public synchronized void replaceDrawable(Drawable oldDrawable, Drawable newDrawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.replaceDrawable(oldDrawable, newDrawable);
        }
    }

    public synchronized void removeDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.removeDrawable(drawable);
        }
    }

    public void setMessage(String msg) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setMessage(msg);
        }
    }

    public void setMessage(String msg, int location) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setMessage(msg, location);
        }
    }

    public synchronized <T extends Drawable> ArrayList<T> getObjectOfClass(Class<T> c) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getObjectOfClass(c);
        }
        return null;
    }

    public synchronized ArrayList<Drawable> getDrawables() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables();
        }
        return new ArrayList<Drawable>();
    }

    public synchronized ArrayList<Drawable> getDrawablesNoClone() {
        return this.drawingPanel == null ? this.EMPTY_LIST : this.drawingPanel.getDrawablesNoClone();
    }

    public DrawableAxes getAxes() {
        if (this.drawingPanel instanceof PlottingPanel) {
            return ((PlottingPanel)this.drawingPanel).getAxes();
        }
        return null;
    }

    public synchronized <T extends Drawable> ArrayList<T> getDrawables(Class<T> c) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables(c);
        }
        return new ArrayList();
    }

    public synchronized <T extends Drawable> ArrayList<T> getDrawablesExcept(Class<T> c, Drawable except) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawablesExcept(c, except);
        }
        return new ArrayList();
    }

    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> c) {
        if (this.drawingPanel != null) {
            this.drawingPanel.removeObjectsOfClass(c);
        }
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler handler) {
        ((InteractivePanel)this.drawingPanel).setInteractiveMouseHandler(handler);
    }

    public void setDrawingPanel(DrawingPanel _drawingPanel) {
        if (this.drawingPanel != null) {
            this.getContentPane().remove(this.drawingPanel);
        }
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
    }

    public void setInteriorBackground(Color color) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).getAxes().setInteriorBackground(color);
        } else if (this.drawingPanel != null) {
            this.drawingPanel.setBackground(color);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!OSPRuntime.appletMode) {
            super.paint(g);
            return;
        }
        try {
            super.paint(g);
        }
        catch (Exception ex) {
            System.err.println("OSPFrame paint error: " + ex.toString());
            System.err.println("Title: " + this.getTitle());
        }
    }

    public void setEnabledPaste(boolean enable) {
        this.pasteItem.setEnabled(enable);
    }

    protected void pasteAction(XMLControlElement control) {
        System.err.println("DrawingFrame Line 568");
        final XMLTreeChooser chooser = new XMLTreeChooser(DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_title"), DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_message"), this);
        chooser.chooseAsync(control, Drawable.class, new Runnable(){

            @Override
            public void run() {
                List<XMLProperty> props = chooser.getList();
                if (!props.isEmpty()) {
                    for (XMLControl xMLControl : props) {
                        Drawable drawable = (Drawable)xMLControl.loadObject(null);
                        DrawingFrame.this.addDrawable(drawable);
                    }
                }
                DrawingFrame.this.drawingPanel.repaint();
            }
        });
    }

    public void setEnabledReplace(boolean enable) {
        this.replaceItem.setEnabled(enable);
    }

    public void replaceAction(XMLControlElement control) {
        this.clearDrawables();
        this.pasteAction(control);
    }

    protected void copyAction(XMLControlElement control) {
        OSPRuntime.copy(control.toXML(), this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setEnabledCopy(boolean enable) {
        this.copyItem.setEnabled(enable);
    }

    @Override
    protected void refreshGUI() {
        this.createMenuBar();
        this.addMenuItems();
        this.pack();
    }

    protected void addMenuItems() {
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        JMenu printMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        JMenuItem printItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Print_menu_item"));
        if (!OSPRuntime.isJS) {
            printMenu.add(printItem);
            printItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
            printItem.addActionListener(e -> PrintUtils.printComponent(this.drawingPanel));
            JMenuItem printFrameItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
            printMenu.add(printFrameItem);
            printFrameItem.addActionListener(e -> PrintUtils.printComponent(this));
        }
        JMenuItem saveXMLItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveXML_menu_item"));
        saveXMLItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        saveXMLItem.addActionListener(e -> this.saveXML());
        JMenuItem exportItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Export_menu_item"));
        exportItem.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
        if (OSPRuntime.loadExportTool) {
            OSPLog.fine("Loading ExportTool");
            if (!Tool.setSendAction(exportItem, "ExportTool", this.drawingPanel, this.reply, false)) {
                OSPRuntime.loadExportTool = false;
                exportItem.setEnabled(false);
            }
        }
        OSPLog.info("Done with Export Tool");
        JMenu saveImage = new JMenu(DisplayRes.getString("DrawingFrame.SaveImage_menu_title"));
        JMenuItem epsMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.EPS_menu_item"));
        JMenuItem jpegMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.JPEG_menu_item"));
        JMenuItem pngMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PNG_menu_item"));
        saveImage.add(epsMenuItem);
        saveImage.add(jpegMenuItem);
        saveImage.add(pngMenuItem);
        epsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "eps", DrawingFrame.this);
            }
        });
        jpegMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "jpeg", DrawingFrame.this);
            }
        });
        pngMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "png", DrawingFrame.this);
            }
        });
        JMenuItem inspectItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        inspectItem.setAccelerator(KeyStroke.getKeyStroke(73, MENU_SHORTCUT_KEY_MASK));
        inspectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawingFrame.this.inspectXML();
            }
        });
        if (!OSPRuntime.isJS) {
            this.fileMenu.add(printMenu);
        }
        this.fileMenu.add(saveXMLItem);
        this.fileMenu.add(exportItem);
        if (!OSPRuntime.isJS) {
            this.fileMenu.add(saveImage);
        }
        this.fileMenu.add(inspectItem);
        menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        menuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLControlElement control = new XMLControlElement(DrawingFrame.this);
                control.saveObject(null);
                DrawingFrame.this.copyAction(control);
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Paste_menu_item"));
        this.pasteItem.addActionListener(e -> OSPRuntime.paste(s -> {
            XMLControlElement control = new XMLControlElement();
            control.readXML((String)s);
            this.pasteAction(control);
        }));
        this.pasteItem.setEnabled(false);
        this.editMenu.add(this.pasteItem);
        this.replaceItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Replace_menu_item"));
        this.replaceItem.addActionListener(e -> OSPRuntime.paste(s -> {
            if (s != null) {
                XMLControlElement control = new XMLControlElement();
                control.readXML((String)s);
                this.replaceAction(control);
            }
        }));
        this.replaceItem.setEnabled(false);
        this.editMenu.add(this.replaceItem);
        this.setJMenuBar(menuBar);
        this.loadDisplayMenu();
        this.loadToolsMenu();
        JMenu helpMenu = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        aboutItem.addActionListener(e -> OSPRuntime.showAboutDialog(this));
        helpMenu.add(aboutItem);
        JMenuItem sysItem = new JMenuItem(ControlsRes.getString("ControlFrame.System"));
        sysItem.addActionListener(e -> ControlUtils.showSystemProperties(true));
        helpMenu.add(sysItem);
        helpMenu.addSeparator();
        JMenuItem logItem = new JMenuItem(ControlsRes.getString("ControlFrame.Message_Log"));
        logItem.addActionListener(e -> OSPLog.showLog());
        helpMenu.add(logItem);
    }

    @Override
    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu displayMenu = new JMenu(DisplayRes.getString("DrawingFrame.Display_menu_title"));
        menuBar.add(displayMenu);
        JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        sizeUpItem.addActionListener(e -> FontSizer.levelUp());
        fontMenu.add(sizeUpItem);
        JMenuItem sizeDownItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        sizeDownItem.addActionListener(e -> FontSizer.levelDown());
        fontMenu.add(sizeDownItem);
        fontMenu.addChangeListener(e -> sizeDownItem.setEnabled(FontSizer.getLevel() > 0));
        JMenu aliasMenu = new JMenu(DisplayRes.getString("DrawingFrame.AntiAlias_menu_title"));
        if (!OSPRuntime.isJS) {
            displayMenu.add(aliasMenu);
        }
        JCheckBoxMenuItem textAliasItem = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Text_checkbox_label"), false);
        textAliasItem.addActionListener(e -> {
            this.drawingPanel.antialiasTextOn = textAliasItem.isSelected();
            this.drawingPanel.repaint();
        });
        aliasMenu.add(textAliasItem);
        JCheckBoxMenuItem shapeAliasItem = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Drawing_textbox_label"), false);
        shapeAliasItem.addActionListener(e -> {
            this.drawingPanel.antialiasShapeOn = shapeAliasItem.isSelected();
            this.drawingPanel.repaint();
        });
        aliasMenu.addChangeListener(e -> {
            textAliasItem.setSelected(this.drawingPanel.antialiasTextOn);
            shapeAliasItem.setSelected(this.drawingPanel.antialiasShapeOn);
        });
        aliasMenu.add(shapeAliasItem);
        menuBar.add(displayMenu);
        return displayMenu;
    }

    @Override
    protected JMenu loadToolsMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu toolsMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        menuBar.add(toolsMenu);
        JMenuItem datasetItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        toolsMenu.add(datasetItem);
        if (OSPRuntime.loadDataTool && !Tool.setSendAction(datasetItem, "DataTool", this.drawingPanel, this.reply, true)) {
            OSPRuntime.loadDataTool = false;
            datasetItem.setEnabled(false);
        }
        JMenuItem fourierToolItem = new JMenuItem(DisplayRes.getString("DrawingFrame.FourierTool_menu_item"));
        toolsMenu.add(fourierToolItem);
        fourierToolItem.setVisible(false);
        JMenuItem snapshotItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        if (!OSPRuntime.isApplet && !OSPRuntime.isJS) {
            toolsMenu.add(snapshotItem);
        }
        if (!OSPRuntime.isJS) {
            snapshotItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SnapshotTool tool = SnapshotTool.getTool();
                    if (DrawingFrame.this.drawingPanel != null) {
                        tool.saveImage(null, DrawingFrame.this.drawingPanel);
                    } else {
                        tool.saveImage(null, DrawingFrame.this.getContentPane());
                    }
                }
            });
        }
        return toolsMenu;
    }

    public void setCustomInspector(Window w) {
        if (this.customInspector != null) {
            this.customInspector.setVisible(false);
        }
        this.customInspector = w;
    }

    public void inspectXML() {
        if (this.customInspector != null) {
            this.customInspector.setVisible(true);
            return;
        }
        XMLControlElement xml = null;
        try {
            Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                xml = new XMLControlElement(this.drawingPanel);
            }
        }
        catch (NoSuchMethodException ex) {
            System.err.println("DrawingFram line 1039 NoSuchMethodException xml=" + xml);
            return;
        }
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        JDialog dialog = new JDialog(null, true);
        dialog.setTitle("XML Inspector");
        dialog.setContentPane(treePanel);
        dialog.setSize(new Dimension(600, 300));
        dialog.setVisible(true);
    }

    public void saveXML() {
        AsyncFileChooser chooser = OSPRuntime.getChooser();
        if (chooser == null) {
            return;
        }
        String oldTitle = chooser.getDialogTitle();
        chooser.setDialogTitle("Save XML Data");
        int result = -1;
        try {
            result = chooser.showSaveDialog(null);
        }
        catch (Throwable e) {
            System.err.println("InterruptedException in saveXML()().");
            e.printStackTrace();
        }
        chooser.setDialogTitle(oldTitle);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = String.valueOf(fileName) + ".xml";
                file = new File(fileName);
            }
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            XMLControlElement xml = new XMLControlElement(this.drawingPanel);
            xml.write(fileName);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingFrameLoader();
    }

    protected static class DrawingFrameLoader
    implements XML.ObjectLoader {
        protected DrawingFrameLoader() {
        }

        @Override
        public Object createObject(XMLControl control) {
            DrawingFrame frame = new DrawingFrame();
            frame.setTitle(control.getString("title"));
            frame.setLocation(control.getInt("location x"), control.getInt("location y"));
            frame.setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                frame.setVisible(true);
            }
            return frame;
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DrawingFrame frame = (DrawingFrame)obj;
            control.setValue("title", frame.getTitle());
            control.setValue("showing", frame.isShowing());
            control.setValue("location x", frame.getLocation().x);
            control.setValue("location y", frame.getLocation().y);
            control.setValue("width", frame.getSize().width);
            control.setValue("height", frame.getSize().height);
            control.setValue("drawing panel", frame.getDrawingPanel());
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DrawingFrame frame = (DrawingFrame)obj;
            DrawingPanel panel = frame.getDrawingPanel();
            panel.clear();
            XMLControl panelControl = control.getChildControl("drawing panel");
            panelControl.loadObject(panel);
            panel.repaint();
            frame.setTitle(control.getString("title"));
            frame.setLocation(control.getInt("location x"), control.getInt("location y"));
            frame.setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                frame.setVisible(true);
            }
            return obj;
        }
    }
}

