/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javajs.async.AsyncFileChooser;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TeXParser;

public class GUIUtils {
    private static Color enabledColor = UIManager.getColor("Label.foreground");
    private static Color disabledColor;

    static {
        if (enabledColor == null) {
            enabledColor = Color.BLACK;
        }
        if ((disabledColor = UIManager.getColor("Label.disabledForeground")) == null) {
            disabledColor = UIManager.getColor("Label.disabledText");
        }
        if (disabledColor == null) {
            disabledColor = Color.LIGHT_GRAY;
        }
    }

    private GUIUtils() {
    }

    @Deprecated
    public static String parseTeX(String input) {
        return TeXParser.parseTeX(input);
    }

    @Deprecated
    public static String removeSubscripting(String input) {
        return TeXParser.removeSubscripting(input);
    }

    public static Component findInstance(Container container, Class<?> c) {
        if (container == null || c.isInstance(container)) {
            return container;
        }
        Component[] components = container.getComponents();
        int i = 0;
        int n = components.length;
        while (i < n) {
            Component comp;
            if (c.isInstance(components[i])) {
                return components[i];
            }
            if (components[i] instanceof Container && c.isInstance(comp = GUIUtils.findInstance((Container)components[i], c))) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    public static void showDrawingAndTableFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && (frames[i].getName() == null || frames[i].getName().indexOf("Tool") <= -1) && OSPFrame.class.isInstance(frames[i])) {
                if (DataTableFrame.class.isInstance(frames[i])) {
                    ((DataTableFrame)frames[i]).refreshTable(3);
                }
                frames[i].setVisible(true);
                ((OSPFrame)frames[i]).invalidateImage();
                frames[i].repaint();
                frames[i].toFront();
            }
            ++i;
        }
        if (OSPRuntime.isApplet) {
            OSPRuntime.applet.getRootPane().repaint();
        }
    }

    public static void renderAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i]) && ((OSPFrame)frames[i]).isAnimated()) {
                ((OSPFrame)frames[i]).render();
            }
            ++i;
        }
        if (OSPRuntime.isApplet && OSPRuntime.applet instanceof Renderable) {
            ((Renderable)((Object)OSPRuntime.applet)).render();
        }
    }

    public static void repaintAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i]) && ((OSPFrame)frames[i]).isAnimated()) {
                ((OSPFrame)frames[i]).invalidateImage();
                ((OSPFrame)frames[i]).repaint();
            }
            ++i;
        }
    }

    public static void repaintOSPFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isVisible() && frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i])) {
                ((OSPFrame)frames[i]).repaint();
            }
            ++i;
        }
    }

    public static void clearDrawingFrameData(boolean clearAll) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i])) {
                OSPFrame frame = (OSPFrame)frames[i];
                if (clearAll || frame.isAutoclear()) {
                    frame.clearDataAndRepaint();
                }
            }
            ++i;
        }
    }

    public static void setAnimatedFrameIgnoreRepaint(boolean ignoreRepaint) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            DrawingPanel dp;
            if (frames[i].isDisplayable() && DrawingFrame.class.isInstance(frames[i]) && ((DrawingFrame)frames[i]).isAnimated() && (dp = ((DrawingFrame)frames[i]).getDrawingPanel()) != null) {
                dp.setIgnoreRepaint(ignoreRepaint);
            }
            ++i;
        }
    }

    public static void enableMenubars(boolean enable) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && (frames[i].getName() == null || frames[i].getName().indexOf("Tool") <= -1)) {
                JMenuBar bar;
                Class<?> frame3d = null;
                try {
                    frame3d = Class.forName("org.opensourcephysics.display3d.core.DrawingFrame3D");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if ((DrawingFrame.class.isInstance(frames[i]) || frame3d != null && frame3d.isInstance(frames[i])) && (bar = ((JFrame)frames[i]).getJMenuBar()) != null) {
                    int j = 0;
                    int n = bar.getMenuCount();
                    while (j < n) {
                        bar.getMenu(j).setEnabled(enable);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static void closeAndDisposeOSPFrames(Frame frame) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i] != frame && OSPFrame.class.isInstance(frames[i])) {
                ((OSPFrame)frames[i]).setDefaultCloseOperation(2);
                ((OSPFrame)frames[i]).setVisible(false);
                ((OSPFrame)frames[i]).dispose();
            }
            ++i;
        }
    }

    public static File showSaveDialog(Component parent) {
        return GUIUtils.showSaveDialog(parent, DisplayRes.getString("GUIUtils.Title.Save"));
    }

    public static File showSaveDialog(Component parent, String title) {
        int selected;
        AsyncFileChooser fileChooser = OSPRuntime.getChooser();
        if (fileChooser == null) {
            return null;
        }
        String oldTitle = fileChooser.getDialogTitle();
        fileChooser.setDialogTitle(title);
        int result = ((JFileChooser)fileChooser).showSaveDialog(parent);
        fileChooser.setDialogTitle(oldTitle);
        if (result != 0) {
            return null;
        }
        OSPRuntime.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        if (!OSPRuntime.isJS && file.exists() && (selected = JOptionPane.showConfirmDialog(parent, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
            return null;
        }
        return file;
    }

    public static File showOpenDialog(Component parent) {
        if (OSPRuntime.isJS) {
            return null;
        }
        AsyncFileChooser fileChooser = OSPRuntime.getChooser();
        int result = ((JFileChooser)fileChooser).showOpenDialog(parent);
        if (result != 0) {
            return null;
        }
        OSPRuntime.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public static Color getEnabledTextColor() {
        return enabledColor;
    }

    public static Color getDisabledTextColor() {
        return disabledColor;
    }

    public static void timingTest(Drawable drawable) {
        DrawingPanel dp = new DrawingPanel();
        DrawingFrame df = new DrawingFrame(dp);
        df.setVisible(true);
        dp.addDrawable(drawable);
        dp.scale();
        dp.setPixelScale();
        Graphics g2 = dp.getGraphics();
        if (g2 == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        drawable.draw(dp, g2);
        System.out.print("first drawing=" + (System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 5) {
            drawable.draw(dp, g2);
            ++i;
        }
        System.out.println("  avg time/drawing=" + (System.currentTimeMillis() - startTime) / 5L);
        g2.dispose();
    }

    public static void saveImage(JComponent comp, File outputFile, String outputFileFormat) throws IOException {
        block8: {
            try (FileOutputStream fos = null;){
                try {
                    File file = GUIUtils.fixExtension(outputFile, outputFileFormat);
                    fos = new FileOutputStream(file);
                    if (outputFileFormat.equals("eps")) {
                        EpsGraphics2D g = new EpsGraphics2D("", fos, 0, 0, comp.getWidth(), comp.getHeight());
                        comp.paint(g);
                        g.scale(0.24, 0.24);
                        g.close();
                        break block8;
                    }
                    BufferedImage bi = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
                    Graphics g = bi.getGraphics();
                    comp.paint(g);
                    g.dispose();
                    ImageIO.write((RenderedImage)bi, outputFileFormat, fos);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
        }
    }

    private static File fixExtension(File file, String ext) {
        String fileName = file.getAbsolutePath();
        String extension = XML.getExtension(fileName);
        if (extension == null || ".".equals(extension)) {
            fileName = String.valueOf(XML.stripExtension(fileName)) + "." + (ext.equals("jpeg") ? "jpg" : ext);
            file = new File(fileName);
        }
        return file;
    }

    public static void saveImage(JComponent component, String outputFileFormat, Component parent) {
        File outputFile = GUIUtils.showSaveDialog(component, DisplayRes.getString("GUIUtils.Title.SaveImage"));
        if (outputFile == null) {
            return;
        }
        try {
            GUIUtils.saveImage(component, outputFile, outputFileFormat);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(parent, "An error occurred while saving the file " + outputFile.getName() + ".'");
        }
    }

    public static void saveImageAs(JComponent component, String type, String title, String description, String[] extensions) {
        int selected;
        AsyncFileChooser chooser = OSPRuntime.createChooser(title, description, extensions);
        String fileName = OSPRuntime.chooseFilename(chooser);
        if (fileName == null) {
            return;
        }
        File file = GUIUtils.fixExtension(new File(fileName), extensions[0]);
        if (!OSPRuntime.isJS && file.exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
            return;
        }
        try {
            GUIUtils.saveImage(component, file, type);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Cursor createCustomCursor(Image image, Point hotspot, String name, int predefinedCursorType) {
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, hotspot, name);
        }
        catch (Exception ex) {
            try {
                return Cursor.getPredefinedCursor(predefinedCursorType);
            }
            catch (Exception exception) {
                return Cursor.getPredefinedCursor(12);
            }
        }
    }

    public static JTextPane newJTextPane() {
        return OSPRuntime.antiAliasText ? new JTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints rh = g2.getRenderingHints();
                rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(g);
            }

            @Override
            public void setPage(URL url) throws IOException {
                if (!GUIUtils.checkScrollPage(this, url)) {
                    super.setPage(url);
                }
            }
        } : new JTextPane(){

            @Override
            public void setPage(URL url) throws IOException {
                if (!GUIUtils.checkScrollPage(this, url)) {
                    super.setPage(url);
                }
            }
        };
    }

    protected static boolean checkScrollPage(JTextPane pane, URL url) {
        URL stream = (URL)pane.getDocument().getProperty("stream");
        if (stream == null || url == null || !stream.getPath().equals(url.getPath()) || !"file".equals(stream.getProtocol())) {
            return false;
        }
        String reference = url.getRef();
        if (reference != null) {
            pane.scrollToReference(reference);
        }
        return true;
    }

    public static JTextArea newJTextArea() {
        return OSPRuntime.antiAliasText ? new JTextArea(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints rh = g2.getRenderingHints();
                rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(g);
            }
        } : new JTextArea();
    }

    public static JToolBar getParentToolBar(Container c) {
        while ((c = c.getParent()) != null && !(c instanceof JToolBar)) {
        }
        return (JToolBar)c;
    }

    public static JToolBar getParentOrSelfToolBar(Container c) {
        if (!(c instanceof JToolBar)) {
            while ((c = c.getParent()) != null && !(c instanceof JToolBar)) {
            }
        }
        return (JToolBar)c;
    }

    public static JViewport getParentViewport(Container c) {
        while ((c = c.getParent()) != null && !(c instanceof JViewport)) {
        }
        return (JViewport)c;
    }

    public static String showInputDialog(Component c, String message, String title, int messageType, String value) throws HeadlessException {
        return (String)JOptionPane.showInputDialog(OSPRuntime.isJS ? null : c, message, title, messageType, null, null, value);
    }
}

