/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class GeneralPathLoader
extends XMLLoader {
    @Override
    public void saveObject(XMLControl control, Object obj) {
        GeneralPath shape = (GeneralPath)obj;
        PathIterator it = shape.getPathIterator(null, 0.001);
        control.setValue("winding rule", it.getWindingRule());
        control.setValue("segments", this.savePathSegments(it));
    }

    @Override
    public Object createObject(XMLControl control) {
        return new GeneralPath();
    }

    String savePathSegments(PathIterator it) {
        StringBuffer sb = new StringBuffer();
        float[] coord = new float[6];
        double x1 = 0.0;
        double y1 = 0.0;
        while (!it.isDone()) {
            switch (it.currentSegment(coord)) {
                case 1: {
                    x1 = coord[0];
                    y1 = coord[1];
                    sb.append("<LINETO " + x1 + " " + y1 + ">");
                    break;
                }
                case 0: {
                    x1 = coord[0];
                    y1 = coord[1];
                    sb.append("<MOVETO " + x1 + " " + y1 + ">");
                    break;
                }
                case 4: {
                    sb.append("<CLOSE>");
                    break;
                }
                default: {
                    System.out.println("Segment Type not supported. Type=" + it.currentSegment(coord));
                }
            }
            it.next();
        }
        return sb.toString();
    }

    void loadPathSegments(GeneralPath path, String segments) {
        String[] segs = segments.split(">");
        int i = 0;
        int n = segs.length;
        while (i < n) {
            String[] vals;
            if (segs[i].startsWith("<LINETO ")) {
                vals = segs[i].split(" ");
                path.lineTo(Float.parseFloat(vals[1]), Float.parseFloat(vals[2]));
            } else if (segs[i].startsWith("<MOVETO ")) {
                vals = segs[i].split(" ");
                path.moveTo(Float.parseFloat(vals[1]), Float.parseFloat(vals[2]));
            } else if (segs[i].startsWith("<CLOSE")) {
                path.closePath();
            }
            ++i;
        }
    }

    @Override
    public Object loadObject(XMLControl control, Object obj) {
        GeneralPath path = (GeneralPath)obj;
        path.reset();
        path.setWindingRule(control.getInt("winding rule"));
        this.loadPathSegments(path, control.getString("segments"));
        return path;
    }
}

