/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Grid
implements Drawable {
    protected int nx;
    protected int ny;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double dx;
    protected double dy;
    protected Color color = new Color(200, 200, 200, 100);
    protected GeneralPath generalPath = new GeneralPath();
    protected boolean visible = true;
    private BasicStroke stroke2 = new BasicStroke(2.0f);

    public Grid(int n) {
        this(n, n, 0.0, n, 0.0, n);
    }

    public Grid(int nx, int ny) {
        this(nx, ny, 0.0, nx, 0.0, ny);
    }

    public Grid(int _nx, int _ny, double xmin, double xmax, double ymin, double ymax) {
        this.nx = _nx;
        this.ny = _ny;
        this.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setColor(Color _color) {
        this.color = _color;
    }

    public Color getColor() {
        return this.color;
    }

    public double getDx() {
        return this.dx;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getDy() {
        return this.dy;
    }

    public void setMinMax(double _xmin, double _xmax, double _ymin, double _ymax) {
        this.generalPath.reset();
        this.xmin = (float)_xmin;
        this.xmax = (float)_xmax;
        this.ymin = (float)_ymin;
        this.ymax = (float)_ymax;
        this.dx = this.nx > 0 ? (double)((float)((this.xmax - this.xmin) / (double)this.nx)) : 1.0;
        this.dy = this.ny > 0 ? (double)((float)((this.ymax - this.ymin) / (double)this.ny)) : 1.0;
        if (!this.visible) {
            return;
        }
        float y = (float)this.ymin;
        if (this.ny <= 512) {
            int i = 0;
            while (i <= this.ny) {
                this.generalPath.moveTo((float)this.xmin, y);
                this.generalPath.lineTo((float)this.xmax, y);
                y = (float)((double)y + this.dy);
                ++i;
            }
        }
        float x = (float)this.xmin;
        if (this.nx <= 512) {
            int i = 0;
            while (i <= this.nx) {
                this.generalPath.moveTo(x, (float)this.ymin);
                this.generalPath.lineTo(x, (float)this.ymax);
                x = (float)((double)x + this.dx);
                ++i;
            }
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (Math.abs(panel.getXPixPerUnit() * (this.xmax - this.xmin) / (double)this.nx) < 4.0) {
            return;
        }
        if (Math.abs(panel.getYPixPerUnit() * (this.ymax - this.ymin) / (double)this.ny) < 4.0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Shape s = this.generalPath.createTransformedShape(panel.getPixelTransform());
        g2.setColor(this.color);
        g2.setStroke(this.stroke2);
        g2.draw(s);
        g2.setColor(Color.black);
    }

    public int[] getCellPoint(double x, double y) {
        int xindex = 0;
        xindex = (int)Math.floor((x - this.xmin) / this.dx);
        xindex = Math.max(0, xindex);
        xindex = Math.min(this.nx, xindex);
        int yindex = 0;
        yindex = (int)Math.floor((y - this.ymin) / this.dy);
        yindex = Math.max(0, yindex);
        yindex = Math.min(this.ny, yindex);
        return new int[]{xindex, xindex};
    }

    public Point2D.Double getClosestGridPoint(double x, double y) {
        int index = 0;
        index = (int)Math.round((x - this.xmin) / this.dx);
        index = Math.max(0, index);
        index = Math.min(this.nx, index);
        double gridx = this.xmin + this.dx * (double)index;
        index = (int)Math.round((y - this.ymin) / this.dy);
        index = Math.max(0, index);
        index = Math.min(this.ny, index);
        double gridy = this.ymin + this.dy * (double)index;
        return new Point2D.Double(gridx, gridy);
    }
}

