/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.BitSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;

public class HighlightableDataset
extends Dataset
implements Interactive {
    private BitSet highlighted;
    private BitSet previous;
    private Color highlightColor = new Color(255, 255, 0, 128);
    private Rectangle2D.Double[] hitShapes = new Rectangle2D.Double[16];
    private int hitIndex = -1;
    private final double[][] screenCoordinates = new double[2][];
    private int previousLen;

    public HighlightableDataset() {
    }

    public HighlightableDataset(Color markerColor) {
        super(markerColor);
    }

    @Override
    public void clear() {
        this.previousLen = this.xpoints.length;
        super.clear();
        if (this.previous == null) {
            this.previous = new BitSet();
            this.highlighted = new BitSet();
        }
        this.previous.clear();
        this.previous.or(this.highlighted);
        this.highlighted.clear();
    }

    public void restoreHighlights() {
        if (this.previous != null && this.previousLen == this.xpoints.length) {
            this.highlighted.clear();
            this.highlighted.or(this.previous);
        }
    }

    public void clearHighlights() {
        this.highlighted.clear();
    }

    public void setHighlighted(int i, boolean highlight) {
        this.highlighted.set(i, highlight);
    }

    public boolean isHighlighted(int n) {
        return this.highlighted.get(n);
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        if (!this.drawable()) {
            return;
        }
        this.setScreenCoordinates(drawingPanel);
        int offset = this.getMarkerSize() + 4;
        this.setHitShapes(offset);
        Graphics2D g2 = (Graphics2D)g.create();
        HighlightableDataset.drawClip(g2, drawingPanel, offset);
        super.drawData(drawingPanel, g2);
        g2.setColor(this.highlightColor);
        int i = this.highlighted.nextSetBit(0);
        while (i >= 0) {
            if (i < this.hitShapes.length && this.hitShapes[i] != null) {
                g2.fill(this.hitShapes[i]);
            }
            i = this.highlighted.nextSetBit(i + 1);
        }
        g2.dispose();
    }

    private void setScreenCoordinates(DrawingPanel drawingPanel) {
        double[] xValues = this.getXPointsRaw();
        double[] yValues = this.getYPointsRaw();
        if (this.screenCoordinates[0] == null || this.screenCoordinates[0].length != this.index) {
            this.screenCoordinates[0] = new double[this.index];
            this.screenCoordinates[1] = new double[this.index];
        }
        int i = 0;
        while (i < this.index) {
            if (Double.isNaN(yValues[i])) {
                this.screenCoordinates[1][i] = Double.NaN;
            } else {
                this.screenCoordinates[0][i] = drawingPanel.xToPix(xValues[i]);
                this.screenCoordinates[1][i] = drawingPanel.yToPix(yValues[i]);
            }
            ++i;
        }
    }

    private void setHitShapes(int offset) {
        int edge = 2 * offset;
        if (this.hitShapes.length < this.index) {
            this.hitShapes = new Rectangle2D.Double[this.index];
        }
        int i = 0;
        while (i < this.index) {
            double yp = this.screenCoordinates[1][i];
            if (Double.isNaN(yp)) {
                this.hitShapes[i] = null;
            } else {
                double xp = this.screenCoordinates[0][i];
                if (this.hitShapes[i] == null) {
                    this.hitShapes[i] = new Rectangle2D.Double(xp - (double)offset, yp - (double)offset, edge, edge);
                } else {
                    this.hitShapes[i].setRect(xp - (double)offset, yp - (double)offset, edge, edge);
                }
            }
            ++i;
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Dimension dim = panel.getSize();
        int l = panel.getLeftGutter();
        int r = panel.getRightGutter();
        if (xpix < l || xpix > dim.width - r) {
            return null;
        }
        int t = panel.getTopGutter();
        int b = panel.getBottomGutter();
        if (ypix < t || ypix > dim.height - b) {
            return null;
        }
        this.hitIndex = -1;
        int i = 0;
        int n = Math.min(this.hitShapes.length, this.index);
        while (i < n) {
            if (this.hitShapes[i] != null && this.hitShapes[i].contains(xpix, ypix)) {
                this.hitIndex = i;
                return this;
            }
            ++i;
        }
        return null;
    }

    public int getHitIndex() {
        return this.hitIndex;
    }

    public double[][] getScreenCoordinates() {
        return this.screenCoordinates;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return this.hitIndex >= 0 ? this.xpoints[this.hitIndex] : Double.NaN;
    }

    @Override
    public double getY() {
        return this.hitIndex >= 0 ? this.ypoints[this.hitIndex] : Double.NaN;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setHighlights(BitSet bs) {
        this.highlighted.clear();
        this.highlighted.or(bs);
    }

    public BitSet getHighlightedBS() {
        return this.highlighted;
    }

    public int getHighlightCount() {
        return this.highlighted.cardinality();
    }

    public int getValidYCount() {
        return this.index - HighlightableDataset.getNaNCount(this.ypoints, this.index);
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            XML.getLoader(Dataset.class).saveObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            control.setValue("highlighted", this.toArray(data.highlighted));
        }

        protected boolean[] toArray(BitSet bs) {
            boolean[] b = new boolean[bs.length()];
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                b[i] = true;
                i = bs.nextSetBit(i + 1);
            }
            return b;
        }

        @Override
        public Object createObject(XMLControl control) {
            return new HighlightableDataset();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(Dataset.class).loadObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            boolean[] highlighted = (boolean[])control.getObject("highlighted");
            if (highlighted != null) {
                int i = highlighted.length;
                while (--i >= 0) {
                    data.highlighted.set(i, highlighted[i]);
                }
            }
            return data;
        }
    }
}

