/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.TableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;

public class Histogram
extends DataTable.DataModel
implements Measurable,
LogMeasurable,
Data {
    public final TableModel model;
    HistogramDataset histogramDataset;
    public static final int DRAW_POINT = 0;
    public static final int DRAW_BIN = 1;
    public boolean logScale = false;
    public boolean adjustForWidth = false;
    private boolean visible = true;
    private boolean measured = true;
    protected Color binFillColor = Color.red;
    protected Color binEdgeColor = Color.red;
    protected int binStyle = 1;
    HashMap<Integer, Double> bins;
    double binWidth = 1.0;
    double binOffset = 0.0;
    boolean discrete = true;
    double xmin;
    double xmax;
    final int YMIN = 0;
    double ymax;
    String name;
    String binColumnName;
    String xColumnName = "x";
    String yColumnName;
    Map.Entry<Integer, Double>[] entries;
    boolean dataChanged;
    double sum;
    boolean normalizedToOne = false;
    double barOffset;
    protected int datasetID = this.hashCode();

    public Histogram() {
        this.binColumnName = DisplayRes.getString("Histogram.Column.BinNumber");
        this.yColumnName = DisplayRes.getString("Histogram.Column.Occurrences");
        this.name = DisplayRes.getString("Histogram.Title");
        this.model = new Model();
        this.clear();
    }

    public void read(String inputPathName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inputPathName));
        String s = null;
        while ((s = reader.readLine()) != null) {
            if ((s = s.trim()).equals("") || s.length() == 0 || s.charAt(0) == '#') continue;
            try {
                StringTokenizer st = new StringTokenizer(s, "\t");
                int binNumber = Integer.parseInt(st.nextToken());
                double numberOfoccurrences = Double.parseDouble(st.nextToken());
                Double prioroccurrences = this.bins.get(binNumber);
                if (prioroccurrences == null) {
                    this.bins.put(binNumber, new Double(numberOfoccurrences));
                } else {
                    this.bins.put(binNumber, new Double(numberOfoccurrences += prioroccurrences.doubleValue()));
                }
                this.ymax = Math.max(numberOfoccurrences, this.ymax);
                this.xmin = Math.min((double)binNumber * this.binWidth + this.binOffset, this.xmin);
                this.xmax = Math.max((double)binNumber * this.binWidth + this.binWidth + this.binOffset, this.xmax);
            }
            catch (NoSuchElementException nsee) {
                nsee.printStackTrace();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        reader.close();
        this.dataChanged = true;
    }

    public String toSortedString() {
        Set<Integer> keySet = this.bins.keySet();
        Object[] keys = keySet.toArray();
        Arrays.sort(keys);
        String s = "x\tx";
        StringBuffer buf = new StringBuffer(s.length() * keys.length);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            buf.append(key);
            buf.append("\t");
            buf.append(this.bins.get(keys[i]));
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        Set<Integer> set = this.bins.keySet();
        Iterator<Integer> keys = set.iterator();
        String s = "x\tx";
        StringBuffer buf = new StringBuffer(s.length() * set.size());
        while (keys.hasNext()) {
            Integer binNumber = keys.next();
            Double occurrences = this.bins.get(binNumber);
            buf.append(binNumber);
            buf.append("\t");
            buf.append(occurrences);
            buf.append("\n");
        }
        return buf.toString();
    }

    public int hashCode(double value) {
        return (int)Math.floor((value - this.binOffset) / this.binWidth);
    }

    public synchronized void append(double value, double numberOfoccurrences) {
        this.sum += numberOfoccurrences;
        int binNumber = this.hashCode(value);
        Double occurrences = this.bins.get(binNumber);
        if (occurrences == null) {
            this.bins.put(binNumber, new Double(numberOfoccurrences));
        } else {
            this.bins.put(binNumber, new Double(numberOfoccurrences += occurrences.doubleValue()));
        }
        this.ymax = Math.max(numberOfoccurrences, this.ymax);
        this.xmin = Math.min((double)binNumber * this.binWidth + this.binOffset, this.xmin);
        this.xmax = Math.max((double)binNumber * this.binWidth + this.binWidth + this.binOffset, this.xmax);
        this.dataChanged = true;
    }

    public void append(double value) {
        this.append(value, 1.0);
    }

    public void append(String inputPathName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputPathName));
        String s = null;
        while ((s = br.readLine()) != null) {
            if ((s = s.trim()).equals("") || s.length() == 0 || s.charAt(0) == '#') continue;
            try {
                double d = Double.parseDouble(s);
                this.append(d, 1.0);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        br.close();
    }

    public void append(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.append(values[i], 1.0);
            ++i;
        }
    }

    public void setVisible(boolean visibility) {
        this.visible = visibility;
    }

    @Override
    public synchronized void draw(DrawingPanel drawingPanel, Graphics g) {
        if (this.bins.size() == 0 || !this.visible) {
            return;
        }
        g = g.create();
        g.setColor(this.binFillColor);
        g.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        for (Integer binNumber : this.bins.keySet()) {
            Double d = this.bins.get(binNumber);
            if (d == null) break;
            double occurrences = d;
            if (this.normalizedToOne) {
                occurrences /= this.sum;
            }
            if (this.binStyle == 1) {
                this.drawBin(drawingPanel, g, binNumber, occurrences);
                continue;
            }
            this.drawPoint(drawingPanel, g, binNumber, occurrences);
        }
        g.dispose();
    }

    public synchronized void clear() {
        this.bins = new HashMap();
        this.xmin = 2.147483647E9;
        this.xmax = -2.147483648E9;
        this.ymax = -2.147483648E9;
        this.sum = 0.0;
        this.dataChanged = true;
    }

    public void setBinStyle(int style) {
        this.binStyle = style;
    }

    public void setDiscrete(boolean _discrete) {
        this.discrete = _discrete;
    }

    public void setBinOffset(double _binOffset) {
        this.binOffset = _binOffset;
    }

    public void setBarOffset(double _barOffset) {
        this.barOffset = _barOffset;
    }

    public Color getLineColor() {
        return this.binEdgeColor;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{this.binEdgeColor, this.binEdgeColor};
    }

    public Color getFillColor() {
        return this.binFillColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.binFillColor, this.binFillColor};
    }

    public void setBinColor(Color binColor) {
        this.binFillColor = binColor;
        this.binEdgeColor = binColor;
    }

    public void setBinColor(Color fillColor, Color edgeColor) {
        this.binFillColor = fillColor;
        this.binEdgeColor = edgeColor;
    }

    public void setBinWidth(double _binWidth) {
        this.binWidth = _binWidth;
    }

    public void setName(String name) {
        this.name = TeXParser.parseTeX(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.xColumnName, this.yColumnName};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName) {
        this.xColumnName = TeXParser.parseTeX(_xColumnName);
        this.yColumnName = TeXParser.parseTeX(_yColumnName);
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName, String _name) {
        this.xColumnName = TeXParser.parseTeX(_xColumnName);
        this.yColumnName = TeXParser.parseTeX(_yColumnName);
        this.name = TeXParser.parseTeX(_name);
    }

    public void setNormalizedToOne(boolean b) {
        this.normalizedToOne = b;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public double getBinOffset() {
        return this.binOffset;
    }

    @Override
    public double getXMin() {
        return this.discrete && this.bins.size() > 1 ? this.xmin - this.binWidth : this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        double max;
        double d = max = this.normalizedToOne ? this.ymax / this.sum : this.ymax;
        if (this.adjustForWidth) {
            max /= this.getBinWidth();
        }
        if (this.logScale) {
            max = Math.log(max);
        }
        return max;
    }

    @Override
    public double getXMinLogscale() {
        double xmin = this.getXMin();
        if (xmin > 0.0) {
            return xmin;
        }
        return this.binOffset;
    }

    @Override
    public double getXMaxLogscale() {
        double xmax = this.getXMax();
        if (xmax > 0.0) {
            return xmax;
        }
        return this.binOffset + 10.0;
    }

    @Override
    public double getYMinLogscale() {
        return 1.0;
    }

    @Override
    public double getYMaxLogscale() {
        return Math.max(10.0, this.getYMax());
    }

    @Override
    public boolean isMeasured() {
        return this.bins.size() > 0 && this.measured;
    }

    public void setMeasured(boolean measure) {
        this.measured = measure;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return this.binColumnName;
        }
        if (column == 1) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    @Override
    public int getRowCount() {
        return this.bins.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public double getValueAt(int row, int column) {
        this.updateEntries();
        Map.Entry<Integer, Double> entry = this.entries[row];
        if (column == 0) {
            return entry.getKey().intValue();
        }
        if (column == 1) {
            return (double)entry.getKey().intValue() * this.binWidth + this.binWidth / 2.0 + this.binOffset;
        }
        double d = entry.getValue();
        return this.normalizedToOne ? d / this.sum : d;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    protected void drawPoint(DrawingPanel drawingPanel, Graphics g, int binNumber, double occurrences) {
        int px = drawingPanel.xToPix(this.getLeftMostBinPosition(binNumber));
        int py = drawingPanel.yToPix(occurrences);
        int pointRadius = 2;
        if (this.discrete) {
            g.fillRect(px - pointRadius, py - pointRadius, pointRadius * 2, pointRadius * 2);
        } else {
            int px2 = drawingPanel.xToPix(this.getRightMostBinPosition(binNumber));
            int pWidth = px2 - px;
            g.fillRect(px, py, pWidth, pointRadius * 2);
        }
    }

    protected void drawBin(DrawingPanel drawingPanel, Graphics g, int binNumber, double occurrences) {
        if (this.adjustForWidth) {
            occurrences /= this.getBinWidth();
        }
        if (this.logScale) {
            occurrences = Math.max(0.0, Math.log(occurrences));
        }
        int binlx = drawingPanel.xToPix(this.getLeftMostBinPosition(binNumber));
        if (this.discrete) {
            if (this.binEdgeColor != null) {
                g.setColor(this.binEdgeColor);
                g.drawLine(binlx, drawingPanel.yToPix(0.0), binlx, drawingPanel.yToPix(occurrences));
            }
        } else {
            int binrx = drawingPanel.xToPix(this.getRightMostBinPosition(binNumber));
            int pWidth = binrx - binlx;
            double pHeight = drawingPanel.getYPixPerUnit() * occurrences;
            Rectangle2D.Double rect = new Rectangle2D.Double(binlx, drawingPanel.yToPix(occurrences), pWidth, pHeight);
            Graphics2D g2 = (Graphics2D)g;
            if (this.binFillColor != null) {
                g.setColor(this.binFillColor);
                g2.fill(rect);
            }
            if (this.binEdgeColor != null) {
                g.setColor(this.binEdgeColor);
                g2.draw(rect);
            }
        }
    }

    public double[] getXPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[0];
        }
        double[] xdata = new double[nbins];
        int i = 0;
        while (i < nbins) {
            xdata[i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            ++i;
        }
        return xdata;
    }

    public double[] getYPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[0];
        }
        double[] ydata = new double[nbins];
        int i = 0;
        while (i < nbins) {
            Integer binNumber = i;
            Double bin = this.bins.get(binNumber);
            ydata[i] = bin == null ? 0.0 : bin;
            ++i;
        }
        return ydata;
    }

    public double[][] getPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[2][0];
        }
        double[][] data = new double[2][nbins];
        int iStart = (int)(this.xmin / this.binWidth);
        int i = 0;
        while (i < nbins) {
            Integer binNumber = i + iStart;
            Double bin = this.bins.get(binNumber);
            data[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            data[1][i] = bin == null ? 0.0 : bin;
            ++i;
        }
        return data;
    }

    public double[][] getLogPoints() {
        int nbins = (int)Math.round((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[2][0];
        }
        double[][] data = new double[2][nbins];
        int iStart = (int)(this.xmin / this.binWidth);
        int i = 0;
        while (i < nbins) {
            Integer binNumber = i + iStart;
            Double bin = this.bins.get(binNumber);
            data[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            data[1][i] = bin == null ? 0.0 : bin;
            data[1][i] = data[1][i] > 0.0 ? Math.log(data[1][i]) : 0.0;
            ++i;
        }
        return data;
    }

    public double getLeftMostBinPosition(int binNumber) {
        return (double)binNumber * this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    public double getRightMostBinPosition(int binNumber) {
        return (double)binNumber * this.binWidth + this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    private synchronized void updateEntries() {
        if (this.dataChanged) {
            this.entries = this.bins.entrySet().toArray(this.entries);
            this.dataChanged = false;
        }
    }

    @Override
    public double[][] getData2D() {
        double[][] data = this.logScale ? this.getLogPoints() : this.getPoints();
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        double[][] data = this.logScale ? this.getLogPoints() : this.getPoints();
        double[] bins = data[0];
        double[] vals = data[1];
        double start = 0.0;
        double stop = this.getBinWidth();
        if (bins != null && bins.length > 0) {
            start = bins[0] - this.getBinWidth() / 2.0;
            stop = bins[bins.length - 1] + this.getBinWidth() / 2.0;
        }
        if (this.histogramDataset == null) {
            this.histogramDataset = new HistogramDataset(start, stop, this.getBinWidth());
        } else {
            this.histogramDataset.clear();
            this.histogramDataset.setBinWidth(start, stop, this.getBinWidth());
        }
        this.histogramDataset.setXYColumnNames(this.xColumnName, this.yColumnName, this.name);
        this.histogramDataset.append(bins, vals);
        this.histogramDataset.setMarkerColor(this.binFillColor, this.binEdgeColor);
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        list.add(this.histogramDataset);
        return list;
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramLoader();
    }

    protected static class HistogramLoader
    extends XMLLoader {
        protected HistogramLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Histogram his = (Histogram)obj;
            double[][] points = his.logScale ? his.getLogPoints() : his.getPoints();
            double[] bins = points[0];
            double[] vals = points[1];
            control.setValue("log_scale", his.logScale);
            control.setValue("discrete", his.discrete);
            control.setValue("adjust_for_width", his.adjustForWidth);
            control.setValue("bin_fill_color", his.binFillColor);
            control.setValue("bin_edge_color", his.binEdgeColor);
            control.setValue("bin_style", his.binStyle);
            control.setValue("bin_width", his.binWidth);
            control.setValue("bin_offset", his.binOffset);
            control.setValue("name", his.name);
            control.setValue("x_column_name", his.xColumnName);
            control.setValue("y_column_name", his.yColumnName);
            control.setValue("bin_column_name", his.binColumnName);
            control.setValue("bins", bins);
            control.setValue("vals", vals);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Histogram();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Histogram his = (Histogram)obj;
            double[] bins = (double[])control.getObject("bins");
            double[] vals = (double[])control.getObject("vals");
            his.name = control.getString("name");
            his.xColumnName = control.getString("x_column_name");
            his.yColumnName = control.getString("y_column_name");
            his.binColumnName = control.getString("bin_column_name");
            his.logScale = control.getBoolean("log_scale");
            his.discrete = control.getBoolean("discrete");
            his.adjustForWidth = control.getBoolean("adjust_for_width");
            his.binFillColor = (Color)control.getObject("bin_fill_color");
            his.binEdgeColor = (Color)control.getObject("bin_edge_color");
            his.binStyle = control.getInt("bin_style");
            his.binWidth = control.getDouble("bin_width");
            his.binOffset = control.getDouble("bin_offset");
            his.adjustForWidth = control.getBoolean("adjust_for_width");
            if (bins != null && vals != null) {
                int i = 0;
                int n = bins.length;
                while (i < n) {
                    his.append(bins[i], vals[i]);
                    ++i;
                }
            }
            return obj;
        }
    }

    public class Model
    extends DataTable.OSPTableModel {
        @Override
        public int getRowCount() {
            return Histogram.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return Histogram.this.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Histogram.this.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Integer.class : Double.class;
        }
    }
}

