/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;

public class HistogramDataset
extends Dataset {
    double min;
    double max;
    double binSize = 1.0;
    int n;
    double[] binVals;
    double[] xVals;
    int counts;
    int missedCounts;

    public HistogramDataset(double binMin, double binMax, double binSize) {
        this.setMarkerShape(8);
        this.setBinWidth(binMin, binMax, binSize);
    }

    protected HistogramDataset() {
        this(0.0, 100.0, 1.0);
    }

    @Override
    public void append(double x, double y) {
        int index = (int)((x - this.min) / this.binSize);
        if (index < 0 || index >= this.n) {
            ++this.missedCounts;
        } else {
            ++this.counts;
            int n = index;
            this.binVals[n] = this.binVals[n] + y;
            this.ymax = Math.max(this.binVals[index], this.ymax);
            this.ymin = Math.min(this.binVals[index], this.ymin);
            System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
            if (this.isConnected()) {
                this.recalculatePath();
            }
        }
    }

    @Override
    public void append(double[] xpoints, double[] ypoints) {
        int j = 0;
        int nj = xpoints.length;
        while (j < nj) {
            int index = (int)((xpoints[j] - this.min) / this.binSize);
            if (index < 0 || index >= this.n) {
                ++this.missedCounts;
            } else {
                ++this.counts;
                int n = index;
                this.binVals[n] = this.binVals[n] + ypoints[j];
                this.ymax = Math.max(this.binVals[index], this.ymax);
                this.ymin = Math.min(this.binVals[index], this.ymin);
            }
            ++j;
        }
        System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
        if (this.isConnected()) {
            this.recalculatePath();
        }
    }

    @Override
    public double getXMin() {
        return this.min;
    }

    @Override
    public double getXMax() {
        return this.max;
    }

    public void setBinWidth(double binMin, double binMax, double binSize) {
        this.counts = 0;
        this.missedCounts = 0;
        this.min = binMin;
        this.max = binMax;
        this.binSize = binSize;
        this.n = (int)((binMax - binMin) / binSize);
        this.binVals = new double[this.n];
        this.xVals = new double[this.n];
        double x = this.min + binSize / 2.0;
        int i = 0;
        while (i < this.n) {
            this.xVals[i] = x;
            x += this.binSize;
            ++i;
        }
        super.set(this.xVals, this.binVals);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.n) {
            this.binVals[i] = 0.0;
            ++i;
        }
        this.counts = 0;
        this.missedCounts = 0;
        this.ymax = 0.0;
        this.ymin = 0.0;
        if (this.n == 0) {
            return;
        }
        System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
        if (this.isConnected()) {
            this.recalculatePath();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramDatasetLoader();
    }

    protected static class HistogramDatasetLoader
    extends Dataset.Loader {
        protected HistogramDatasetLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            HistogramDataset dataset = (HistogramDataset)obj;
            control.setValue("min", dataset.min);
            control.setValue("max", dataset.max);
            control.setValue("bin_size", dataset.binSize);
            control.setValue("number_of_bins", dataset.n);
            control.setValue("bin_vals", dataset.binVals);
            control.setValue("x_vals", dataset.xVals);
            control.setValue("counts", dataset.counts);
            control.setValue("missed_counts", dataset.missedCounts);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            HistogramDataset dataset = (HistogramDataset)obj;
            dataset.setBinWidth(control.getDouble("min"), control.getDouble("max"), control.getDouble("bin_size"));
            dataset.binVals = (double[])control.getObject("bin_vals");
            dataset.xVals = (double[])control.getObject("x_vals");
            dataset.counts = control.getInt("counts");
            dataset.missedCounts = control.getInt("missed_counts");
            if (dataset.n == 0) {
                return obj;
            }
            System.arraycopy(dataset.xVals, 0, dataset.xpoints, 0, dataset.n);
            System.arraycopy(dataset.binVals, 0, dataset.ypoints, 0, dataset.n);
            if (dataset.isConnected()) {
                dataset.recalculatePath();
            }
            return obj;
        }
    }
}

