/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.OSPRuntime;

public class IntegerImage
implements Measurable {
    int[] imagePixels;
    MemoryImageSource imageSource;
    Image image;
    int nrow;
    int ncol;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    boolean visible = true;
    boolean dirtyImage = true;

    public static IntegerImage getGrayscaleImage(int[][] data) {
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        return new IntegerImage(ccm, data);
    }

    public static IntegerImage getBinaryImage(int[][] data) {
        byte[] byArray = new byte[2];
        byArray[0] = -1;
        byte[] byArray2 = new byte[2];
        byArray2[1] = -1;
        IndexColorModel colorModel = new IndexColorModel(1, 2, byArray, new byte[2], byArray2);
        return new IntegerImage(colorModel, data);
    }

    public static IntegerImage get256ColorImage(int[][] data) {
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        int i = 0;
        while (i < 256) {
            double x = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double val = Math.exp(-x * x * 8.0);
            reds[i] = (byte)(255.0 * val);
            x = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            val = Math.exp(-x * x * 8.0);
            greens[i] = (byte)(255.0 * val);
            x = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            val = Math.exp(-x * x * 8.0);
            blues[i] = (byte)(255.0 * val);
            ++i;
        }
        IndexColorModel colorModel = new IndexColorModel(8, 256, reds, greens, blues);
        return new IntegerImage(colorModel, data);
    }

    public static IntegerImage getColorImage(Color[] colors, int[][] data) {
        int n = colors.length;
        byte[] reds = new byte[n];
        byte[] greens = new byte[n];
        byte[] blues = new byte[n];
        int i = 0;
        while (i < n) {
            reds[i] = (byte)colors[i].getRed();
            greens[i] = (byte)colors[i].getGreen();
            blues[i] = (byte)colors[i].getBlue();
            ++i;
        }
        IndexColorModel colorModel = new IndexColorModel(8, n, reds, greens, blues);
        return new IntegerImage(colorModel, data);
    }

    public IntegerImage(int[][] data) {
        this(null, data);
    }

    public IntegerImage(ColorModel colorModel, int[][] data) {
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        this.nrow = data.length;
        this.ncol = data[0].length;
        this.imagePixels = new int[this.nrow * this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int[] row = data[i];
            System.arraycopy(row, 0, this.imagePixels, i * this.ncol, this.ncol);
            ++i;
        }
        this.imageSource = new MemoryImageSource(this.ncol, this.nrow, colorModel, this.imagePixels, 0, this.ncol);
        this.imageSource.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        this.dirtyImage = false;
        this.xmin = 0.0;
        this.xmax = this.ncol;
        this.ymin = this.nrow;
        this.ymax = 0.0;
    }

    public void updateImage(int[][] val) {
        int i = 0;
        while (i < this.nrow) {
            int[] row = val[i];
            System.arraycopy(row, 0, this.imagePixels, i * this.ncol, this.ncol);
            ++i;
        }
        this.imageSource.newPixels(0, 0, this.ncol, this.nrow);
        this.dirtyImage = true;
    }

    public void setBlock(int row_offset, int col_offset, int[][] val) {
        if (val == null) {
            return;
        }
        int block_nrow = val.length;
        int block_ncol = val[0].length;
        if (row_offset < 0 || row_offset + block_nrow > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in IntegerImage setBlock.");
        }
        if (col_offset < 0 || col_offset + block_ncol > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in IntegerImage setBlock.");
        }
        int ir = 0;
        while (ir < block_nrow) {
            int[] row = val[ir];
            int index = (ir + row_offset) * this.ncol + col_offset;
            System.arraycopy(row, 0, this.imagePixels, index, block_ncol);
            ++ir;
        }
        this.dirtyImage = true;
    }

    public void setRow(int row, int[] val) {
        if (val == null) {
            return;
        }
        if (row < 0 || row >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in IntegerImage setRow.");
        }
        if (val.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in IntegerImage setRow.");
        }
        System.arraycopy(val, 0, this.imagePixels, row * this.ncol, val.length);
        this.dirtyImage = true;
    }

    public void setCol(int col, int[] val) {
        if (val == null) {
            return;
        }
        if (val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in IntegerImage setCol.");
        }
        if (col < 0 || col >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in IntegerImage setCol.");
        }
        int rindex = 0;
        int nr = val.length;
        while (rindex < nr) {
            this.imagePixels[rindex * this.ncol + col] = val[rindex];
            ++rindex;
        }
        this.dirtyImage = true;
    }

    public void setCell(int row, int col, int val) {
        this.imagePixels[row * this.ncol + col] = val;
        this.imageSource.newPixels(row, col, 1, 1);
        this.dirtyImage = true;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.dirtyImage) {
            this.image = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        }
        if (this.image == null) {
            panel.setMessage(DisplayRes.getString("Null Image"));
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform gat = g2.getTransform();
        RenderingHints hints = null;
        if (OSPRuntime.setRenderingHints) {
            hints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        double sx = (this.xmax - this.xmin) * panel.xPixPerUnit / (double)this.ncol;
        double sy = (this.ymax - this.ymin) * panel.yPixPerUnit / (double)this.nrow;
        g2.transform(AffineTransform.getTranslateInstance((double)panel.leftGutter + panel.xPixPerUnit * (this.xmin - panel.xmin), (double)panel.topGutter + panel.yPixPerUnit * (panel.ymax - this.ymax)));
        g2.transform(AffineTransform.getScaleInstance(sx, sy));
        g2.drawImage(this.image, 0, 0, panel);
        g2.setTransform(gat);
        if (hints != null) {
            g2.setRenderingHints(hints);
        }
    }

    @Override
    public boolean isMeasured() {
        return this.image != null;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    public void setXMin(double _xmin) {
        this.xmin = _xmin;
    }

    public void setXMax(double _xmax) {
        this.xmax = _xmax;
    }

    public void setYMin(double _ymin) {
        this.ymin = _ymin;
    }

    public void setYMax(double _ymax) {
        this.ymax = _ymax;
    }

    public void setMinMax(double _xmin, double _xmax, double _ymin, double _ymax) {
        this.xmin = _xmin;
        this.xmax = _xmax;
        this.ymin = _ymin;
        this.ymax = _ymax;
    }
}

