/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class InteractiveArrow
extends BoundedShape {
    Point2D.Double[] hotSpots = new Point2D.Double[2];
    BasicStroke stroke = new BasicStroke(2.0f);
    Shape head;
    static final int HEAD = 1;
    private AffineTransform trIA = new AffineTransform();
    private Rectangle2D.Double rectIA = new Rectangle2D.Double();

    public InteractiveArrow(double x, double y, double w, double h) {
        super(new Line2D.Double(0.0, 0.0, w, h), x, y);
        this.theta = w == 0.0 ? 0.0 : Math.atan2(h, w);
        this.head = this.getHead(this.theta);
        this.setRotateDrag(true);
        this.hideBounds = true;
        this.width = w;
        this.height = h;
        int i = 0;
        int n = this.hotSpots.length;
        while (i < n) {
            this.hotSpots[i] = new Point2D.Double();
            ++i;
        }
    }

    public void setStrokeWidth(double width) {
        this.stroke = new BasicStroke((float)width);
    }

    @Override
    public void setOffset(double xoffset, double yoffset) {
    }

    @Override
    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        this.hotspot = 6;
        if (!this.enabled) {
            return false;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(xpix, ypix, this.hotSpots);
            return true;
        }
        return this.pixelBounds.contains(xpix, ypix);
    }

    @Override
    public void setTheta(double theta) {
        double len = Math.sqrt(this.width * this.width + this.height * this.height);
        double dx = len * Math.cos(theta);
        double dy = len * Math.sin(theta);
        this.shape = new Line2D.Double(this.x, this.y, this.x + dx, this.y + dy);
        this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        this.width = dx;
        this.height = dy;
        this.theta = theta;
        this.head = this.getHead(theta);
    }

    @Override
    void setHotSpotXY(double x, double y) {
        if (this.hideBounds) {
            this.setXY(x, y);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == 0) {
            this.setXY(x, y);
        } else if (this.rotateDrag && this.selected && this.hotspot == 1) {
            double r = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
            double dx = x - this.x;
            double dy = y - this.y;
            this.shape = new Line2D.Double(this.x, this.y, this.x + dx, this.y + dy);
            this.width = dx;
            this.height = dy;
            this.theta = this.width == 0.0 ? this.theta : Math.atan2(r * this.height, this.width);
            this.head = this.getHead(this.theta);
        }
    }

    public void setWidthHeight(double width, double height) {
        this.shape = new Line2D.Double(this.x, this.y, this.x + width, this.y + height);
        this.width = width;
        this.height = height;
        this.theta = width == 0.0 ? this.theta : Math.atan2(height, width);
        this.head = this.getHead(this.theta);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        Shape temp;
        Graphics2D g2 = (Graphics2D)g;
        this.getPixelPt(panel);
        this.pixelBounds = this.computePixelBounds(this.pixelPt);
        if (this.pixelSized) {
            this.trIA.setTransform(1.0, 0.0, 0.0, -1.0, -this.x + this.pixelPt.x, this.y + this.pixelPt.y);
            temp = this.trIA.createTransformedShape(this.shape);
        } else {
            temp = this.toPixels.createTransformedShape(this.shape);
        }
        g2.setPaint(this.edgeColor);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.draw(temp);
        this.hotSpots[0].setLocation(this.pixelPt);
        this.pixelPt.setLocation(this.x + this.width, this.y + this.height);
        this.toPixels.transform(this.pixelPt, this.pixelPt);
        this.hotSpots[1].setLocation(this.pixelPt);
        temp = AffineTransform.getTranslateInstance(this.pixelPt.x, this.pixelPt.y).createTransformedShape(this.head);
        g2.fill(temp);
        g2.draw(temp);
        g2.setStroke(oldStroke);
        if (!this.selected || this.hideBounds) {
            return;
        }
        g2.setPaint(this.boundsColor);
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[0].getX() - this.delta, (int)this.hotSpots[0].getY() - this.delta, this.d2, this.d2);
        }
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[1].getX() - this.delta, (int)this.hotSpots[1].getY() - this.delta, this.d2, this.d2);
        }
        g2.setPaint(Color.BLACK);
    }

    private Shape computePixelBounds(Point2D.Double pt) {
        double dx = this.toPixels.getScaleX() * this.width;
        double dy = this.toPixels.getScaleY() * this.height;
        double len = Math.sqrt(dx * dx + dy * dy) + (double)this.delta;
        this.rectIA.setFrame(pt.x, pt.y - (double)this.delta, len, this.d2);
        return this.theta == 0.0 ? this.rectIA : this.getRotateInstance(-this.theta, pt.x, pt.y).createTransformedShape(this.rectIA);
    }

    @Override
    public Cursor getPreferredCursor() {
        if (this.xyDrag && this.hotspot == 0) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.rotateDrag && this.hotspot == 1) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.selected) {
            return Cursor.getPredefinedCursor(1);
        }
        return Cursor.getPredefinedCursor(12);
    }

    private Shape getHead(double theta) {
        float headSize = 4.0f + 2.0f * this.stroke.getLineWidth();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(-headSize, -headSize / 2.0f);
        path.lineTo(-headSize, headSize / 2.0f);
        path.closePath();
        this.trIA.setToRotation(-theta);
        return this.trIA.createTransformedShape(path);
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveArrowLoader();
    }

    protected static class InteractiveArrowLoader
    extends XMLLoader {
        protected InteractiveArrowLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            InteractiveArrow arrow = (InteractiveArrow)obj;
            control.setValue("x", arrow.x);
            control.setValue("y", arrow.y);
            control.setValue("width", arrow.width);
            control.setValue("height", arrow.height);
            control.setValue("is enabled", arrow.isEnabled());
            control.setValue("is measured", arrow.isMeasured());
            control.setValue("color", arrow.color);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new InteractiveArrow(0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            InteractiveArrow arrow = (InteractiveArrow)obj;
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            double w = control.getDouble("width");
            double h = control.getDouble("height");
            arrow.enabled = control.getBoolean("is enabled");
            arrow.enableMeasure = control.getBoolean("is measured");
            arrow.color = (Color)control.getObject("color");
            arrow.setXY(x, y);
            arrow.setWidthHeight(w, h);
            return obj;
        }
    }
}

