/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveShape;

public class InteractiveImage
extends InteractiveShape
implements ImageObserver {
    protected Image image;

    public InteractiveImage(Image image, double x, double y) {
        super(null, x, y);
        this.image = image;
        this.width = image.getWidth(this);
        this.width = Math.max(0.0, this.width);
        this.height = image.getHeight(this);
        this.height = Math.max(0.0, this.height);
        this.shapeClass = image.getClass().getName();
        this.setPixelSized(true);
    }

    @Override
    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        if (this.image == null || !this.enabled) {
            return false;
        }
        int r = Math.min(this.image.getWidth(null) / 2, this.image.getHeight(null) / 2) + 1;
        return Math.abs(panel.xToPix(this.x) - xpix) < r && Math.abs(panel.yToPix(this.y) - ypix) < r;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        this.getPixelPt(panel);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(this.pixelPt.x, this.pixelPt.y);
        this.trIS.setToTranslation(-this.width / 2.0, -this.height / 2.0);
        this.trIS.rotate(-this.theta, this.width / 2.0, this.height / 2.0);
        this.trIS.scale(this.width / (double)this.image.getWidth(null), this.height / (double)this.image.getHeight(null));
        g2.drawImage(this.image, this.trIS, null);
        g2.translate(-this.pixelPt.x, -this.pixelPt.y);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 1) == 1) {
            this.width = width;
        }
        if ((infoflags & 2) == 1) {
            this.height = height;
        }
        return (infoflags & 0x20) != 1;
    }
}

