/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredCircle;
import org.opensourcephysics.display.TeXParser;

public class InteractiveLabel
extends MeasuredCircle
implements Interactive {
    public static final int TOP_LEFT_LOCATION = 0;
    public static final int CENTER_LOCATION = 1;
    public static final int TOP_CENTER_LOCATION = 2;
    public int connection_location = 1;
    boolean enabled = true;
    protected String text = null;
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    Box box = new Box();

    public InteractiveLabel() {
        super(0.0, 0.0);
        this.color = Color.YELLOW;
        this.pixRadius = 1;
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public InteractiveLabel(String str) {
        this();
        this.text = TeXParser.parseTeX(str);
    }

    @Override
    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public void setText(String _text) {
        this.text = TeXParser.parseTeX(_text);
    }

    public void setText(String _text, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.text = TeXParser.parseTeX(_text);
    }

    public void resetBoxSize() {
        this.box.boxHeight = 0;
        this.box.boxWidth = 0;
    }

    public void setConnectionPoint(int location) {
        this.connection_location = location;
    }

    public void setOffsetX(int offset) {
        this.box.xoffset = offset;
    }

    public int getOffsetX() {
        return this.box.xoffset;
    }

    public void setOffsetY(int offset) {
        this.box.yoffset = offset;
    }

    public int getOffsetY() {
        return this.box.yoffset;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        String tempText = this.text;
        if (tempText == null) {
            return;
        }
        super.draw(panel, g);
        this.box.computeBoxMetrics(panel, g);
        int xpix = panel.xToPix(this.x);
        int ypix = panel.yToPix(this.y);
        g.setColor(Color.YELLOW);
        g.drawLine(xpix, ypix, this.box.connectX, this.box.connectY);
        g.setColor(Color.BLACK);
        this.box.draw(panel, g);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.box.isInside(panel, xpix, ypix)) {
            return this.box;
        }
        return null;
    }

    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        return this.box.isInside(panel, xpix, ypix);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.box.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    class Box
    extends AbstractInteractive {
        int leftPix;
        int topPix;
        int boxHeight = 0;
        int boxWidth = 0;
        int xpix = 0;
        int ypix = 0;
        int xoffset = 0;
        int yoffset = 0;
        int connectX;
        int connectY;
        DrawingPanel panel;

        Box() {
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            this.panel = panel.dref(this);
            String tempText = InteractiveLabel.this.text;
            if (tempText == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.color);
            g2.setFont(InteractiveLabel.this.font);
            g2.setClip(0, 0, panel.getWidth(), panel.getHeight());
            g2.setColor(Color.YELLOW);
            g2.fillRect(this.leftPix, this.topPix, this.boxWidth, this.boxHeight);
            g2.setColor(Color.BLACK);
            g2.drawRect(this.leftPix, this.topPix, this.boxWidth, this.boxHeight);
            g2.drawString(tempText, this.leftPix + 3, this.topPix + this.boxHeight - 2);
            g2.dispose();
        }

        void computeBoxMetrics(DrawingPanel panel, Graphics g) {
            String tempText = InteractiveLabel.this.text;
            if (tempText == null || panel == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Font oldFont = g2.getFont();
            g2.setFont(InteractiveLabel.this.font);
            FontMetrics fm = g2.getFontMetrics();
            int sh = fm.getAscent() + 2;
            int sw = fm.stringWidth(tempText) + 6;
            this.boxHeight = Math.max(this.boxHeight, sh);
            this.boxWidth = Math.max(this.boxWidth, sw);
            this.xpix = panel.xToPix(InteractiveLabel.this.x);
            this.ypix = panel.yToPix(InteractiveLabel.this.y);
            this.connectX = this.leftPix = this.xpix + this.xoffset;
            this.connectY = this.topPix = this.ypix + this.yoffset;
            if (InteractiveLabel.this.connection_location == 2) {
                this.connectX += this.boxWidth / 2;
            } else if (InteractiveLabel.this.connection_location == 1) {
                this.connectX += this.boxWidth / 2;
                this.connectY += this.boxHeight / 2;
            }
            g2.setFont(oldFont);
        }

        @Override
        public void setXY(double x, double y) {
            if (this.panel == null) {
                return;
            }
            int x1 = this.panel.xToPix(InteractiveLabel.this.x);
            int x2 = this.panel.xToPix(x);
            this.xoffset = x2 - x1;
            int y1 = this.panel.yToPix(InteractiveLabel.this.y);
            int y2 = this.panel.yToPix(y);
            this.yoffset = y2 - y1;
        }

        @Override
        public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
            return xpix >= this.leftPix && xpix <= this.leftPix + this.boxWidth && ypix >= this.topPix && ypix <= this.topPix + this.boxHeight;
        }
    }
}

