/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Selectable;

public class InteractivePanel
extends DrawingPanel
implements InteractiveMouseHandler {
    public static final int MOUSE_PRESSED = 1;
    public static final int MOUSE_RELEASED = 2;
    public static final int MOUSE_DRAGGED = 3;
    public static final int MOUSE_CLICKED = 4;
    public static final int MOUSE_ENTERED = 5;
    public static final int MOUSE_EXITED = 6;
    public static final int MOUSE_MOVED = 7;
    protected String cursorColor = "transparent";
    protected boolean containsInteractive = false;
    protected int mouseAction = 0;
    protected MouseEvent mouseEvent = null;
    protected InteractiveMouseHandler interactive = null;
    private Interactive iaDraggable = null;
    private Selectable iaSelectable = null;
    Object customCursor;

    protected static void jsCustomCursor(String action, String cursorColor, MouseEvent e) {
        if (!OSPRuntime.cssCursor) {
            return;
        }
    }

    public InteractivePanel(InteractiveMouseHandler in) {
        this();
        this.interactive = in;
    }

    public InteractivePanel() {
        this.isInteractive = true;
        this.interactive = this;
    }

    @Override
    protected void setMouseListeners() {
        this.mouseController = new IADMouseController();
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addOptionController();
    }

    @Override
    public void addDrawable(Drawable drawable) {
        super.addDrawable(drawable);
        if (drawable.isInteractive()) {
            this.containsInteractive = true;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.containsInteractive = false;
    }

    @Override
    protected void scaleX(ArrayList<Drawable> tempList) {
        double tempmin = this.xminPreferred;
        double tempmax = this.xmaxPreferred;
        super.scaleX(tempList);
        if (this.autoscaleX && this.mouseAction == 3) {
            if (this.xminPreferred > tempmin) {
                this.xminPreferred = tempmin;
            }
            if (this.xmaxPreferred < tempmax) {
                this.xmaxPreferred = tempmax;
            }
        }
    }

    @Override
    protected void scaleY(ArrayList<Drawable> tempList) {
        double tempmin = this.yminPreferred;
        double tempmax = this.ymaxPreferred;
        super.scaleY(tempList);
        if (this.autoscaleY && this.mouseAction == 3) {
            if (this.yminPreferred > tempmin) {
                this.yminPreferred = tempmin;
            }
            if (this.ymaxPreferred < tempmax) {
                this.ymaxPreferred = tempmax;
            }
        }
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler handler) {
        this.interactive = handler;
    }

    @Override
    public void handleMouseAction(InteractivePanel panel, MouseEvent evt) {
        switch (panel.getMouseAction()) {
            case 4: {
                InteractivePanel.jsCustomCursor("released", "transparent", evt);
                Interactive clickedIA = this.getInteractive();
                if (panel.getMouseClickCount() < 2 || clickedIA == null || !(clickedIA instanceof Selectable)) {
                    return;
                }
                if (this.iaSelectable != null && this.iaSelectable != clickedIA) {
                    this.iaSelectable.setSelected(false);
                }
                this.iaSelectable = (Selectable)clickedIA;
                this.iaSelectable.toggleSelected();
                this.invalidateImage();
                if (this.getIgnoreRepaint()) break;
                panel.repaint();
                break;
            }
            case 3: {
                InteractivePanel.jsCustomCursor("dragged", this.cursorColor, evt);
                if (this.iaDraggable == null) {
                    return;
                }
                double x = panel.getMouseX();
                double y = panel.getMouseY();
                if (!this.autoscaleX && evt.getX() < 1 + this.leftGutter) {
                    x = panel.pixToX(1 + this.leftGutter);
                }
                if (!this.autoscaleX && evt.getX() > panel.getWidth() - 1 - this.rightGutter) {
                    x = panel.pixToX(panel.getWidth() - 1 - this.rightGutter);
                }
                if (!this.autoscaleY && evt.getY() < 1 + this.topGutter) {
                    y = panel.pixToY(1 + this.topGutter);
                }
                if (!this.autoscaleY && evt.getY() > panel.getHeight() - 1 - this.bottomGutter) {
                    y = panel.pixToY(panel.getHeight() - 1 - this.bottomGutter);
                }
                this.iaDraggable.setXY(x, y);
                this.invalidateImage();
                if (this.getIgnoreRepaint()) break;
                panel.repaint();
                break;
            }
            case 2: {
                InteractivePanel.jsCustomCursor("released", this.cursorColor, evt);
                if (!this.autoscaleX && !this.autoscaleY || this.getIgnoreRepaint()) break;
                panel.repaint();
            }
        }
    }

    public Interactive getCurrentDraggable() {
        return this.iaDraggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interactive getInteractive() {
        if (!this.containsInteractive) {
            return null;
        }
        if (this.iaDraggable != null) {
            return this.iaDraggable;
        }
        if (this.iaSelectable != null && this.iaSelectable.isSelected()) {
            return this.iaSelectable.findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
        }
        Interactive iad = null;
        ArrayList arrayList = this.drawableList;
        synchronized (arrayList) {
            int n;
            int x = this.mouseEvent.getX();
            int y = this.mouseEvent.getY();
            int i = n = this.drawableList.size();
            while (--i >= 0) {
                Drawable obj = (Drawable)this.drawableList.get(i);
                if (obj.isInteractive() && (iad = ((Interactive)obj).findInteractive(this, x, y)) != null) break;
            }
        }
        return iad;
    }

    @Override
    public void setShowCoordinates(boolean show) {
        this.showCoordinates = show;
    }

    public int getMouseButton() {
        switch (this.mouseEvent.getModifiers()) {
            case 16: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public int getMouseClickCount() {
        return this.mouseEvent.getClickCount();
    }

    public int getMouseAction() {
        return this.mouseAction;
    }

    public int getMouseIntX() {
        return this.mouseEvent.getX();
    }

    public int getMouseIntY() {
        return this.mouseEvent.getY();
    }

    public double getMouseX() {
        return this.pixToX(this.mouseEvent.getX());
    }

    public double getMouseY() {
        return this.pixToY(this.mouseEvent.getY());
    }

    public void saveMouseEvent(int type, MouseEvent evt) {
        this.mouseAction = type;
        this.mouseEvent = evt;
    }

    @Override
    public void dispose() {
        if (this.mouseController != null) {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
            this.mouseController = null;
        }
        if (this.optionController != null) {
            this.removeMouseListener(this.optionController);
            this.removeMouseMotionListener(this.optionController);
            this.optionController = null;
        }
        super.dispose();
    }

    protected class IADMouseController
    extends MouseInputAdapter {
        protected IADMouseController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 1;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
                InteractivePanel.this.iaDraggable = null;
                InteractivePanel.this.iaDraggable = InteractivePanel.this.getInteractive();
                if (InteractivePanel.this.iaDraggable != null) {
                    if (InteractivePanel.this.iaDraggable instanceof Selectable) {
                        InteractivePanel.this.setMouseCursor(((Selectable)InteractivePanel.this.iaDraggable).getPreferredCursor());
                        InteractivePanel.this.cursorColor = "rgba(63, 255, 63, 0.5)";
                    } else {
                        InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                        InteractivePanel.this.cursorColor = "rgba(63, 63, 255, 0.5)";
                    }
                } else {
                    InteractivePanel.this.cursorColor = "transparent";
                }
            }
            InteractivePanel.jsCustomCursor("pressed", InteractivePanel.this.cursorColor, e);
            if (InteractivePanel.this.isShowCoordinates()) {
                String s = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, e);
                InteractivePanel.this.setMessage(s, 0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            InteractivePanel.jsCustomCursor("released", InteractivePanel.this.cursorColor, e);
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 2;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
            InteractivePanel.this.iaDraggable = null;
            if (InteractivePanel.this.isShowCoordinates()) {
                InteractivePanel.this.setMessage(null, 0);
            }
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            InteractivePanel.jsCustomCursor("entered", InteractivePanel.this.cursorColor, e);
            if (InteractivePanel.this.isShowCoordinates()) {
                InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 5;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            InteractivePanel.this.cursorColor = "transparent";
            InteractivePanel.jsCustomCursor("exited", InteractivePanel.this.cursorColor, e);
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 6;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            InteractivePanel.jsCustomCursor("pressed", InteractivePanel.this.cursorColor, e);
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 4;
            if (InteractivePanel.this.interactive == null) {
                return;
            }
            InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            InteractivePanel.jsCustomCursor("dragged", InteractivePanel.this.cursorColor, e);
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 3;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
            if (InteractivePanel.this.isShowCoordinates()) {
                String s = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, e);
                InteractivePanel.this.setMessage(s, 0);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 7;
            InteractivePanel.this.iaDraggable = null;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
                Interactive iad = InteractivePanel.this.getInteractive();
                if (iad == null) {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
                    InteractivePanel.this.cursorColor = "transparent";
                } else if (iad instanceof Selectable) {
                    InteractivePanel.this.setMouseCursor(((Selectable)iad).getPreferredCursor());
                    InteractivePanel.this.cursorColor = "rgba(63, 255, 63, 0.5)";
                } else {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                    InteractivePanel.this.cursorColor = "rgba(63, 63, 255, 0.5)";
                }
            }
            InteractivePanel.jsCustomCursor("moved", InteractivePanel.this.cursorColor, e);
        }
    }
}

