/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GeneralPathLoader;
import org.opensourcephysics.display.InteractiveArrow;
import org.opensourcephysics.display.InteractiveCenteredArrow;
import org.opensourcephysics.display.InteractiveImage;
import org.opensourcephysics.display.InteractiveTextLine;
import org.opensourcephysics.display.Measurable;

public class InteractiveShape
extends AbstractInteractive
implements Measurable {
    public Color edgeColor = Color.red;
    protected Shape shape;
    protected String shapeClass;
    protected double theta;
    protected double width;
    protected double height;
    protected double xoff;
    protected double yoff;
    protected boolean pixelSized = false;
    protected AffineTransform toPixels = new AffineTransform();
    protected Point2D.Double pixelPt = new Point2D.Double();
    boolean enableMeasure = false;
    protected AffineTransform trIS = new AffineTransform();

    public InteractiveShape(Shape s, double _x, double _y) {
        this.color = new Color(255, 128, 128, 128);
        this.shape = s;
        this.x = _x;
        this.y = _y;
        if (this.shape == null) {
            return;
        }
        Rectangle2D bounds = this.shape.getBounds2D();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
        this.shapeClass = this.shape.getClass().getName();
        this.shape = this.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
    }

    public InteractiveShape(Shape s) {
        this(s, 0.0, 0.0);
    }

    public static InteractiveShape createEllipse(double x, double y, double w, double h) {
        Ellipse2D.Double shape = new Ellipse2D.Double(-w / 2.0, -h / 2.0, w, h);
        InteractiveShape is = new InteractiveShape(shape, x, y);
        is.width = w;
        is.height = h;
        return is;
    }

    public static InteractiveShape createCircle(double x, double y, double d) {
        return InteractiveShape.createEllipse(x, y, d, d);
    }

    public static InteractiveShape createRectangle(double x, double y, double w, double h) {
        Rectangle2D.Double shape = new Rectangle2D.Double(-w / 2.0, -h / 2.0, w, h);
        InteractiveShape is = new InteractiveShape(shape, x, y);
        is.width = w;
        is.height = h;
        return is;
    }

    public static InteractiveShape createTriangle(double x, double y, double b, double h) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(-b / 2.0), (float)(-h / 2.0));
        path.lineTo((float)(b / 2.0), (float)(-h / 2.0));
        path.lineTo(0.0f, (float)(h / 2.0));
        path.closePath();
        GeneralPath shape = path;
        InteractiveShape is = new InteractiveShape(shape, x, y);
        is.width = b;
        is.height = h;
        return is;
    }

    public static InteractiveShape createImage(Image image, double x, double y) {
        InteractiveImage is = new InteractiveImage(image, x, y);
        return is;
    }

    public static InteractiveShape createTextLine(double x, double y, String text) {
        InteractiveTextLine is = new InteractiveTextLine(text, x, y);
        return is;
    }

    public static InteractiveShape createArrow(double x, double y, double w, double h) {
        InteractiveArrow is = new InteractiveArrow(x, y, w, h);
        is.setHeightDrag(false);
        is.setWidthDrag(false);
        is.hideBounds = true;
        return is;
    }

    public static InteractiveShape createCenteredArrow(double x, double y, double w, double h) {
        InteractiveCenteredArrow is = new InteractiveCenteredArrow(x, y, w, h);
        is.setHeightDrag(false);
        is.setWidthDrag(false);
        is.hideBounds = true;
        return is;
    }

    public static InteractiveShape createSquare(double x, double y, double w) {
        Rectangle2D.Double shape = new Rectangle2D.Double(-w / 2.0, -w / 2.0, w, w);
        return new InteractiveShape(shape, x, y);
    }

    public void transform(AffineTransform transformation) {
        this.shape = transformation.createTransformedShape(this.shape);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        Shape temp;
        Graphics2D g2 = (Graphics2D)g;
        this.getPixelPt(panel);
        if (this.pixelSized) {
            this.trIS.setTransform(1.0, 0.0, 0.0, -1.0, -this.x + this.pixelPt.x + this.xoff, this.y + this.pixelPt.y - this.yoff);
            this.trIS.rotate(-this.theta, this.pixelPt.x, this.pixelPt.y);
            temp = this.trIS.createTransformedShape(this.shape);
        } else {
            temp = this.toPixels.createTransformedShape(this.shape);
        }
        g2.setPaint(this.color);
        g2.fill(temp);
        g2.setPaint(this.edgeColor);
        g2.draw(temp);
    }

    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void tranform(double[][] mat) {
        this.shape = new AffineTransform(mat[0][0], mat[1][0], mat[0][1], mat[1][1], mat[0][2], mat[1][2]).createTransformedShape(this.shape);
    }

    @Override
    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        return this.enabled && this.shape != null && this.shape.contains(panel.pixToX(xpix), panel.pixToY(ypix));
    }

    public void setMarkerColor(Color _fillColor, Color _edgeColor) {
        this.color = _fillColor;
        this.edgeColor = _edgeColor;
    }

    public void setTheta(double theta) {
        if (!this.pixelSized && theta != this.theta) {
            this.shape = this.getRotateInstance(theta - this.theta, this.x, this.y).createTransformedShape(this.shape);
        }
        this.theta = theta;
    }

    public void setPixelSized(boolean enable) {
        this.pixelSized = enable;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        double w = (width = Math.abs(width)) / this.width;
        if (w < 0.02 || w == 1.0) {
            return;
        }
        this.trIS.setToTranslation(this.x, this.y);
        if (this.pixelSized || this.theta == 0.0) {
            this.trIS.scale(w, 1.0);
        } else {
            this.trIS.rotate(this.theta);
            this.trIS.scale(w, 1.0);
            this.trIS.rotate(-this.theta);
        }
        this.trIS.translate(-this.x, -this.y);
        this.shape = this.trIS.createTransformedShape(this.shape);
        this.xoff *= w;
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        double h = (height = Math.abs(height)) / this.height;
        if (h < 0.02 || h == 1.0) {
            return;
        }
        this.trIS.setToTranslation(this.x, this.y);
        if (this.pixelSized || this.theta == 0.0) {
            this.trIS.scale(1.0, h);
        } else {
            this.trIS.rotate(this.theta);
            this.trIS.scale(1.0, h);
            this.trIS.rotate(-this.theta);
            this.trIS.translate(-this.x, -this.y);
        }
        this.yoff *= h;
        this.height = height;
    }

    public void setOffset(double xoffset, double yoffset) {
        if (!(this.pixelSized || xoffset == this.xoff && yoffset == this.yoff)) {
            this.shape = this.getTranslateInstance(this.x + xoffset, this.y + yoffset).createTransformedShape(this.shape);
        }
        this.xoff = xoffset;
        this.yoff = yoffset;
    }

    @Override
    public void setXY(double _x, double _y) {
        if (_x == this.x && _y == this.y) {
            return;
        }
        this.shape = this.getTranslateInstance(_x - this.x, _y - this.y).createTransformedShape(this.shape);
        this.x = _x;
        this.y = _y;
    }

    @Override
    public void setX(double _x) {
        if (this.x == _x) {
            return;
        }
        this.shape = this.getTranslateInstance(_x - this.x, 0.0).createTransformedShape(this.shape);
        this.x = _x;
    }

    @Override
    public void setY(double _y) {
        if (_y == this.y) {
            return;
        }
        this.shape = this.getTranslateInstance(0.0, _y - this.y).createTransformedShape(this.shape);
        this.y = _y;
    }

    public String toString() {
        return "InteractiveShape:\n \t shape=" + this.shapeClass + "\n \t x=" + this.x + "\n \t y=" + this.y + "\n \t width=" + this.width + "\n \t height=" + this.height + "\n \t theta=" + this.theta;
    }

    public void setMeasured(boolean _enableMeasure) {
        this.enableMeasure = _enableMeasure;
    }

    @Override
    public boolean isMeasured() {
        return this.enableMeasure;
    }

    @Override
    public double getXMin() {
        if (this.pixelSized) {
            return this.x - this.width / this.toPixels.getScaleX() / 2.0;
        }
        return this.shape.getBounds2D().getX();
    }

    @Override
    public double getXMax() {
        if (this.pixelSized) {
            return this.x + this.width / this.toPixels.getScaleX() / 2.0;
        }
        return this.shape.getBounds2D().getX() + this.shape.getBounds2D().getWidth();
    }

    @Override
    public double getYMin() {
        if (this.pixelSized) {
            return this.y - this.height / this.toPixels.getScaleY() / 2.0;
        }
        return this.shape.getBounds2D().getY();
    }

    @Override
    public double getYMax() {
        if (this.pixelSized) {
            return this.y + this.height / this.toPixels.getScaleY() / 2.0;
        }
        return this.shape.getBounds2D().getY() + this.shape.getBounds2D().getHeight();
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveShapeLoader();
    }

    protected void getPixelPt(DrawingPanel panel) {
        this.toPixels.setTransform(panel.getPixelTransform());
        this.pixelPt.setLocation(this.x, this.y);
        this.toPixels.transform(this.pixelPt, this.pixelPt);
    }

    protected AffineTransform getRotateInstance(double theta) {
        this.trIS.setToRotation(theta);
        return this.trIS;
    }

    protected AffineTransform getRotateInstance(double theta, double x, double y) {
        this.trIS.setToRotation(theta, x, y);
        return this.trIS;
    }

    protected AffineTransform getScaleInstance(double sx, double sy) {
        this.trIS.setToScale(sx, sy);
        return this.trIS;
    }

    protected AffineTransform getTranslateInstance(double tx, double ty) {
        this.trIS.setToTranslation(tx, ty);
        return this.trIS;
    }

    protected static class InteractiveShapeLoader
    extends XMLLoader {
        static {
            XML.setLoader(GeneralPath.class, new GeneralPathLoader());
        }

        protected InteractiveShapeLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            InteractiveShape interactiveShape = (InteractiveShape)obj;
            control.setValue("geometry", interactiveShape.shapeClass);
            control.setValue("x", interactiveShape.x);
            control.setValue("y", interactiveShape.y);
            control.setValue("width", interactiveShape.width);
            control.setValue("height", interactiveShape.height);
            control.setValue("x offset", interactiveShape.xoff);
            control.setValue("y offset", interactiveShape.yoff);
            control.setValue("theta", interactiveShape.theta);
            control.setValue("pixel sized", interactiveShape.pixelSized);
            control.setValue("is enabled", interactiveShape.isEnabled());
            control.setValue("is measured", interactiveShape.isMeasured());
            control.setValue("color", interactiveShape.color);
            Shape shape = AffineTransform.getRotateInstance(-interactiveShape.theta, interactiveShape.x, interactiveShape.y).createTransformedShape(interactiveShape.shape);
            control.setValue("general path", shape);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new InteractiveShape(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        }

        protected Shape getShape(String type, double x, double y, double w, double h) {
            if (type.equals(Ellipse2D.Double.class.getName())) {
                return new Ellipse2D.Double(x - w / 2.0, y - h / 2.0, w, h);
            }
            if (type.equals(Rectangle2D.Double.class.getName())) {
                return new Rectangle2D.Double(x - w / 2.0, y - h / 2.0, w, h);
            }
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            InteractiveShape interactiveShape = (InteractiveShape)obj;
            String type = control.getString("geometry");
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            double theta = control.getDouble("theta");
            Shape shape = this.getShape(type, x, y, control.getDouble("width"), control.getDouble("height"));
            interactiveShape.shape = shape == null ? (GeneralPath)control.getObject("general path") : shape;
            interactiveShape.width = control.getDouble("width");
            interactiveShape.height = control.getDouble("height");
            interactiveShape.xoff = control.getDouble("x offset");
            interactiveShape.yoff = control.getDouble("y offset");
            interactiveShape.x = x;
            interactiveShape.y = y;
            interactiveShape.setPixelSized(control.getBoolean("pixel sized"));
            interactiveShape.setEnabled(control.getBoolean("is enabled"));
            interactiveShape.setMeasured(control.getBoolean("is measured"));
            interactiveShape.color = (Color)control.getObject("color");
            interactiveShape.setTheta(theta);
            return obj;
        }
    }
}

