/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FontSizer;

public class MessageDrawable
implements Drawable {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    String tlStr = null;
    String trStr = null;
    String blStr = null;
    String brStr = null;
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 12;
    protected int fontstyle = 0;
    protected boolean ignoreRepaint = false;
    private JLabel[] labels;
    private ComponentListener listener;
    static int mcount;
    int index = ++mcount;
    String panelStr;

    public MessageDrawable() {
        this(null);
    }

    public MessageDrawable(DrawingPanel panel) {
        if (panel != null) {
            this.panelStr = panel.toString();
            this.labels = new JLabel[4];
            this.listener = new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    MessageDrawable.this.moveToView((DrawingPanel)e.getComponent());
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    MessageDrawable.this.moveToView((DrawingPanel)e.getComponent());
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            };
            panel.addComponentListener(this.listener);
        }
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
        FontSizer.addListener("level", e -> {
            if (e.getPropertyName().equals("level")) {
                int level = (Integer)e.getNewValue();
                this.setFontLevel(level);
            }
        });
    }

    public void setIgnoreRepaint(boolean ignore) {
        this.ignoreRepaint = ignore;
    }

    public void setMessageFont(Font aFont) {
        if (aFont != null) {
            this.font = aFont;
        }
    }

    protected void setFontLevel(int level) {
        this.font = FontSizer.getResizedFont(this.font, level);
    }

    public void setFontFactor(double factor) {
        this.font = FontSizer.getResizedFont(this.font, factor);
    }

    public void refreshGUI() {
        if (this.labels != null) {
            int i = 0;
            while (i < 4) {
                this.labels[i] = null;
                ++i;
            }
        }
    }

    public void setMessage(DrawingPanel panel, String msg, int location) {
        if (msg != null) {
            msg = msg.length() == 0 ? null : TeXParser.parseTeX(msg);
        }
        switch (location) {
            case 0: {
                this.blStr = msg;
                break;
            }
            case 1: {
                this.brStr = msg;
                break;
            }
            case 2: {
                this.trStr = msg;
                break;
            }
            case 3: {
                this.tlStr = msg;
            }
        }
        if (panel != null) {
            this.moveToView(panel);
        }
    }

    protected void moveToView(DrawingPanel panel) {
        Dimension d;
        Rectangle port = panel.findViewRect();
        JLabel l = this.getLabel(panel, 3, this.tlStr);
        if (l != null) {
            d = l.getPreferredSize();
            l.setBounds(port.x, port.y, d.width, d.height);
            l.setVisible(true);
        }
        if ((l = this.getLabel(panel, 2, this.trStr)) != null) {
            d = l.getPreferredSize();
            l.setBounds(port.x + port.width - d.width, port.y, d.width, d.height);
            l.setVisible(true);
        }
        if ((l = this.getLabel(panel, 0, this.blStr)) != null) {
            d = l.getPreferredSize();
            l.setBounds(port.x, port.y + port.height - d.height, d.width, d.height);
            l.setVisible(true);
            if (OSPRuntime.isJS) {
                l.setEnabled(false);
            }
        }
        if ((l = this.getLabel(panel, 1, this.brStr)) != null) {
            d = l.getPreferredSize();
            l.setBounds(port.x + port.width - d.width, port.y + port.height - d.height, d.width, d.height);
            l.setVisible(true);
        }
    }

    private JLabel getLabel(DrawingPanel panel, int location, String msg) {
        JLabel l = this.labels[location];
        if (l == null && msg != null) {
            l = this.labels[location] = new JLabel(msg);
            panel.add(l);
            l.setOpaque(true);
            l.setBackground(Color.yellow);
            l.setBorder(new EmptyBorder(0, 2, 0, 2));
            FontSizer.setFont(l);
        }
        if (msg != null) {
            if (l != null) {
                l.setText(msg);
            }
            return l;
        }
        if (l != null) {
            l.setVisible(false);
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        int y;
        int x;
        if (this.ignoreRepaint) {
            return;
        }
        Rectangle port = panel.findViewRect();
        g = g.create();
        Font oldFont = g.getFont();
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int vertOffset = fm.getDescent();
        int height = fm.getAscent() + 1 + vertOffset;
        int width = 0;
        g.setClip(0, 0, panel.getWidth(), panel.getHeight());
        if (this.tlStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.tlStr) + 6;
            x = port.x;
            y = port.y;
            g.fillRect(x, y, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, width, height);
            g.drawString(this.tlStr, x + 4, y + height - vertOffset);
        }
        if (this.trStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.trStr) + 8;
            x = port.x + port.width - width;
            y = port.y;
            g.fillRect(x - 1, y, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x - 1, y, width, height);
            g.drawString(this.trStr, x + 4, y + height - vertOffset);
        }
        if (this.blStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.blStr) + 14;
            x = port.x;
            y = port.y + port.height - height;
            g.fillRect(x, y - 1, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y - 1, width, height);
            g.drawString(this.blStr, x + 4, y + height - vertOffset - 1);
        }
        if (this.brStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.brStr) + 8;
            x = port.x + port.width - width;
            y = port.y + port.height - height;
            g.fillRect(x - 1, y - 1, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x - 1, y - 1, width, height);
            g.drawString(this.brStr, x + 4, y + height - vertOffset - 1);
        }
        g.setFont(oldFont);
        g.dispose();
    }

    public void drawOn3D(Component panel, Graphics g) {
        int y;
        int x;
        if (this.ignoreRepaint) {
            return;
        }
        Rectangle port = null;
        if (panel.getParent() instanceof JViewport) {
            port = ((JViewport)panel.getParent()).getViewRect();
        }
        g = g.create();
        Font oldFont = g.getFont();
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int vertOffset = fm.getDescent();
        int height = fm.getAscent() + 1 + vertOffset;
        int width = 0;
        g.setClip(0, 0, panel.getWidth(), panel.getHeight());
        if (this.tlStr != null && !this.tlStr.equals("")) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.tlStr) + 6;
            x = port == null ? 0 : port.x;
            y = port == null ? 0 : port.y;
            g.fillRect(x, y, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, width, height);
            g.drawString(this.tlStr, x + 4, y + height - vertOffset);
        }
        if (this.trStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.trStr) + 8;
            x = port == null ? panel.getWidth() - width : port.x + port.width - width;
            y = port == null ? 0 : port.y;
            g.fillRect(x - 1, y, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x - 1, y, width, height);
            g.drawString(this.trStr, x + 4, y + height - vertOffset);
        }
        if (this.blStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.blStr) + 6;
            x = port == null ? 0 : port.x;
            y = port == null ? panel.getHeight() - height : port.y + port.height - height;
            g.fillRect(x, y - 1, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y - 1, width, height);
            g.drawString(this.blStr, x + 4, y + height - vertOffset - 1);
        }
        if (this.brStr != null) {
            g.setColor(Color.YELLOW);
            width = fm.stringWidth(this.brStr) + 8;
            x = port == null ? panel.getWidth() - width : port.x + port.width - width;
            y = port == null ? panel.getHeight() - height : port.y + port.height - height;
            g.fillRect(x - 1, y - 1, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x - 1, y - 1, width, height);
            g.drawString(this.brStr, x + 4, y + height - vertOffset - 1);
        }
        g.setFont(oldFont);
        g.dispose();
    }

    public void dispose(DrawingPanel panel) {
        if (panel != null) {
            panel.removeComponentListener(this.listener);
        }
        this.listener = null;
        this.labels = null;
        this.font = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

