/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class OSPButton
extends JButton {
    private JComponent heightComponent;

    public OSPButton() {
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                OSPButton.this.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OSPButton.this.setBorderPainted(false);
            }
        });
    }

    public OSPButton(Action action) {
        this();
        this.setAction(action);
    }

    public OSPButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public OSPButton(Icon off, Icon on) {
        this();
        this.setIcon(off);
        this.setSelectedIcon(on);
    }

    public void setHeightComponent(JComponent comp) {
        this.heightComponent = comp;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.heightComponent != null) {
            dim.height = this.heightComponent.getPreferredSize().height;
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (this.heightComponent != null) {
            dim.height = this.heightComponent.getPreferredSize().height;
        }
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (this.heightComponent != null) {
            dim.height = this.heightComponent.getPreferredSize().height;
        }
        return dim;
    }
}

