/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.opensourcephysics.display.AppFrame;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class OSPFrame
extends JFrame
implements Hidable,
AppFrame {
    static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    protected ArrayList<JButton> customButtons = new ArrayList();
    static int topx = 10;
    static int topy = 100;
    protected boolean animated = false;
    protected boolean autoclear = false;
    private volatile boolean wishesToExit = false;
    public ThreadGroup constructorThreadGroup = Thread.currentThread().getThreadGroup();
    protected boolean keepHidden = false;
    protected BufferStrategy strategy;
    protected JPanel buttonPanel = new JPanel();
    protected Collection<JFrame> childFrames = new ArrayList<JFrame>();
    protected int myFontLevel;
    protected String action = null;
    private ComponentAdapter adapter = null;

    @Deprecated
    public static JFileChooser getChooser() {
        return OSPRuntime.getChooser();
    }

    public OSPFrame(String title) {
        super(TeXParser.parseTeX(title));
        if (OSPRuntime.appletMode) {
            this.keepHidden = true;
        }
        this.buttonPanel.setVisible(false);
        this.setLocation(topx, topy);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        topx = Math.min(topx + 20, (int)d.getWidth() - 100);
        topy = Math.min(topy + 20, (int)d.getHeight() - 100);
        this.setDefaultCloseOperation(1);
        FontSizer.addListener("level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                OSPFrame.this.setFontLevel(FontSizer.getLevel());
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                OSPFrame.this.refreshGUI();
            }
        });
        if (!OSPRuntime.isJS) {
            try {
                this.setIconImage(ResourceLoader.getImageIcon(OSP_ICON_FILE).getImage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OSPFrame.this.disposeChildWindows();
            }
        });
    }

    public void setResizeAction(String o) {
        if (o == null) {
            if (this.adapter != null) {
                this.removeComponentListener(this.adapter);
            }
            this.action = o;
            return;
        }
        if (o.equals(this.action)) {
            return;
        }
        this.removeComponentListener(this.adapter);
        this.action = o;
        this.adapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        };
        this.addComponentListener(this.adapter);
    }

    void disposeChildWindows() {
        for (JFrame f : this.childFrames) {
            if (!f.isDisplayable()) continue;
            if (f instanceof OSPFrame) {
                ((OSPFrame)f).setKeepHidden(true);
            } else {
                f.setVisible(false);
            }
            f.dispose();
        }
        this.childFrames.clear();
    }

    public OSPFrame() {
        this("Open Source Physics");
    }

    public OSPFrame(Container contentPane) {
        this();
        this.setContentPane(contentPane);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(TeXParser.parseTeX(title));
    }

    public void addChildFrame(JFrame frame) {
        if (frame == null || !frame.isDisplayable()) {
            return;
        }
        this.childFrames.add(frame);
    }

    public void clearChildFrames() {
        this.childFrames.clear();
    }

    public Collection<JFrame> getChildFrames() {
        return new ArrayList<JFrame>(this.childFrames);
    }

    public boolean isIconified() {
        return (this.getExtendedState() & 1) == 1;
    }

    public void invalidateImage() {
    }

    protected void setFontLevel(int level) {
        try {
            FontSizer.setFonts(this);
        }
        catch (Exception ex) {
            System.err.println("Err: OSPFrame line 220.");
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isAutoclear() {
        return this.autoclear;
    }

    public void setAutoclear(boolean autoclear) {
        this.autoclear = autoclear;
    }

    protected JMenu loadDisplayMenu() {
        return null;
    }

    protected JMenu loadToolsMenu() {
        return null;
    }

    public void clearData() {
    }

    public void clearDataAndRepaint() {
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    @Deprecated
    public void show() {
        if (!this.keepHidden) {
            super.show();
        }
    }

    @Override
    public void dispose() {
        this.keepHidden = true;
        this.clearData();
        this.disposeChildWindows();
        super.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.keepHidden) {
            boolean shouldRender = !this.isVisible() && this.animated;
            super.setVisible(b);
            if (shouldRender) {
                this.render();
            }
        }
    }

    @Override
    public void setKeepHidden(boolean _keepHidden) {
        this.keepHidden = _keepHidden;
        if (this.keepHidden) {
            super.setVisible(false);
        }
    }

    @Override
    public boolean isKeepHidden() {
        return this.keepHidden;
    }

    public ThreadGroup getConstructorThreadGroup() {
        return this.constructorThreadGroup;
    }

    public void createBufferStrategy() {
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
    }

    public void bufferStrategyShow() {
        if (this.strategy == null) {
            this.createBufferStrategy();
        }
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        Graphics g = this.strategy.getDrawGraphics();
        this.paintComponents(g);
        g.dispose();
        this.strategy.show();
    }

    public void render() {
    }

    public JMenu getMenu(String menuName) {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        menuName = menuName.trim();
        JMenu menu = null;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenu next = menuBar.getMenu(i);
            if (next.getText().trim().equals(menuName)) {
                menu = next;
                break;
            }
            ++i;
        }
        return menu;
    }

    public JMenu removeMenu(String menuName) {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        menuName = menuName.trim();
        JMenu menu = null;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenu next = menuBar.getMenu(i);
            if (next.getText().trim().equals(menuName)) {
                menu = next;
                menuBar.remove(i);
                break;
            }
            ++i;
        }
        return menu;
    }

    public JMenuItem removeMenuItem(String menuName, String itemName) {
        JMenu menu = this.getMenu(menuName);
        if (menu == null) {
            return null;
        }
        itemName = itemName.trim();
        JMenuItem item = null;
        int i = 0;
        while (i < menu.getItemCount()) {
            JMenuItem next = menu.getItem(i);
            if (next.getText().trim().equals(itemName)) {
                item = next;
                menu.remove(i);
                break;
            }
            ++i;
        }
        return item;
    }

    public void parseXMLMenu(String xmlMenu) {
        this.parseXMLMenu(xmlMenu, null);
    }

    public void parseXMLMenu(String xmlMenu, Class<?> type) {
        System.out.println("The parseXMLMenu method has been disabled to reduce the size OSP jar files.");
    }

    protected void refreshGUI() {
        for (TranslatableButton translatableButton : this.customButtons) {
            translatableButton.refreshGUI();
        }
        this.buttonPanel.validate();
    }

    public JButton addButton(String methodName, String text, String toolTipText, final Object target) {
        TranslatableButton b = new TranslatableButton(text, toolTipText, target);
        if (OSPRuntime.loadTranslatorTool) {
            text = OSPRuntime.getTranslator().getProperty(target.getClass(), "custom_button." + text, text);
            toolTipText = OSPRuntime.getTranslator().getProperty(target.getClass(), "custom_button." + toolTipText, toolTipText);
        }
        b.setText(text);
        b.setToolTipText(toolTipText);
        Class[] parameters = new Class[]{};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] args = new Object[]{};
                    try {
                        m.invoke(target, args);
                    }
                    catch (IllegalAccessException iae) {
                        System.err.println(iae);
                    }
                    catch (InvocationTargetException ite) {
                        System.err.println(ite);
                    }
                }
            });
            this.buttonPanel.setVisible(true);
            this.buttonPanel.add(b);
            this.validate();
            this.pack();
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("Error adding custom button " + text + ". The method " + methodName + "() does not exist.");
        }
        this.customButtons.add(b);
        return b;
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        if (operation == 3 && OSPRuntime.launchingInSingleVM) {
            operation = 2;
            this.wishesToExit = true;
        }
        try {
            super.setDefaultCloseOperation(operation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean wishesToExit() {
        return this.wishesToExit;
    }

    class TranslatableButton
    extends JButton {
        String text;
        String tip;
        Object target;

        public TranslatableButton(String text, String tip, Object target) {
            this.text = text;
            this.tip = tip;
            this.target = target;
        }

        void refreshGUI() {
            if (OSPRuntime.loadTranslatorTool) {
                this.setText(OSPRuntime.getTranslator().getProperty(this.target.getClass(), "custom_button." + this.text, this.text));
                this.setToolTipText(OSPRuntime.getTranslator().getProperty(this.target.getClass(), "custom_button." + this.tip, this.tip));
            }
        }
    }
}

