/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javajs.async.Assets;
import javajs.async.AsyncFileChooser;
import javajs.async.SwingJSUtils;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.ostermiller.Browser;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Translator;
import org.opensourcephysics.tools.TranslatorTool;
import swingjs.api.JSUtilI;

public class OSPRuntime {
    public static final String VERSION = "6.3.3";
    public static final String RELEASE_DATE = "27 Oct 2025";
    public static final String OSP_PROPERTY_LOCALE = "locale";
    private static boolean isMac;
    public static int macOffset;
    public static boolean isJS;
    public static boolean cssCursor;
    public static boolean hasKeyboard;
    private static String userAgent;
    private static boolean skipDisplayOfPDF;
    public static JSUtilI jsutil;
    public static final char DECIMAL_SEPARATOR_COMMA = ',';
    public static final char DECIMAL_SEPARATOR_PERIOD = '.';
    public static boolean isApplet;
    public static boolean isBHTest;
    public static boolean dontLog;
    public static boolean allowBackgroundNodeLoading;
    public static boolean allowAutopaste;
    public static boolean allowDatasetClip;
    public static boolean allowLibClipboardPasteCheck;
    public static boolean allowSetFonts;
    public static boolean allowAsyncURL;
    public static boolean loadTranslatorTool;
    public static boolean autoAddLibrary;
    public static final boolean checkImages = false;
    public static boolean checkTempDirCache;
    public static boolean checkZipLoaders;
    public static boolean doCacheThumbnail;
    public static boolean doCacheLibaryRecord;
    public static boolean doCacheZipContents;
    public static boolean doScrollToPath;
    public static boolean drawDontFillAxes;
    public static boolean logToJ2SMonitor;
    public static boolean resCacheEnabled;
    public static boolean setRenderingHints;
    public static boolean embedVideoAsObject;
    public static boolean useZipAssets;
    public static boolean unzipFiles;
    public static final String tempDir;
    private static AsyncFileChooser chooser;
    public static final int WEB_CONNECTED_TEST_JAVA_TIMEOUT_MS = 1000;
    public static final int WEB_CONNECTED_TEST_JS_TIMEOUT_MS = 1000;
    public static final String WEB_CONNECTED_TEST_URL = "https://opensourcephysics.github.io/tracker-website/css/library.css";
    public static volatile boolean disableAllDrawing;
    public static boolean loadVideoTool;
    public static boolean loadExportTool;
    public static boolean loadDataTool;
    public static boolean loadOSPLog;
    private static DecimalFormatSymbols dfs;
    public static Locale[] defaultLocales;
    protected static boolean launcherMode;
    public static boolean antiAliasText;
    public static boolean appletMode;
    public static JApplet applet;
    public static boolean webStart;
    protected static boolean authorMode;
    private static String launchJarPath;
    private static String launchJarName;
    private static JarFile launchJar;
    private static String buildDate;
    private static char defaultDecimalSeparator;
    private static String preferredDecimalSeparator;
    public static final char MINUS = '\u2212';
    public static String chooserDir;
    public static String userhomeDir;
    public static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    public static boolean launchingInSingleVM;
    public static final String CROSS_PLATFORM_LF = "CROSS_PLATFORM";
    public static final String NIMBUS_LF = "NIMBUS";
    public static final String SYSTEM_LF = "SYSTEM";
    public static final String METAL_LF = "METAL";
    public static final String GTK_LF = "GTK";
    public static final String MOTIF_LF = "MOTIF";
    public static final String WINDOWS_LF = "WINDOWS";
    public static final String DEFAULT_LF = "DEFAULT";
    public static final LookAndFeel DEFAULT_LOOK_AND_FEEL;
    public static final boolean DEFAULT_LOOK_AND_FEEL_DECORATIONS;
    public static final HashMap<String, String> LOOK_AND_FEEL_TYPES;
    public static final String PROPERTY_ERROR_OUTOFMEMORY = "error";
    private static XMLControl prefsControl;
    private static String prefsPath;
    private static String prefsFileName;
    public static FontRenderContext frc;
    public static LaunchNode activeNode;
    private static char currentDecimalSeparator;
    public static boolean launcherAllowEJSModel;
    public static final Integer OUT_OF_MEMORY_ERROR;
    public static boolean outOfMemory;

    static {
        isJS = false;
        cssCursor = false;
        hasKeyboard = !cssCursor;
        userAgent = "";
        skipDisplayOfPDF = false;
        try {
            isMac = System.getProperty("os.name", "").toLowerCase().startsWith("mac");
            macOffset = isMac && !isJS ? 16 : 0;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (isJS) {
                jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
                jsutil.addDirectDatabaseCall(".");
            }
        }
        catch (Exception e) {
            OSPLog.warning("OSPRuntime could not create jsutil");
        }
        isApplet = false;
        isBHTest = isJS;
        dontLog = isJS;
        allowBackgroundNodeLoading = false;
        allowAutopaste = !isJS;
        allowDatasetClip = OSPRuntime.getBrowserName() != "Mozilla Firefox";
        allowLibClipboardPasteCheck = !isJS;
        allowSetFonts = true;
        allowAsyncURL = isJS;
        loadTranslatorTool = !isJS;
        autoAddLibrary = !isJS;
        checkTempDirCache = isJS;
        checkZipLoaders = !isJS;
        doCacheThumbnail = !isJS;
        doCacheLibaryRecord = !isJS;
        doCacheZipContents = true;
        doScrollToPath = false;
        drawDontFillAxes = true;
        logToJ2SMonitor = isJS;
        resCacheEnabled = isJS;
        setRenderingHints = !isJS && !isMac;
        embedVideoAsObject = isJS;
        useZipAssets = isJS;
        unzipFiles = !isJS;
        OSPRuntime.addAssets("osp", "osp-assets.zip", "org/opensourcephysics/resources");
        if (!isJS && !unzipFiles) {
            OSPLog.warning("OSPRuntime.unzipFiles setting is false for BH testing");
        }
        if (skipDisplayOfPDF) {
            OSPLog.warning("OSPRuntime.skipDisplayOfPDF true for BH testing");
        }
        tempDir = System.getProperty("java.io.tmpdir");
        disableAllDrawing = false;
        loadVideoTool = true;
        loadExportTool = true;
        loadDataTool = true;
        loadOSPLog = true;
        dfs = new DecimalFormatSymbols();
        defaultLocales = new Locale[]{Locale.ENGLISH, new Locale("es"), new Locale("de"), new Locale("da"), new Locale("sk"), Locale.TAIWAN};
        launcherMode = false;
        antiAliasText = false;
        authorMode = true;
        launchJar = null;
        preferredDecimalSeparator = null;
        DEFAULT_LOOK_AND_FEEL = UIManager.getLookAndFeel();
        DEFAULT_LOOK_AND_FEEL_DECORATIONS = JFrame.isDefaultLookAndFeelDecorated();
        LOOK_AND_FEEL_TYPES = new HashMap();
        prefsFileName = "osp.prefs";
        try {
            chooserDir = System.getProperty("user.dir", null);
            String userhome = OSPRuntime.getUserHome();
            if (userhome != null) {
                userhomeDir = XML.forwardSlash(userhome);
            }
        }
        catch (Exception ex) {
            chooserDir = null;
        }
        LOOK_AND_FEEL_TYPES.put(METAL_LF, "javax.swing.plaf.metal.MetalLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(NIMBUS_LF, "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(GTK_LF, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(MOTIF_LF, "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(WINDOWS_LF, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(CROSS_PLATFORM_LF, UIManager.getCrossPlatformLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(SYSTEM_LF, UIManager.getSystemLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(DEFAULT_LF, DEFAULT_LOOK_AND_FEEL.getClass().getName());
        NumberFormat format = NumberFormat.getInstance(Locale.getDefault());
        if (format instanceof DecimalFormat) {
            OSPRuntime.setDefaultDecimalSeparator(((DecimalFormat)format).getDecimalFormatSymbols().getDecimalSeparator());
        } else {
            OSPRuntime.setDefaultDecimalSeparator(Util.newDecimalFormat("0").getDecimalFormatSymbols().getDecimalSeparator());
        }
        frc = new FontRenderContext(null, false, false);
        launcherAllowEJSModel = true;
        OUT_OF_MEMORY_ERROR = 1;
        outOfMemory = false;
    }

    private static void readMobileParam() {
    }

    public static boolean getSkipDisplayOfPDF() {
        if (isJS) {
            OSPRuntime.readMobileParam();
        }
        return skipDisplayOfPDF;
    }

    public static String getUserAgent() {
        if (isJS) {
            OSPRuntime.readMobileParam();
        }
        return userAgent;
    }

    public static String getBrowserName() {
        String sUsrAg = "";
        String sBrowser = sUsrAg.indexOf("Firefox") > -1 ? "Mozilla Firefox" : (sUsrAg.indexOf("SamsungBrowser") > -1 ? "Samsung Internet" : (sUsrAg.indexOf("Opera") > -1 || sUsrAg.indexOf("OPR") > -1 ? "Opera" : (sUsrAg.indexOf("Trident") > -1 ? "Microsoft Internet Explorer" : (sUsrAg.indexOf("Edge") > -1 ? "Microsoft Edge" : (sUsrAg.indexOf("Chrome") > -1 ? "Google Chrome or Chromium" : (sUsrAg.indexOf("Safari") > -1 ? "Apple Safari" : "unknown"))))));
        return sBrowser;
    }

    public static void setApplet(JApplet a) {
        applet = a;
        isApplet = true;
    }

    private OSPRuntime() {
    }

    public static String getUserHome() {
        String homeEnv;
        String home = System.getProperty("user.home");
        if (OSPRuntime.isLinux() && (homeEnv = System.getenv("HOME")) != null) {
            home = homeEnv;
        }
        return home == null ? "." : home;
    }

    public static File getDownloadDir() {
        String xdgDir;
        String xdgText;
        String home = OSPRuntime.getUserHome();
        File downloadDir = new File(String.valueOf(home) + "/Downloads");
        if (OSPRuntime.isLinux() && (xdgText = ResourceLoader.getString(xdgDir = String.valueOf(home) + "/.config/user-dirs.dirs")) != null) {
            String[] split;
            String[] stringArray = split = xdgText.split("XDG_");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String next = stringArray[n2];
                if (next.contains("DOWNLOAD_DIR") && (n3 = next.indexOf("\"")) > -1 && (n3 = (next = next.substring(n3 + 1)).indexOf("\"")) > -1) {
                    File f;
                    if ((next = next.substring(0, n3)).startsWith("$HOME")) {
                        next = String.valueOf(home) + next.substring(5);
                    }
                    if ((f = new File(next)).exists()) {
                        downloadDir = f;
                    }
                }
                ++n2;
            }
        }
        return downloadDir;
    }

    public static void showAboutDialog(Component parent) {
        String date = OSPRuntime.getLaunchJarBuildDate();
        if ("".equals(date)) {
            date = RELEASE_DATE;
        }
        String vers = "OSP Library 6.3.3";
        if (date != null) {
            vers = String.valueOf(vers) + "\njar manifest date " + date;
        }
        if (isJS) {
            vers = String.valueOf(vers) + "\n\nJavaScript transcription created using the\njava2script/SwingJS framework developed at\n St. Olaf College.\n";
        }
        String aboutString = String.valueOf(vers) + "\n" + "Open Source Physics Project \n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(parent, aboutString, "About Open Source Physics", 1);
    }

    public static boolean setLookAndFeel(boolean useDefaultLnFDecorations, String lookAndFeel) {
        boolean found = true;
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        try {
            if (lookAndFeel == null || lookAndFeel.equals(DEFAULT_LF)) {
                UIManager.setLookAndFeel(DEFAULT_LOOK_AND_FEEL);
                useDefaultLnFDecorations = DEFAULT_LOOK_AND_FEEL_DECORATIONS;
            } else if (lookAndFeel.equals(CROSS_PLATFORM_LF)) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            } else if (lookAndFeel.equals(SYSTEM_LF)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            } else if (lookAndFeel.equals(NIMBUS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            } else if (lookAndFeel.equals(METAL_LF)) {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            } else if (lookAndFeel.equals(GTK_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (lookAndFeel.equals(MOTIF_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals(WINDOWS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            JFrame.setDefaultLookAndFeelDecorated(useDefaultLnFDecorations);
            JDialog.setDefaultLookAndFeelDecorated(useDefaultLnFDecorations);
        }
        catch (Exception ex) {
            found = false;
        }
        if (!found) {
            try {
                UIManager.setLookAndFeel(currentLookAndFeel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return found;
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        return JFrame.isDefaultLookAndFeelDecorated();
    }

    public static boolean isWindows() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isLinux() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("linux");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isVista() {
        return System.getProperty("os.name", "").toLowerCase().indexOf("vista") > -1;
    }

    public static boolean hasJava3D() {
        return false;
    }

    public static boolean isPopupTrigger(InputEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (me.isShiftDown()) {
                return false;
            }
            return me.isPopupTrigger() || me.getButton() == 3 || me.isControlDown() && isMac;
        }
        return false;
    }

    public static boolean isWebStart() {
        if (!webStart) {
            try {
                webStart = System.getProperty("javawebstart.version") != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webStart;
    }

    public static boolean isAppletMode() {
        return appletMode;
    }

    public static boolean isAuthorMode() {
        return authorMode;
    }

    public static void setAuthorMode(boolean b) {
        authorMode = b;
    }

    public static void setLauncherMode(boolean b) {
        launcherMode = b;
    }

    public static boolean isLauncherMode() {
        return launcherMode || "true".equals(System.getProperty("org.osp.launcher"));
    }

    public static void setLaunchJarPath(String path) {
        if (path == null || launchJarPath != null) {
            return;
        }
        if (!path.endsWith(".jar") && !path.endsWith(".exe")) {
            int n = path.indexOf(".jar!");
            if (n == -1) {
                n = path.indexOf(".exe!");
            }
            if (n > -1) {
                path = path.substring(0, n + 4);
            } else {
                return;
            }
        }
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length());
        }
        if (path.startsWith("file:/") && (path = path.substring(5, path.length())).contains(":")) {
            path = path.substring(1, path.length());
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return;
            }
            path = XML.forwardSlash(file.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        OSPLog.finer("Setting launch jar path to " + path);
        launchJarPath = path;
        launchJarName = path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getLaunchJarName() {
        return launchJarName;
    }

    public static String getLaunchJarPath() {
        return launchJarPath;
    }

    public static String getDocbase() {
        String base = "";
        if (!isJS) {
            return null;
        }
        int last = base.lastIndexOf(47);
        if (last < 1) {
            return base;
        }
        base = base.substring(0, last + 1);
        return base;
    }

    public static String getLaunchJarDirectory() {
        if (isApplet) {
            return null;
        }
        return launchJarPath == null ? null : XML.getDirectoryPath(launchJarPath);
    }

    public static JarFile getLaunchJar() {
        if (launchJar != null) {
            return launchJar;
        }
        if (launchJarPath == null) {
            return null;
        }
        boolean isWebFile = ResourceLoader.isHTTP(launchJarPath);
        if (!isWebFile) {
            launchJarPath = ResourceLoader.getNonURIPath(launchJarPath);
        }
        try {
            if (!isApplet && !isWebFile) {
                launchJar = new JarFile(launchJarPath);
            } else {
                URL url = isWebFile ? new URL("jar:" + launchJarPath + "!/") : new URL("jar:file:/" + launchJarPath + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                launchJar = conn.getJarFile();
            }
        }
        catch (Exception ex) {
            OSPLog.fine(ex.getMessage());
        }
        return launchJar;
    }

    public static String getManifestAttribute(JarFile jarFile, String attribute) {
        if (isJS) {
            System.err.println("getManifestAttribute from jar not allowed in JavaScript");
            return "";
        }
        try {
            Attributes att = jarFile.getManifest().getMainAttributes();
            return att.getValue(attribute);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getLaunchJarBuildDate() {
        if (isJS) {
            try {
                BufferedReader inFile = new BufferedReader(new FileReader("MANIFEST.MF"));
                String nextLine = inFile.readLine();
                while (nextLine != null) {
                    if (nextLine.startsWith("Build-Date:")) {
                        String date = nextLine.substring(11);
                        inFile.close();
                        return date;
                    }
                    nextLine = inFile.readLine();
                }
                inFile.close();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
            return "";
        }
        if (buildDate == null) {
            JarFile jarfile = OSPRuntime.getLaunchJar();
            buildDate = OSPRuntime.getManifestAttribute(jarfile, "Build-Date");
        }
        return buildDate;
    }

    public static File getJavaFile(String jrePath) {
        if (jrePath == null) {
            return null;
        }
        File file = new File(jrePath);
        if ((jrePath = XML.forwardSlash(jrePath)).endsWith("/lib/ext")) {
            jrePath = jrePath.substring(0, jrePath.length() - 8);
            file = new File(jrePath);
        }
        if (!jrePath.endsWith("/bin/java") && !jrePath.endsWith("/bin/java.exe")) {
            if (jrePath.endsWith("/bin")) {
                file = file.getParentFile();
            }
            if (OSPRuntime.isWindows()) {
                File jreFile;
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jre") > -1) {
                    file = file.getParentFile();
                }
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jdk") > -1) {
                    file = file.getParentFile();
                }
                file = file.getName().indexOf("jdk") > -1 ? ((jreFile = new File(file, "jre/bin/java.exe")).exists() ? jreFile : new File(file, "bin/java.exe")) : (file.getName().indexOf("jre") > -1 ? new File(file, "bin/java.exe") : null);
            } else if (isMac) {
                if (file.getName().endsWith("jdk")) {
                    File parent = file;
                    if (!(file = new File(parent, "Contents/Home/jre/bin/java")).exists()) {
                        file = new File(parent, "Contents/Home/bin/java");
                    }
                } else {
                    file = new File(file, "bin/java");
                }
            } else if (OSPRuntime.isLinux()) {
                if ("jre".equals(file.getName())) {
                    file = new File(file, "bin/java");
                } else {
                    if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jre") > -1) {
                        file = file.getParentFile();
                    }
                    if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jdk") > -1) {
                        file = file.getParentFile();
                    }
                    if (file.getParentFile() != null && file.getParentFile().getName().indexOf("sun") > -1) {
                        file = file.getParentFile();
                    }
                    file = file.getName().indexOf("jdk") > -1 || file.getName().indexOf("sun") > -1 ? new File(file, "jre/bin/java") : null;
                }
            }
        }
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static int getMajorVersion() {
        String[] v = VERSION.trim().split("\\.");
        try {
            return Integer.parseInt(v[0]);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int getVMBitness() {
        String s = System.getProperty("java.vm.name");
        s = String.valueOf(s) + "-" + System.getProperty("os.arch");
        return (s = String.valueOf(s) + "-" + System.getProperty("sun.arch.data.model")).indexOf("64") > -1 ? 64 : 32;
    }

    public static String getJREPath(File javaFile) {
        if (javaFile == null) {
            return null;
        }
        String javaPath = XML.forwardSlash(javaFile.getAbsolutePath());
        if (XML.stripExtension(javaPath).endsWith("/bin/java")) {
            return javaFile.getParentFile().getParent();
        }
        return "";
    }

    public static Locale[] getDefaultLocales() {
        return defaultLocales;
    }

    public static Locale[] getInstalledLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        if (isJS) {
            return list.toArray(new Locale[0]);
        }
        TreeMap<String, Locale> languages = new TreeMap<String, Locale>();
        list.add(Locale.ENGLISH);
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jar = OSPRuntime.getLaunchJar();
            if (jar != null) {
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    Locale next;
                    int m;
                    JarEntry entry = e.nextElement();
                    String path = entry.toString();
                    int n = path.indexOf(".properties");
                    if (path.indexOf(".properties") <= -1 || (m = path.indexOf("display_res_")) <= -1) continue;
                    String loc = path.substring(m + 12, n);
                    if (loc.equals("zh_TW")) {
                        next = Locale.TAIWAN;
                        languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                        continue;
                    }
                    if (loc.equals("zh_CN")) {
                        next = Locale.CHINA;
                        languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                        continue;
                    }
                    if (loc.equals("en_US")) continue;
                    if (!loc.contains("_")) {
                        next = new Locale(loc);
                    } else {
                        String lang = loc.substring(0, 2);
                        String country = loc.substring(3);
                        next = new Locale(lang, country, "");
                    }
                    if (next.equals(Locale.ENGLISH)) continue;
                    languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                }
                for (String s : languages.keySet()) {
                    list.add((Locale)languages.get(s));
                }
            } else {
                defaultLocales = new Locale[]{Locale.ENGLISH};
                return defaultLocales;
            }
        }
        return list.toArray(new Locale[0]);
    }

    public static String getDisplayLanguage(Locale locale) {
        if (locale.equals(Locale.CHINA)) {
            return "\u7b80\u4f53\u4e2d\u6587";
        }
        if (locale.equals(Locale.TAIWAN)) {
            return "\u7e41\u4f53\u4e2d\u6587";
        }
        return locale.getDisplayLanguage(locale);
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return dfs;
    }

    public static void setDefaultDecimalSeparator(char c) {
        defaultDecimalSeparator = c == '.' || c == ',' ? c : (char)46;
        if (preferredDecimalSeparator == null) {
            currentDecimalSeparator = defaultDecimalSeparator;
            dfs.setDecimalSeparator(currentDecimalSeparator);
        }
    }

    public static void setPreferredDecimalSeparator(String separator) {
        if (separator != null && separator.charAt(0) != '.' && separator.charAt(0) != ',') {
            separator = null;
        }
        preferredDecimalSeparator = separator;
        currentDecimalSeparator = separator == null ? defaultDecimalSeparator : separator.charAt(0);
        dfs.setDecimalSeparator(currentDecimalSeparator);
    }

    public static char getCurrentDecimalSeparator() {
        return currentDecimalSeparator;
    }

    public static String getPreferredDecimalSeparator() {
        return preferredDecimalSeparator;
    }

    public static ArrayList<String> getDefaultSearchPaths() {
        String codebase;
        File dir;
        ArrayList<String> paths = new ArrayList<String>();
        if (OSPRuntime.isWindows()) {
            String appdata = System.getenv("LOCALAPPDATA");
            if (appdata != null) {
                File dir2 = new File(appdata, "OSP");
                if (!dir2.exists()) {
                    dir2.mkdir();
                }
                if (dir2.exists()) {
                    paths.add(XML.forwardSlash(dir2.getAbsolutePath()));
                }
            }
        } else if (userhomeDir != null && isMac) {
            dir = new File(userhomeDir, "Library/Application Support");
            if (dir.exists()) {
                if (!(dir = new File(dir, "OSP")).exists()) {
                    dir.mkdir();
                }
                if (dir.exists()) {
                    paths.add(XML.forwardSlash(dir.getAbsolutePath()));
                }
            }
        } else if (userhomeDir != null && OSPRuntime.isLinux() && (dir = new File(userhomeDir, ".config")).exists()) {
            if (!(dir = new File(dir, "OSP")).exists()) {
                dir.mkdir();
            }
            if (dir.exists()) {
                paths.add(XML.forwardSlash(dir.getAbsolutePath()));
            }
        }
        if (userhomeDir != null) {
            paths.add(userhomeDir);
        }
        if ((codebase = OSPRuntime.getLaunchJarDirectory()) != null) {
            paths.add(XML.forwardSlash(codebase));
        }
        return paths;
    }

    public static Object getPreference(String name) {
        XMLControl control = OSPRuntime.getPrefsControl();
        return control.getObject(name);
    }

    public static void setPreference(String name, Object pref) {
        XMLControl control = OSPRuntime.getPrefsControl();
        control.setValue(name, pref);
    }

    public static void savePreferences() {
        XMLControl control = OSPRuntime.getPrefsControl();
        File file = new File(prefsPath, prefsFileName);
        control.write(file.getAbsolutePath());
    }

    public static File getPreferencesFile() {
        OSPRuntime.getPrefsControl();
        File file = new File(prefsPath, prefsFileName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static XMLControl getPrefsControl() {
        if (prefsControl == null) {
            ArrayList<String> dirs = OSPRuntime.getDefaultSearchPaths();
            for (String dir : dirs) {
                XMLControlElement test;
                File file = new File(dir, prefsFileName);
                if (!file.exists() && (file = new File(dir, "." + prefsFileName)).exists()) {
                    prefsFileName = "." + prefsFileName;
                }
                if (!file.exists() || (test = new XMLControlElement(file)).failedToRead()) continue;
                prefsControl = test;
                prefsPath = XML.forwardSlash(dir);
                break;
            }
            if (prefsControl == null) {
                prefsControl = new XMLControlElement();
                prefsPath = XML.forwardSlash(dirs.get(0));
                if (prefsPath.equals(userhomeDir)) {
                    prefsFileName = "." + prefsFileName;
                }
                File file = new File(prefsPath, prefsFileName);
                if (!isJS) {
                    prefsControl.write(file.getAbsolutePath());
                }
            }
        }
        return prefsControl;
    }

    public static Translator getTranslator() {
        return loadTranslatorTool ? TranslatorTool.getTool() : null;
    }

    public static AsyncFileChooser getChooser() {
        if (chooser != null) {
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            return chooser;
        }
        try {
            chooser = chooserDir == null ? new AsyncFileChooser() : new AsyncFileChooser(new File(chooserDir));
        }
        catch (Exception e) {
            System.err.println("Exception in OSPFrame getChooser=" + e);
            return null;
        }
        FileFilter defaultFilter = chooser.getFileFilter();
        FileFilter xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xml");
            }

            @Override
            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.XML");
            }
        };
        FileFilter txtFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("txt");
            }

            @Override
            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.TXT");
            }
        };
        chooser.addChoosableFileFilter(xmlFilter);
        chooser.addChoosableFileFilter(txtFilter);
        chooser.setFileFilter(defaultFilter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public static String chooseFilename(JFileChooser chooser) {
        return OSPRuntime.chooseFilename(chooser, null, true);
    }

    public static String chooseFilename(JFileChooser chooser, Component parent, boolean toSave) {
        String fileName = null;
        int result = toSave ? chooser.showSaveDialog(parent) : chooser.showOpenDialog(parent);
        if (result == 0) {
            chooserDir = chooser.getCurrentDirectory().toString();
            File file = chooser.getSelectedFile();
            if (toSave) {
                int selected;
                if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                    return null;
                }
            } else if (!file.exists()) {
                JOptionPane.showMessageDialog(parent, String.valueOf(DisplayRes.getString("GUIUtils.FileDoesntExist")) + " " + file.getName(), DisplayRes.getString("GUIUtils.FileChooserError"), 0);
                return null;
            }
            if ((fileName = file.getAbsolutePath()) == null || fileName.trim().equals("")) {
                return null;
            }
        }
        return fileName;
    }

    public static AsyncFileChooser createChooser(String title, String description, String[] extensions) {
        AsyncFileChooser chooser = OSPRuntime.createChooser(description, extensions, null);
        chooser.setDialogTitle(title);
        return chooser;
    }

    public static AsyncFileChooser createChooser(String description, String[] extensions) {
        return OSPRuntime.createChooser(description, extensions, null);
    }

    public static AsyncFileChooser createChooser(String description, String[] extensions, final File homeDir) {
        AsyncFileChooser chooser = new AsyncFileChooser(new File(chooserDir));
        ExtensionFileFilter filter = new ExtensionFileFilter();
        int i = 0;
        while (i < extensions.length) {
            filter.addExtension(extensions[i]);
            ++i;
        }
        filter.setDescription(description);
        if (homeDir != null) {
            chooser.setFileSystemView(new FileSystemView(){

                @Override
                public File createNewFolder(File arg0) throws IOException {
                    return FileSystemView.getFileSystemView().createNewFolder(arg0);
                }

                @Override
                public File getHomeDirectory() {
                    return homeDir;
                }
            });
        }
        chooser.setFileFilter(filter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public static void cacheJSFile(File file, boolean isAdd) {
        if (isJS) {
            jsutil.cachePathData(file.getAbsolutePath(), isAdd ? jsutil.getBytes(file) : null);
        }
    }

    public static byte[] getCachedBytes(String path) {
        return isJS ? jsutil.getCachedBytes(path) : null;
    }

    public static byte[] addJSCachedBytes(Object URLorURIorFile) {
        return isJS ? jsutil.addJSCachedBytes(URLorURIorFile) : null;
    }

    public static boolean isJSTemp(String path) {
        return isJS && path.startsWith("/TEMP/");
    }

    public static void displayURL(String url) throws IOException {
        if (isJS) {
            jsutil.displayURL(url, "_blank");
        } else {
            Browser.init();
            url = url.replaceAll("\\s+", "");
            Browser.displayURL(url);
        }
    }

    public static void showStatus(String msg) {
        if (isJS && logToJ2SMonitor) {
            jsutil.showStatus(msg, true);
        }
    }

    public static void getURLBytesAsync(URL url, Function<byte[], Void> whenDone) {
        if (allowAsyncURL) {
            jsutil.getURLBytesAsync(url, whenDone);
        } else {
            whenDone.apply(jsutil.getURLBytes(url));
        }
    }

    @Deprecated
    public static void postEvent(Runnable runner) {
        if (isJS || SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public static void dispatchEventWait(Runnable runner) {
        if (isJS || SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setAppClass(Object j) {
        if (isJS) {
            jsutil.setAppletAttribute("app", j);
        }
    }

    public static int setTimeout(String name, int msDelay, boolean cancelPending, Runnable r) {
        return SwingJSUtils.Timeout.setTimeout(name, msDelay, cancelPending, r);
    }

    public static void exit() {
        SwingJSUtils.Timeout.cancelTimeoutsByName(null);
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void setOSPAction(InputMap im, KeyStroke ks, String actionKey, ActionMap am, Action pasteAction) {
        Object key = im.get(ks);
        if (key == null) {
            key = actionKey;
            im.put(ks, key);
        }
        am.put(key, pasteAction);
    }

    public static String paste(Consumer<String> whenDone) {
        if (isJS) {
            if (whenDone != null) {
                jsutil.getClipboardText(whenDone);
            }
            return null;
        }
        Transferable data = null;
        try {
            Clipboard clipboard = OSPRuntime.getClipboard();
            data = clipboard.getContents(null);
        }
        catch (Exception clipboard) {
            // empty catch block
        }
        if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String s = (String)data.getTransferData(DataFlavor.stringFlavor);
                if (whenDone != null) {
                    whenDone.accept(s);
                }
                return s;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static void copy(String s, ClipboardOwner owner) {
        StringSelection stringSelection = new StringSelection(s);
        OSPRuntime.getClipboard().setContents(stringSelection, owner == null ? stringSelection : owner);
    }

    public static void setJSClipboardPasteListener(Component c, TransferHandler handler) {
        jsutil.setPasteListener(c, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addAssets(String name, String zipPath, String path) {
        if (!useZipAssets) return;
        try {
            Object val;
            block14: {
                Object object = val = isJS ? jsutil.getAppletInfo("assets") : null;
                if (val == null) {
                    val = DEFAULT_LF;
                }
                if (!(val instanceof String)) break block14;
                switch (((String)val).toUpperCase()) {
                    case "DEFAULT": {
                        if (!isJS) {
                            zipPath = OSPRuntime.class.getClassLoader().getResource(zipPath).toString();
                        }
                        Assets.add(new Assets.Asset(name, zipPath, path));
                        return;
                    }
                    default: {
                        Assets.add(val);
                        return;
                    }
                    case "NONE": {
                        return;
                    }
                }
            }
            Assets.add(val);
            return;
        }
        catch (Throwable e) {
            OSPLog.warning("Error reading assets path. ");
            System.err.println("Error reading assets path.");
        }
    }

    public static long[] getMemory() {
        if (isJS) {
            long[] lArray = new long[2];
            lArray[1] = Long.MAX_VALUE;
            return lArray;
        }
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        return new long[]{memory.getHeapMemoryUsage().getUsed() / 0x100000L, memory.getHeapMemoryUsage().getMax() / 0x100000L};
    }

    public static String getMemoryStr() {
        if (isJS) {
            return "";
        }
        long[] m = OSPRuntime.getMemory();
        return String.valueOf(m[0]) + "/" + m[1];
    }

    public static Timer trigger(int ms, ActionListener a) {
        Timer timer = new Timer(ms, a);
        timer.setRepeats(false);
        timer.start();
        return timer;
    }

    public static void chooseColor(final Color color, String title, Consumer<Color> whenDone) {
        final JColorChooser chooser = new JColorChooser();
        chooser.setColor(color);
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setColor(color);
            }
        };
        ActionListener okListener = e -> whenDone.accept(chooser.getColor());
        JDialog dialog = JColorChooser.createDialog(null, title, true, chooser, okListener, cancelListener);
        FontSizer.setFonts(dialog, FontSizer.getLevel());
        dialog.setVisible(true);
    }

    public static interface Disposable {
        public static final List<Object> allocated = new ArrayList<Object>();

        public void dispose();

        public static void allocate(Disposable obj) {
            if (allocated.contains(obj)) {
                return;
            }
            allocated.add(obj);
            OSPLog.notify(obj, "allocated");
        }

        public static void allocate(Disposable[] objs, String name) {
            allocated.add(objs);
            OSPLog.notify(String.valueOf(name) + "[]", "allocated");
        }

        public static void deallocate(Disposable[] objs) {
            Disposable[] disposableArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Disposable o = disposableArray[n2];
                if (o != null) {
                    Disposable.deallocate(o);
                }
                ++n2;
            }
        }

        public static void deallocate(Disposable[] objs, int i) {
            Disposable o = objs[i];
            if (o != null) {
                Disposable.deallocate(o);
                objs[i] = null;
            }
        }

        public static void deallocate(Disposable[] objs, BitSet bs) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                Disposable.deallocate(objs, i);
                i = bs.nextSetBit(i + 1);
            }
        }

        public static void deallocate(Disposable obj) {
            if (obj == null) {
                return;
            }
            obj.dispose();
            allocated.remove(obj);
            OSPLog.notify(obj, " deallocated ");
        }

        public static void clearAllocation(Disposable obj) {
            if (obj == null) {
                return;
            }
            allocated.remove(obj);
            OSPLog.notify(obj, " deallocated ");
        }

        public static void deallocateAll() {
            for (Object o : allocated) {
                if (o instanceof Disposable) {
                    ((Disposable)o).dispose();
                    OSPLog.notify(o, " deallocated ");
                    continue;
                }
                if (o instanceof Disposable[]) {
                    Disposable[] disposableArray = (Disposable[])o;
                    int n = disposableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Disposable ao = disposableArray[n2];
                        if (ao != null) {
                            Disposable.deallocate(ao);
                        }
                        ++n2;
                    }
                    continue;
                }
                OSPLog.notify(o, "deallocated");
            }
            allocated.clear();
        }

        public static void dump() {
            int n = 0;
            for (Object o : allocated) {
                if (o instanceof Disposable[]) {
                    Disposable[] disposableArray = (Disposable[])o;
                    int n2 = disposableArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Disposable ao = disposableArray[n3];
                        if (ao != null && ++n > 0) {
                            OSPLog.notify(ao, " still allocated!");
                        }
                        ++n3;
                    }
                    continue;
                }
                ++n;
                OSPLog.notify(o, "still allocated!");
            }
            OSPLog.notify("" + n, "objects still allocated" + (n == 0 ? "" : "!!!!!!!!!!!!"));
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description = "";
        private ArrayList<String> extensions = new ArrayList();

        private ExtensionFileFilter() {
        }

        public void addExtension(String extension) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this.extensions.add(extension.toLowerCase());
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String aDescription) {
            this.description = aDescription;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            int i = 0;
            while (i < this.extensions.size()) {
                if (name.endsWith(this.extensions.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static abstract class Supported {
        private static boolean debugging = false;
        private PropertyChangeSupport support;
        HashSet<String> pointers = new HashSet();

        public Supported() {
            this.support = new SwingPropertyChangeSupport(this);
        }

        public void firePropertyChange(PropertyChangeEvent e) {
            this.support.firePropertyChange(e);
        }

        public void firePropertyChange(String name, Object oldVal, Object newVal) {
            this.support.firePropertyChange(name, oldVal, newVal);
        }

        private void addPtr(String key) {
            boolean b = this.pointers.add(key);
            if (debugging) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + key + " ADD " + b);
            }
        }

        private void removePtr(String key) {
            boolean b = this.pointers.remove(key);
            if (debugging) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + key + " REM " + b + " " + this.pointers.size() + (this.pointers.size() == 1 ? this.pointers.toString() : ""));
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            String key = "<-" + listener.getClass().getSimpleName() + listener.hashCode();
            if (this.pointers.contains(key)) {
                return;
            }
            this.addPtr(key);
            this.support.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListenerSafely(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
            String key = "/" + property + "<-" + listener.getClass().getSimpleName() + listener.hashCode();
            if (this.pointers.contains(key)) {
                return;
            }
            this.addPtr(key);
            this.support.addPropertyChangeListener(property, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            String key = "<-" + listener.getClass().getSimpleName() + listener.hashCode();
            if (!this.pointers.contains(key)) {
                return;
            }
            this.removePtr(key);
            this.support.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            String key = "/" + property + "<-" + listener.getClass().getSimpleName() + listener.hashCode();
            if (!this.pointers.contains(key)) {
                return;
            }
            this.removePtr(key);
            this.support.removePropertyChangeListener(property, listener);
        }

        public static void addListeners(Supported c, String[] names, PropertyChangeListener listener) {
            int i = names.length;
            while (--i >= 0) {
                c.addPropertyChangeListener(names[i], listener);
            }
        }

        public static void removeListeners(Supported c, String[] names, PropertyChangeListener listener) {
            int i = names.length;
            while (--i >= 0) {
                c.removePropertyChangeListener(names[i], listener);
            }
        }

        public void dispose() {
            PropertyChangeListener[] a = this.support.getPropertyChangeListeners();
            if (debugging) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + "------------" + a.length);
            }
            int i = a.length;
            while (--i >= 0) {
                PropertyChangeListener p = a[i];
                if (p instanceof PropertyChangeListenerProxy) {
                    String prop = ((PropertyChangeListenerProxy)p).getPropertyName();
                    p = (PropertyChangeListener)((PropertyChangeListenerProxy)p).getListener();
                    this.removePropertyChangeListener(prop, p);
                    continue;
                }
                this.removePropertyChangeListener(p);
            }
        }

        public static void dispose(Component c) {
            PropertyChangeListener[] a = c.getPropertyChangeListeners();
            if (debugging) {
                System.out.println(String.valueOf(c.getClass().getSimpleName()) + "------------" + a.length);
            }
            int i = a.length;
            while (--i >= 0) {
                PropertyChangeListener p = a[i];
                if (p instanceof PropertyChangeListenerProxy) {
                    String prop = ((PropertyChangeListenerProxy)p).getPropertyName();
                    p = (PropertyChangeListener)((PropertyChangeListenerProxy)p).getListener();
                    if (debugging) {
                        System.out.println(String.valueOf(c.getClass().getSimpleName()) + "/" + prop + "---remove " + p.getClass().getSimpleName());
                    }
                    c.removePropertyChangeListener(prop, p);
                    continue;
                }
                if (debugging) {
                    System.out.println(String.valueOf(c.getClass().getSimpleName()) + "---remove " + p.getClass().getSimpleName());
                }
                c.removePropertyChangeListener(p);
                if (!(c instanceof PropertyChangeListener)) continue;
                if (p instanceof Component) {
                    ((Component)((Object)p)).removePropertyChangeListener((PropertyChangeListener)((Object)c));
                    continue;
                }
                if (!(p instanceof Supported)) continue;
                ((Supported)((Object)p)).removePropertyChangeListener((PropertyChangeListener)((Object)c));
            }
        }
    }

    public static class TextLayout {
        private String text;
        private Font font;
        private java.awt.font.TextLayout tl;

        public TextLayout(String text, Font font) {
            this.text = text;
            this.font = font;
        }

        public void draw(Graphics g, float x, float y) {
            this.getTL();
            this.tl.draw((Graphics2D)g, x, y);
        }

        public Rectangle2D getBounds() {
            this.getTL();
            return this.tl.getBounds();
        }

        private java.awt.font.TextLayout getTL() {
            if (this.tl == null) {
                this.tl = isJS ? (java.awt.font.TextLayout)((Object)new JSTL()) : new java.awt.font.TextLayout(this.text, this.font, frc);
            }
            return this.tl;
        }

        class JSTL {
            JSTL() {
            }

            void draw(Graphics2D g, float x, float y) {
                boolean testing = false;
                g.setFont(TextLayout.this.font);
                g.drawString(TextLayout.this.text, x, y);
                if (testing) {
                    java.awt.font.TextLayout t0 = new java.awt.font.TextLayout(TextLayout.this.text, TextLayout.this.font, frc);
                    g.setColor(Color.red);
                    int w = (int)t0.getBounds().getWidth();
                    t0.draw(g, x + (float)w, y);
                    t0.draw(g, x - (float)w, y);
                }
            }

            Rectangle2D getBounds() {
                return TextLayout.this.font.getStringBounds(TextLayout.this.text, frc);
            }

            float getAscent() {
                return TextLayout.this.font.getLineMetrics(TextLayout.this.text, frc).getAscent();
            }

            float getDescent() {
                return TextLayout.this.font.getLineMetrics(TextLayout.this.text, frc).getDescent();
            }

            float getLeading() {
                return TextLayout.this.font.getLineMetrics(TextLayout.this.text, frc).getLeading();
            }
        }
    }

    public static class Version
    implements Comparable<Version> {
        String ver;

        public Version(String version) {
            this.ver = version;
        }

        public String toString() {
            return this.ver;
        }

        public boolean isValid() {
            String[] v = this.ver.trim().split("\\.");
            if (v.length >= 2 && v.length <= 4) {
                int i = 0;
                while (i < v.length) {
                    try {
                        Integer.parseInt(v[i].trim());
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Version o) {
            String[] v1 = this.ver.trim().split("\\.");
            String[] v2 = o.ver.trim().split("\\.");
            if (v1.length == 2) {
                v1 = new String[]{v1[0], v1[1], "0", "0"};
            } else if (v1.length == 3) {
                v1 = new String[]{v1[0], v1[1], v1[2], "0"};
            }
            if (v2.length == 2) {
                v2 = new String[]{v2[0], v2[1], "0", "0"};
            } else if (v2.length == 3) {
                v2 = new String[]{v2[0], v2[1], v2[2], "0"};
            }
            int i = 0;
            while (i < v1.length) {
                if (Integer.parseInt(v1[i]) < Integer.parseInt(v2[i])) {
                    return -1;
                }
                if (Integer.parseInt(v1[i]) > Integer.parseInt(v2[i])) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    }
}

