/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.display.axes.CustomAxes;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.display.axes.PolarType2;
import org.opensourcephysics.numerics.FunctionTransform;
import org.opensourcephysics.numerics.LogBase10Function;

public class PlottingPanel
extends InteractivePanel {
    protected DrawableAxes axes;
    protected static final double log10 = Math.log(10.0);
    protected static final LogBase10Function logBase10Function = new LogBase10Function();
    static int ppid = 0;
    public int id;

    public PlottingPanel(String xlabel, String ylabel, String plotTitle) {
        this(xlabel, ylabel, plotTitle, 0, 0);
    }

    public PlottingPanel(int _xAxisType, int _yAxisType) {
        this("x", "y", DisplayRes.getString("PlottingPanel.DefaultTitle"), _xAxisType, _yAxisType);
    }

    public PlottingPanel(String xlabel, String ylabel, String plotTitle, int xAxisType, int yAxisType) {
        this.initAxes();
        this.id = ++ppid;
        this.axes.setXLabel(xlabel, null);
        this.axes.setYLabel(ylabel, null);
        this.axes.setTitle(plotTitle, null);
        this.pixelTransform = new FunctionTransform();
        ((FunctionTransform)this.pixelTransform).setXFunction(logBase10Function);
        ((FunctionTransform)this.pixelTransform).setYFunction(logBase10Function);
        this.logScaleX = xAxisType == 1;
        this.logScaleY = yAxisType == 1;
        this.setLogScale(this.logScaleX, this.logScaleY);
    }

    private void setXYFunction(boolean logx, boolean logy) {
        FunctionTransform ft = (FunctionTransform)this.pixelTransform;
        ft.setApplyXFunction(logx);
        ft.setApplyYFunction(logy);
    }

    @Override
    public Interactive getInteractive() {
        Interactive iad = super.getInteractive();
        return iad == null && this.axes.isInteractive() ? ((Interactive)((Object)this.axes)).findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY()) : iad;
    }

    public DrawableAxes getAxes() {
        return this.axes;
    }

    protected void initAxes() {
        new CartesianInteractive(this);
    }

    public void setAxes(DrawableAxes _axes) {
        if (this.axes != null && this.axes != _axes && this.axes instanceof CartesianInteractive) {
            ((CartesianInteractive)this.axes).dispose();
        }
        this.axes = _axes;
        if (this.axes == null) {
            this.axes = new CustomAxes(this);
            this.setPreferredGutters(0, 0, 0, 0);
            this.setClipAtGutter(false);
            this.axes.setVisible(false);
        } else {
            this.setClipAtGutter(true);
        }
    }

    public void setPolar(String plotTitle, double deltaR) {
        if (this.logScaleX || this.logScaleY) {
            System.err.println("The axes type cannot be swithed when using logarithmetic scales.");
            return;
        }
        PolarType2 axes = new PolarType2(this);
        axes.setDeltaR(deltaR);
        axes.setDeltaTheta(0.39269908169872414);
        this.setTitle(plotTitle);
        this.setSquareAspect(true);
        this.setClipAtGutter(true);
    }

    public void setCartesian(String xLabel, String yLabel, String plotTitle) {
        this.axes = new CartesianInteractive(this);
        this.axes.setXLabel(xLabel, null);
        this.axes.setYLabel(yLabel, null);
        this.axes.setTitle(plotTitle, null);
        this.setClipAtGutter(true);
    }

    public void setXLabel(String label) {
        this.axes.setXLabel(label, null);
    }

    public void setYLabel(String label) {
        this.axes.setYLabel(label, null);
    }

    public void setTitle(String title) {
        this.axes.setTitle(title, null);
    }

    public void setXLabel(String label, String font_name) {
        this.axes.setXLabel(label, font_name);
    }

    public void setYLabel(String label, String font_name) {
        this.axes.setYLabel(label, font_name);
    }

    public void setTitle(String title, String font_name) {
        this.axes.setTitle(title, font_name);
    }

    public void setAxesVisible(boolean isVisible) {
        this.axes.setVisible(isVisible);
    }

    public void setLogScale(boolean _logScaleX, boolean _logScaleY) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setXLog(_logScaleX);
            this.logScaleX = _logScaleX;
        } else {
            this.logScaleX = false;
        }
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setYLog(_logScaleY);
            this.logScaleY = _logScaleY;
        } else {
            this.logScaleY = false;
        }
    }

    public void setLogScaleX(boolean _logScaleX) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setXLog(_logScaleX);
            this.logScaleX = _logScaleX;
        } else {
            this.logScaleX = false;
        }
    }

    public void setLogScaleY(boolean _logScaleY) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setYLog(_logScaleY);
            this.logScaleY = _logScaleY;
        } else {
            this.logScaleY = false;
        }
    }

    @Override
    protected void computeGutters() {
        Dimension axesInterior;
        this.resetGutters();
        Dimension interiorDimension = null;
        if (this.dimensionSetter != null) {
            interiorDimension = this.dimensionSetter.getInterior(this);
        }
        if (this.axes instanceof Dimensioned && (axesInterior = ((Dimensioned)((Object)this.axes)).getInterior(this)) != null) {
            interiorDimension = axesInterior;
        }
        if (interiorDimension != null) {
            this.squareAspect = false;
            this.adjustableGutter = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - interiorDimension.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - interiorDimension.height) / 2;
        }
    }

    @Override
    protected void paintFirst(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        if (this.leftGutterPreferred > 0 || this.topGutterPreferred > 0 || this.rightGutterPreferred > 0 || this.bottomGutterPreferred > 0) {
            this.axes.draw(this, g);
        }
    }

    @Override
    public double pixToX(int pix) {
        if (this.logScaleX) {
            return Math.pow(10.0, super.pixToX(pix));
        }
        return super.pixToX(pix);
    }

    @Override
    public int xToPix(double x) {
        if (this.logScaleX) {
            if (x <= 0.0) {
                x = Math.max((double)1.4E-45f, this.xmin);
            }
            return super.xToPix(PlottingPanel.logBase10(x));
        }
        return super.xToPix(x);
    }

    @Override
    public float xToGraphics(double x) {
        if (this.logScaleX) {
            if (x <= 0.0) {
                x = Math.max((double)1.4E-45f, this.xmin);
            }
            return super.xToGraphics(PlottingPanel.logBase10(x));
        }
        return super.xToGraphics(x);
    }

    @Override
    public double pixToY(int pix) {
        if (this.logScaleY) {
            return Math.pow(10.0, super.pixToY(pix));
        }
        return super.pixToY(pix);
    }

    @Override
    public int yToPix(double y) {
        if (this.logScaleY) {
            if (y <= 0.0) {
                y = Math.max((double)1.4E-45f, this.ymin);
            }
            return super.yToPix(PlottingPanel.logBase10(y));
        }
        return super.yToPix(y);
    }

    @Override
    public float yToGraphics(double y) {
        if (this.logScaleY) {
            if (y <= 0.0) {
                y = Math.max((double)1.4E-45f, this.ymin);
            }
            return super.yToGraphics(PlottingPanel.logBase10(y));
        }
        return super.yToGraphics(y);
    }

    @Override
    public int getBottomGutter() {
        return Math.max(this.bottomGutter, this.bottomGutterPreferred);
    }

    @Override
    public int getTopGutter() {
        return Math.max(this.topGutter, this.topGutterPreferred);
    }

    @Override
    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        if (this.dimensionSetter == null) {
            this.leftGutter = Math.max(this.leftGutter, this.leftGutterPreferred);
            this.topGutter = Math.max(this.topGutter, this.topGutterPreferred);
            this.rightGutter = Math.max(this.rightGutter, this.rightGutterPreferred);
            this.bottomGutter = Math.max(this.bottomGutter, this.bottomGutterPreferred);
        }
        if (this.logScaleX) {
            this.xmin = PlottingPanel.logBase10(Math.max(this.xmin, 1.0E-30));
            this.xmax = PlottingPanel.logBase10(Math.max(this.xmax, 1.0E-30));
            if (this.xmin == 0.0) {
                this.xmin = 1.0E-8;
            }
            if (this.xmax == 0.0) {
                this.xmax = Math.max(this.xmin + 1.0E-8, 1.0E-8);
            }
        }
        if (this.logScaleY) {
            this.ymin = PlottingPanel.logBase10(Math.max(this.ymin, 1.0E-30));
            this.ymax = PlottingPanel.logBase10(Math.max(this.ymax, 1.0E-30));
            if (this.ymin == 0.0) {
                this.ymin = 1.0E-8;
            }
            if (this.ymax == 0.0) {
                this.ymax = Math.max(this.ymin + 1.0E-8, 1.0E-8);
            }
        }
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.lastWidth - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.lastWidth - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.lastHeight - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.lastHeight - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.setXYFunction(false, false);
            this.pixelTransform.setTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.pixelTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)(this.lastWidth - this.leftGutter - this.rightGutter) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)(this.lastHeight - this.bottomGutter - this.topGutter) / (this.ymax - this.ymin);
        if (this.squareAspect) {
            if (this.adjustableGutter) {
                if (Math.abs(this.xPixPerUnit / this.yPixPerUnit) >= 1.0) {
                    this.xPixPerUnit = this.yPixPerUnit;
                    float gutter = (float)this.lastWidth - (float)Math.abs((this.xmax - this.xmin) * this.xPixPerUnit);
                    this.leftGutter = (int)(gutter / 2.0f + (float)this.leftGutterPreferred - (float)this.rightGutterPreferred + 0.5f);
                    this.rightGutter = (int)((double)(gutter - (float)this.leftGutter) - 0.5);
                    this.leftGutter = Math.max(0, this.leftGutter);
                    this.rightGutter = Math.max(0, this.rightGutter);
                } else {
                    this.yPixPerUnit = this.xPixPerUnit;
                    float gutter = (float)this.lastHeight - (float)Math.abs((this.ymax - this.ymin) * this.yPixPerUnit);
                    this.topGutter = (int)(gutter / 2.0f + (float)this.topGutterPreferred - (float)this.bottomGutterPreferred + 0.5f);
                    this.bottomGutter = (int)(gutter - (float)this.topGutter);
                    this.topGutter = Math.max(0, this.topGutter);
                    this.bottomGutter = Math.max(0, this.bottomGutter);
                }
            } else {
                double stretch = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
                if (stretch >= 1.0) {
                    stretch = Math.min(stretch, (double)this.lastWidth);
                    this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                    this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                    this.xPixPerUnit = (double)(this.lastWidth - this.leftGutter - this.rightGutter) / (this.xmax - this.xmin);
                } else {
                    stretch = Math.max(stretch, 1.0 / (double)this.lastHeight);
                    this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                    this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                    this.yPixPerUnit = (double)(this.lastHeight - this.bottomGutter - this.topGutter) / (this.ymax - this.ymin);
                }
            }
        }
        this.setXYFunction(this.logScaleX, this.logScaleY);
        this.pixelTransform.setTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    static double logBase10(double x) {
        return Math.log(x) / log10;
    }

    public static XML.ObjectLoader getLoader() {
        return new PlottingPanelLoader();
    }

    static class PlottingPanelLoader
    extends DrawingPanel.DrawingPanelLoader {
        PlottingPanelLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PlottingPanel panel = (PlottingPanel)obj;
            control.setValue("title", panel.axes.getTitle());
            control.setValue("x axis label", panel.axes.getXLabel());
            control.setValue("y axis label", panel.axes.getYLabel());
            super.saveObject(control, obj);
        }

        @Override
        public Object createObject(XMLControl control) {
            String title = control.getString("title");
            String xlabel = control.getString("x axis label");
            String ylabel = control.getString("y axis label");
            return new PlottingPanel(xlabel, ylabel, title);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PlottingPanel panel = (PlottingPanel)obj;
            panel.setTitle(control.getString("title"));
            panel.setXLabel(control.getString("x axis label"));
            panel.setYLabel(control.getString("y axis label"));
            super.loadObject(control, obj);
            return obj;
        }
    }
}

