/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AxisFactory;
import org.opensourcephysics.display.axes.PolarType1;
import org.opensourcephysics.display.axes.PolarType2;

public class PlottingPanelFactory {
    private PlottingPanelFactory() {
    }

    public static PlottingPanel createType1(String xlabel, String ylabel, String plotTitle) {
        PlottingPanel panel = new PlottingPanel(xlabel, ylabel, plotTitle);
        panel.axes = AxisFactory.createAxesType1(panel);
        panel.axes.setXLabel(xlabel, null);
        panel.axes.setYLabel(ylabel, null);
        panel.axes.setTitle(plotTitle, null);
        return panel;
    }

    public static PlottingPanel createType2(String xlabel, String ylabel, String plotTitle) {
        PlottingPanel panel = new PlottingPanel(xlabel, ylabel, plotTitle);
        panel.axes = AxisFactory.createAxesType2(panel);
        panel.axes.setXLabel(xlabel, null);
        panel.axes.setYLabel(ylabel, null);
        panel.axes.setTitle(plotTitle, null);
        return panel;
    }

    public static PlottingPanel createPolarType1(String plotTitle, double deltaR) {
        PlottingPanel panel = new PlottingPanel(null, null, plotTitle);
        PolarType1 axes = new PolarType1(panel);
        axes.setDeltaR(deltaR);
        axes.setDeltaTheta(0.39269908169872414);
        panel.setTitle(plotTitle);
        panel.setSquareAspect(true);
        return panel;
    }

    public static PlottingPanel createPolarType2(String plotTitle, double deltaR) {
        PlottingPanel panel = new PlottingPanel(null, null, plotTitle);
        PolarType2 axes = new PolarType2(panel);
        axes.setDeltaR(deltaR);
        axes.setDeltaTheta(0.39269908169872414);
        panel.setTitle(plotTitle);
        panel.setSquareAspect(true);
        return panel;
    }

    public static PlottingPanel createType3(String xlabel, String ylabel, String plotTitle) {
        PlottingPanel panel = new PlottingPanel(xlabel, ylabel, plotTitle);
        panel.axes = AxisFactory.createAxesType3(panel);
        panel.axes.setXLabel(xlabel, null);
        panel.axes.setYLabel(ylabel, null);
        panel.axes.setTitle(plotTitle, null);
        return panel;
    }
}

