/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.opensourcephysics.tools.FontSizer;

public class ResizableIcon
implements Icon {
    private final int baseWidth;
    private final int baseHeight;
    private BufferedImage baseImage;
    private final Icon icon;
    private int sizeFactor;
    private int w;
    private int h;
    private int fixedSizeFactor = 0;
    private boolean isDrawn;

    public ResizableIcon(URL location) {
        this(new ImageIcon(location));
    }

    public ResizableIcon(Icon icon) {
        while (icon instanceof ResizableIcon) {
            icon = ((ResizableIcon)icon).icon;
        }
        this.icon = icon;
        if (icon == null) {
            this.baseWidth = 0;
            this.baseHeight = 0;
        } else {
            this.baseWidth = icon.getIconWidth();
            this.baseHeight = icon.getIconHeight();
        }
        this.isDrawn = !(icon instanceof ImageIcon);
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null || this.baseHeight < 0 || this.baseWidth < 0) {
            return;
        }
        if (this.baseImage == null) {
            this.baseImage = new BufferedImage(this.baseWidth, this.baseHeight, 2);
        }
        Graphics2D g2 = this.baseImage.createGraphics();
        if (this.isDrawn) {
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, this.baseWidth, this.baseHeight);
            g2.setComposite(AlphaComposite.SrcOver);
        }
        this.icon.paintIcon(c, g2, 0, 0);
        g2.dispose();
        g.drawImage(this.baseImage, x, y, this.getIconWidth(), this.getIconHeight(), c);
    }

    @Override
    public int getIconWidth() {
        if (this.fixedSizeFactor <= 0) {
            this.setSizeFactor(FontSizer.getIntegerFactor());
        }
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public Icon getBaseIcon() {
        return this.icon;
    }

    private void setSizeFactor(int factor) {
        if (factor != this.sizeFactor) {
            this.sizeFactor = factor;
            this.w = this.baseWidth * factor;
            this.h = this.baseHeight * factor;
        }
    }

    public void setFixedSizeFactor(int factor) {
        if (factor != this.fixedSizeFactor) {
            this.fixedSizeFactor = factor;
            this.w = this.baseWidth * factor;
            this.h = this.baseHeight * factor;
        }
    }
}

