/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class Spring
implements Measurable {
    private GeneralPath springPath = new GeneralPath();
    protected boolean thinExtremes = true;
    protected boolean visible = true;
    protected int loops = -1;
    protected int pointsPerLoop = -1;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float sizex = 0.1f;
    protected float sizey = 0.0f;
    protected float radius = 0.1f;
    protected float solenoid = 0.0f;
    protected Color edgeColor = Color.BLACK;
    protected Stroke edgeStroke = new BasicStroke(1.0f);
    protected boolean hasChanged = true;
    protected boolean zeroLength = false;
    private int segments = 0;
    private float[] xPoints = null;
    private float[] yPoints = null;

    public Spring() {
        this(0.1);
    }

    public Spring(double _radius) {
        this.setRadius(_radius);
        this.setResolution(8, 15);
    }

    public void setX(double x) {
        this.x = (float)x;
        this.hasChanged = true;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = (float)y;
        this.hasChanged = true;
    }

    public double getY() {
        return this.y;
    }

    public void setXY(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
        this.hasChanged = true;
    }

    public void setSizeX(double sizeX) {
        this.sizex = (float)sizeX;
        this.hasChanged = true;
    }

    public double getSizeX() {
        return this.sizex;
    }

    public void setSizeY(double sizeY) {
        this.sizey = (float)sizeY;
        this.hasChanged = true;
    }

    public double getSizeY() {
        return this.sizey;
    }

    public void setSizeXY(double sizeX, double sizeY) {
        this.sizex = (float)sizeX;
        this.sizey = (float)sizeY;
        this.hasChanged = true;
    }

    public void setRadius(double radius) {
        this.radius = (float)radius;
        this.hasChanged = true;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeStroke(Stroke stroke) {
        this.edgeStroke = stroke;
    }

    public Stroke getEdgeStroke() {
        return this.edgeStroke;
    }

    public void setResolution(int nLoops, int nPointsPerLoop) {
        if (nLoops == this.loops && nPointsPerLoop == this.pointsPerLoop) {
            return;
        }
        this.loops = nLoops;
        this.pointsPerLoop = nPointsPerLoop;
        this.segments = this.loops * this.pointsPerLoop;
        int n = this.segments + 1;
        this.xPoints = new float[n];
        this.yPoints = new float[n];
        this.hasChanged = true;
    }

    public int getLoops() {
        return this.loops;
    }

    public int getPointsPerLoop() {
        return this.pointsPerLoop;
    }

    public void setSolenoid(double factor) {
        this.solenoid = (float)factor;
        this.hasChanged = true;
    }

    public void setThinExtremes(boolean thin) {
        this.thinExtremes = thin;
        this.hasChanged = true;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computePoints();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(this.edgeStroke);
        g2.setColor(this.edgeColor);
        if (this.zeroLength) {
            int a = panel.xToPix(this.x);
            int b = panel.yToPix(this.y);
            g2.drawLine(a, b, a, b);
            return;
        }
        g2.draw(panel.transformShape(this.springPath));
    }

    @Override
    public boolean isMeasured() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        return this.sizex > 0.0f ? this.x : this.x + this.sizex;
    }

    @Override
    public double getXMax() {
        return this.sizex > 0.0f ? this.x + this.sizex : this.x;
    }

    @Override
    public double getYMin() {
        return this.sizey > 0.0f ? this.y : this.y + this.sizey;
    }

    @Override
    public double getYMax() {
        return this.sizey > 0.0f ? this.y + this.sizey : this.y;
    }

    private void computeGeneralPath() {
        if (this.xPoints == null || this.xPoints.length < 2) {
            return;
        }
        int n = this.xPoints.length;
        this.springPath = new GeneralPath();
        this.springPath.moveTo(this.xPoints[0], this.yPoints[0]);
        int i = 1;
        while (i < n) {
            this.springPath.lineTo(this.xPoints[i], this.yPoints[i]);
            ++i;
        }
    }

    private void computePoints() {
        float length = this.sizex * this.sizex + this.sizey * this.sizey;
        if (length == 0.0f) {
            this.zeroLength = true;
            return;
        }
        this.zeroLength = false;
        length = (float)Math.sqrt(length);
        float u2x = -this.sizey / length;
        float u2y = this.sizex / length;
        float delta = (float)(Math.PI * 2 / (double)this.pointsPerLoop);
        if (this.radius < 0.0f) {
            delta *= -1.0f;
        }
        int pre = this.pointsPerLoop / 2;
        int i = 0;
        while (i <= this.segments) {
            int k = this.thinExtremes ? (i < pre ? 0 : (i < this.pointsPerLoop ? i - pre : (i > this.segments - pre ? 0 : (i > this.segments - this.pointsPerLoop ? this.segments - i - pre : pre)))) : pre;
            float angle = (float)(1.5707963267948966 + (double)((float)i * delta));
            float cos = (float)Math.cos(angle);
            this.xPoints[i] = this.x + (float)i * this.sizex / (float)this.segments + (float)k * this.radius * cos * u2x / (float)pre;
            this.yPoints[i] = this.y + (float)i * this.sizey / (float)this.segments + (float)k * this.radius * cos * u2y / (float)pre;
            if ((double)this.solenoid != 0.0) {
                double cte = (double)k * Math.cos((double)(i * 2) * Math.PI / (double)this.pointsPerLoop) / (double)pre;
                int n = i;
                this.xPoints[n] = (float)((double)this.xPoints[n] + (double)this.solenoid * cte * (double)this.sizex);
                int n2 = i;
                this.yPoints[n2] = (float)((double)this.yPoints[n2] + (double)this.solenoid * cte * (double)this.sizey);
            }
            ++i;
        }
        this.computeGeneralPath();
        this.hasChanged = false;
    }
}

