/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.HashMap;
import java.util.Map;

public class TeXParser {
    public static Map<String, String> charMap = new HashMap<String, String>();
    static int np;

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\lambda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
        charMap.put("\\sqr", "\u00b2");
        charMap.put("\\pm", "\u00b1");
        charMap.put("\\neq", "\u2260");
        charMap.put("\\leq", "\u2264");
        charMap.put("\\geq", "\u00f7");
        charMap.put("\\div", "\u00f7");
        charMap.put("\\perp", "\u27c2");
        charMap.put("\\parallel", "\u2225");
        np = 0;
    }

    public static String parseTeX(String s) {
        int pt;
        if (s == null || (pt = s.indexOf("$\\")) < 0) {
            return s;
        }
        int off = 1;
        while (pt >= 0) {
            int pt1 = s.indexOf("$", pt + 1);
            if (pt1 < 0) {
                pt1 = s.length();
                off = 0;
            }
            String ch = charMap.get(s.substring(pt + 1, pt1));
            s = String.valueOf(s.substring(0, pt)) + (ch == null ? s.substring(pt + 2, pt1) : ch) + s.substring(pt1 + off);
            int n = pt = off == 0 ? -1 : s.indexOf("$\\", pt + 1);
        }
        return s;
    }

    public static String toHTML(String s) {
        return TeXParser.toHTML(TeXParser.toHTML(s, "_{", "sub"), "^{", "sup");
    }

    public static String toHTML(String s, String tex, String html) {
        int pt;
        if (s == null || (pt = s.indexOf(tex)) < 0) {
            return s;
        }
        boolean ishtml = false;
        while (pt >= 0) {
            int pt1 = s.indexOf("}", pt + 1);
            if (pt1 < 0) break;
            s = String.valueOf(s.substring(0, pt)) + "<" + html + ">" + s.substring(pt + 2, pt1) + "</" + html + ">" + s.substring(pt1 + 1);
            ishtml = true;
        }
        return ishtml ? "<html>" + s + "</html>" : s;
    }

    public static String removeSubscripting(String input) {
        if (input == null) {
            return null;
        }
        return String.valueOf(TeXParser.removeSubscript(input)) + TeXParser.getSubscript(input);
    }

    public static String removeSubscript(String input) {
        int n;
        return input == null ? null : ((n = input.indexOf("_")) > 0 ? input.substring(0, n) : input);
    }

    public static String getSubscript(String input) {
        int m;
        if (input == null) {
            return null;
        }
        String subscript = "";
        int n = input.indexOf("_");
        if (n > 0 && (subscript = input.substring(n + 1)).startsWith("{") && (m = subscript.indexOf("}")) > 0) {
            subscript = subscript.substring(1, m);
        }
        return subscript;
    }

    public static String addSubscript(String root, String subscript) {
        if (root == null) {
            return null;
        }
        if (subscript == null) {
            return root;
        }
        if ((subscript = subscript.trim()).startsWith("{")) {
            int n = subscript.indexOf("}");
            if (n == -1) {
                n = subscript.length();
            }
            subscript = subscript.substring(1, n).trim();
        }
        if (subscript.equals("")) {
            return root;
        }
        String prevSubscript = TeXParser.getSubscript(root);
        if (prevSubscript != null) {
            subscript = String.valueOf(prevSubscript) + subscript;
        }
        return String.valueOf(TeXParser.removeSubscript(root)) + "_{" + subscript + "}";
    }
}

