/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TeXParser;

public class TextBox
implements Drawable {
    public static final int COORDINATE_PLACEMENT = 0;
    public static final int PIXEL_PLACEMENT = 1;
    public static final int RELATIVE_PLACEMENT = 2;
    public static final int BOTTOM_LEFT_PLACEMENT = 3;
    public static final int TOP_LEFT_PLACEMENT = 4;
    public static final int BOTTOM_RIGHT_PLACEMENT = 5;
    public static final int TOP_RIGHT_PLACEMENT = 6;
    public static final int BOTTOM_LEFT_GUTTER_PLACEMENT = 7;
    public static final int TOP_LEFT_GUTTER_PLACEMENT = 8;
    public static final int BOTTOM_RIGHT_GUTTER_PLACEMENT = 9;
    public static final int TOP_RIGHT_GUTTER_PLACEMENT = 10;
    public static final int TOP_RIGHT_ALIGNMENT = 0;
    public static final int TOP_CENTER_ALIGNMENT = 1;
    public int placement_mode = 0;
    public int alignment_mode = 0;
    public int xoffset = 0;
    public int yoffset = 0;
    protected String text = null;
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    protected Color color = Color.black;
    protected double x;
    protected double y;
    protected int xpix = 0;
    protected int ypix = 0;
    protected int boxHeight = 0;
    protected int boxWidth = 0;

    public TextBox() {
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public TextBox(String str) {
        this();
        this.text = TeXParser.parseTeX(str);
    }

    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public void setText(String _text) {
        this.text = TeXParser.parseTeX(_text);
    }

    public void setText(String _text, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.text = TeXParser.parseTeX(_text);
    }

    public void resetBoxSize() {
        this.boxHeight = 0;
        this.boxWidth = 0;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        String tempText = this.text;
        if (tempText == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int sh = fm.getAscent() + 2;
        int sw = fm.stringWidth(tempText) + 6;
        this.boxHeight = Math.max(this.boxHeight, sh);
        this.boxWidth = Math.max(this.boxWidth, sw);
        switch (this.placement_mode) {
            case 1: {
                this.xpix = (int)this.x;
                this.ypix = (int)this.y;
                break;
            }
            case 2: {
                this.xpix = (int)(this.x * (double)panel.getWidth());
                this.ypix = (int)((1.0 - this.y) * (double)panel.getHeight());
                break;
            }
            case 4: {
                this.xpix = 0;
                this.ypix = 0;
                break;
            }
            case 8: {
                this.xpix = panel.getLeftGutter();
                this.ypix = panel.getTopGutter();
                break;
            }
            case 3: {
                this.xpix = 0;
                this.ypix = panel.getHeight() - this.boxHeight - this.yoffset - 1;
                break;
            }
            case 7: {
                this.xpix = panel.getLeftGutter();
                this.ypix = panel.getHeight() - this.boxHeight - this.yoffset - 1 - panel.getBottomGutter();
                break;
            }
            case 6: {
                this.xpix = panel.getWidth() - this.boxWidth - 1;
                this.ypix = 0;
                break;
            }
            case 10: {
                this.xpix = panel.getWidth() - this.boxWidth - 1 - panel.getRightGutter();
                this.ypix = panel.getTopGutter();
                break;
            }
            case 5: {
                this.xpix = panel.getWidth() - this.boxWidth - 1;
                this.ypix = panel.getHeight() - this.boxHeight - this.yoffset - 1;
                break;
            }
            case 9: {
                this.xpix = panel.getWidth() - this.boxWidth - 1 - panel.getRightGutter();
                this.ypix = panel.getHeight() - this.boxHeight - this.yoffset - 1 - panel.getBottomGutter();
                break;
            }
            default: {
                this.xpix = panel.xToPix(this.x);
                this.ypix = panel.yToPix(this.y);
            }
        }
        int xoffset = this.xoffset;
        int yoffset = this.yoffset;
        if (this.alignment_mode == 1) {
            xoffset -= this.boxWidth / 2;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.color);
        g2.setFont(this.font);
        g2.setClip(0, 0, panel.getWidth(), panel.getHeight());
        g2.setColor(Color.yellow);
        g2.fillRect(this.xpix + xoffset, this.ypix + yoffset, this.boxWidth, this.boxHeight);
        g2.setColor(Color.black);
        g2.drawRect(this.xpix + xoffset, this.ypix + yoffset, this.boxWidth, this.boxHeight);
        g2.drawString(tempText, this.xpix + 3 + xoffset, this.ypix + this.boxHeight - 2 + yoffset);
        g2.dispose();
    }
}

