/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.ResourceLoader;

public class TextFrame
extends JFrame {
    HyperlinkListener hyperlinkListener;
    JTextPane textPane = GUIUtils.newJTextPane();
    JScrollPane textScroller;

    public TextFrame() {
        this((String)null, (Class<?>)null);
    }

    public TextFrame(String resourceName) {
        this(resourceName, (Class<?>)null);
    }

    public TextFrame(String resourceName, Class<?> type) {
        this.setSize(300, 300);
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.setContentPane(this.textScroller);
        if (resourceName != null) {
            this.loadTextResource(resourceName, type);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void enableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        TextFrame.this.textPane.setPage(e.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void enableDesktopHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSPDesktop.displayURL(e.getURL().toString());
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void disableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = null;
    }

    private boolean loadTextResource(String resourceName, Class<?> type) {
        URL url = null;
        try {
            url = ResourceLoader.getTextURL(resourceName, type);
        }
        catch (Exception ex) {
            OSPLog.fine("Error getting resource: " + resourceName);
            return false;
        }
        if (url == null) {
            OSPLog.fine("Resource not found: " + resourceName);
            return false;
        }
        try {
            this.textPane.setPage(url);
        }
        catch (IOException ex) {
            OSPLog.fine("Resource not loadeded: " + resourceName);
            return false;
        }
        this.setTitle(resourceName);
        return true;
    }
}

