/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;

public class TitleText
extends DrawableTextLine {
    public static final int CENTER = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int RIGHT = 4;
    public static final int CUSTOM = 5;
    int location = 3;
    int xoff = 0;
    int yoff = 0;
    boolean dirty = true;

    public TitleText(String text) {
        super(text, 0.0, 0.0);
        this.setFont(new Font("TimesRoman", 1, 14));
        this.setJustification(0);
    }

    public void setOffsets(int xoff, int yoff) {
        this.xoff = xoff;
        this.yoff = yoff;
    }

    public void setLocation(int location) {
        this.location = location;
        switch (location) {
            case 2: 
            case 4: {
                this.theta = 1.5707963267948966;
                break;
            }
            default: {
                this.theta = 0.0;
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.dirty = true;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.dirty = true;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (this.dirty) {
            this.parseText(g);
            this.dirty = false;
        }
        int xpix = 0;
        int ypix = 0;
        switch (this.location) {
            case 0: {
                xpix = panel.getLeftGutter() + (panel.lastWidth - panel.getLeftGutter() - panel.getRightGutter()) / 2;
                ypix = panel.getTopGutter() + (panel.lastHeight - panel.getTopGutter() - panel.getBottomGutter()) / 2;
                break;
            }
            case 1: {
                xpix = panel.getLeftGutter() + (panel.lastWidth - panel.leftGutter - panel.rightGutter) / 2;
                ypix = panel.getBottomGutter() > this.height + this.yoff ? panel.getHeight() - panel.bottomGutter + this.yoff + this.height : panel.getHeight() - panel.bottomGutter - this.yoff;
                break;
            }
            case 2: {
                xpix = panel.leftGutter > this.height + this.xoff ? panel.leftGutter - this.xoff : panel.leftGutter + this.xoff + this.height;
                ypix = panel.getTopGutter() + (panel.lastHeight - panel.getTopGutter() - panel.getBottomGutter()) / 2;
                break;
            }
            default: {
                xpix = panel.getLeftGutter() + (panel.lastWidth - panel.leftGutter - panel.rightGutter) / 2;
                ypix = panel.getTopGutter() > this.ascent + this.yoff ? panel.getTopGutter() - this.yoff - this.descent - 1 : panel.getTopGutter() + this.yoff + this.ascent + 1;
                break;
            }
            case 4: {
                xpix = panel.rightGutter > this.height + this.xoff ? panel.lastWidth - panel.leftGutter + this.xoff + this.height : panel.lastWidth - panel.leftGutter - this.xoff;
                ypix = panel.getTopGutter() + (panel.lastHeight - panel.getTopGutter() - panel.getBottomGutter()) / 2;
                break;
            }
            case 5: {
                xpix = this.xoff;
                ypix = this.yoff;
            }
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle viewRect = panel.getViewRect();
        if (viewRect == null) {
            g2.setClip(0, 0, panel.getWidth(), panel.getHeight());
        } else {
            g2.setClip(viewRect.x, viewRect.y, viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        }
        this.drawText(g, xpix, ypix);
        g2.dispose();
    }
}

