/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TrailBezier;

public class TrailSmart
extends TrailBezier {
    double x1;
    double y1;
    double x2;
    double y2;
    double dx1;
    double dy1;
    double ds1;
    double max_error = 0.001;

    public void setMaxError(double max) {
        this.max_error = max;
    }

    @Override
    public synchronized void addPoint(double x, double y) {
        double dx2 = x - (double)this.endPts[2];
        double dy2 = y - (double)this.endPts[3];
        double ds2 = Math.sqrt(dy2 * dy2 + dx2 * dx2);
        if (this.numpts > 1 && ds2 == 0.0) {
            return;
        }
        double xx = (double)this.endPts[2] + ds2 * this.dx1 / this.ds1;
        double yy = (double)this.endPts[3] + ds2 * this.dy1 / this.ds1;
        double err = Math.sqrt((x - xx) * (x - xx) + (y - yy) * (y - yy));
        double cos = (this.dx1 * dx2 + this.dy1 * dy2) / this.ds1 / ds2;
        if (this.numpts < 3 || err > this.max_error || cos < 0.99 || Double.isNaN(cos)) {
            super.addPoint(x, y);
            this.ds1 = ds2;
            this.dx1 = dx2;
            this.dy1 = dy2;
        }
        this.x1 = this.x2;
        this.y1 = this.y2;
        this.x2 = x;
        this.y2 = y;
    }

    protected void drawPathEnd(DrawingPanel panel, Graphics2D g2) {
        this.pathEnd.reset();
        this.path.moveTo(this.endPts[0], this.endPts[1]);
        this.path.lineTo(this.endPts[2], this.endPts[3]);
        this.path.lineTo((float)this.x1, (float)this.y1);
        this.path.lineTo((float)this.x2, (float)this.y2);
        g2.draw(panel.transformPath(this.pathEnd));
    }

    @Override
    public double getXMin() {
        return Math.min(this.x2, this.xmin);
    }

    @Override
    public double getXMax() {
        return Math.max(this.x2, this.xmax);
    }

    @Override
    public double getYMin() {
        return Math.min(this.y2, this.ymin);
    }

    @Override
    public double getYMax() {
        return Math.max(this.y2, this.ymax);
    }
}

