/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Stack;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.tools.KnownFunction;

public class UncertainFunctionDrawer
extends FunctionDrawer {
    protected GeneralPath upperPath = new GeneralPath();
    protected GeneralPath lowerPath = new GeneralPath();
    protected KnownFunction knownFunction;
    protected boolean uncertain = true;
    protected double[] uncertainties;
    protected double[] paramValues;
    protected double[][] uncertainParams;
    protected double[] multiplier = new double[]{-1.0, 1.0, 0.0};
    protected AlphaComposite composite = AlphaComposite.getInstance(3, 0.1f);

    public UncertainFunctionDrawer(KnownFunction f) {
        super(f);
        this.knownFunction = f;
        this.uncertainties = new double[f.getParameterCount()];
        this.paramValues = new double[f.getParameterCount()];
    }

    public double[] evaluateMinMax(double x, double[] results) {
        int n = this.paramValues.length;
        if (results == null) {
            results = new double[3];
        }
        results[1] = results[2] = this.knownFunction.evaluate(x);
        results[0] = results[2];
        if (this.uncertainParams == null) {
            return results;
        }
        int i = 0;
        while (i < this.uncertainParams.length) {
            int j = 0;
            while (j < n) {
                this.knownFunction.setParameterValue(j, this.uncertainParams[i][j]);
                ++j;
            }
            double y = this.knownFunction.evaluate(x);
            results[0] = Math.min(results[0], y);
            results[2] = Math.max(results[2], y);
            ++i;
        }
        int j = 0;
        while (j < n) {
            this.knownFunction.setParameterValue(j, this.paramValues[j]);
            ++j;
        }
        return results;
    }

    @Override
    protected void checkRange(DrawingPanel panel) {
        if (this.xrange[0] == panel.getXMin() && this.xrange[1] == panel.getXMax() && this.numpts == panel.getWidth() && !this.functionChanged) {
            return;
        }
        if (!this.isUncertain()) {
            super.checkRange(panel);
            return;
        }
        this.functionChanged = false;
        this.xrange[0] = panel.getXMin();
        this.xrange[1] = panel.getXMax();
        this.numpts = panel.getWidth();
        this.generalPath.reset();
        this.upperPath.reset();
        this.lowerPath.reset();
        if (this.numpts < 1) {
            return;
        }
        double[] vals = new double[3];
        int i = 0;
        while (i < this.paramValues.length) {
            this.paramValues[i] = this.knownFunction.getParameterValue(i);
            ++i;
        }
        this.evaluateMinMax(this.xrange[0], vals);
        this.yrange[0] = vals[0];
        this.yrange[1] = vals[2];
        this.lowerPath.moveTo((float)this.xrange[0], (float)vals[0]);
        this.generalPath.moveTo((float)this.xrange[0], (float)vals[1]);
        this.upperPath.moveTo((float)this.xrange[0], (float)vals[2]);
        double x = this.xrange[0];
        double dx = (this.xrange[1] - this.xrange[0]) / (double)this.numpts;
        int i2 = 0;
        while (i2 < this.numpts) {
            this.evaluateMinMax(x += dx, vals);
            double y = vals[1];
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                y = Math.min(y, 1.0E12);
                y = Math.max(y, -1.0E12);
                this.generalPath.lineTo((float)x, (float)y);
                y = vals[0];
                if (!Double.isNaN(y)) {
                    y = Math.min(y, 1.0E12);
                    y = Math.max(y, -1.0E12);
                    this.lowerPath.lineTo((float)x, (float)y);
                    this.yrange[0] = Math.min(this.yrange[0], y);
                }
                if (!Double.isNaN(y = vals[2])) {
                    y = Math.min(y, 1.0E12);
                    y = Math.max(y, -1.0E12);
                    this.upperPath.lineTo((float)x, (float)y);
                    this.yrange[1] = Math.max(this.yrange[1], y);
                }
            }
            ++i2;
        }
        if (this.uncertain) {
            this.lowerPath.append(this.reverse(this.upperPath), true);
            this.lowerPath.closePath();
        }
    }

    private GeneralPath reverse(GeneralPath path) {
        PathIterator iterator = path.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        Stack<Point2D.Double> pts = new Stack<Point2D.Double>();
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            if (type == 0 || type == 1) {
                pts.push(new Point2D.Double(coords[0], coords[1]));
            }
            iterator.next();
        }
        GeneralPath reverse = new GeneralPath();
        Point2D.Double pt = (Point2D.Double)pts.pop();
        reverse.moveTo((float)pt.x, (float)pt.y);
        while (!pts.empty()) {
            pt = (Point2D.Double)pts.pop();
            reverse.lineTo((float)pt.x, (float)pt.y);
        }
        return reverse;
    }

    private boolean isUncertain() {
        if (this.filled || !this.uncertain) {
            return false;
        }
        boolean hasUncertainty = false;
        int i = 0;
        while (i < this.uncertainties.length) {
            hasUncertainty = hasUncertainty || this.uncertainties[i] != 0.0;
            ++i;
        }
        return hasUncertainty;
    }

    public void setUncertain(boolean uncertain) {
        if (uncertain == this.uncertain) {
            return;
        }
        this.uncertain = uncertain;
        this.functionChanged = true;
    }

    public void setUncertainties(double[][] sigmasAndParams) {
        int n = this.uncertainties.length;
        if (sigmasAndParams == null || sigmasAndParams.length < 1 || sigmasAndParams[0].length != n) {
            this.uncertainParams = null;
        } else {
            this.uncertainties = sigmasAndParams[0];
            this.uncertainParams = new double[sigmasAndParams.length - 1][];
            System.arraycopy(sigmasAndParams, 1, this.uncertainParams, 0, this.uncertainParams.length);
        }
        this.functionChanged = true;
    }

    public void clearUncertainties() {
        int i = 0;
        while (i < this.uncertainties.length) {
            this.uncertainties[i] = 0.0;
            this.functionChanged = true;
            ++i;
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.isUncertain()) {
            super.draw(panel, g);
            return;
        }
        if (!this.enabled) {
            return;
        }
        if (!this.measured) {
            this.checkRange(panel);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        Shape s = this.generalPath.createTransformedShape(panel.getPixelTransform());
        g2.draw(s);
        s = this.lowerPath.createTransformedShape(panel.getPixelTransform());
        g2.setComposite(this.composite);
        g2.fill(s);
    }
}

