/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.display.axes.CartesianType2;
import org.opensourcephysics.display.axes.CartesianType3;
import org.opensourcephysics.display.axes.DrawableAxes;

public abstract class AxisFactory {
    static final String axisProperty = "org.opensourcephysics.display.axes.AxisFactory";
    static final String defaultAxisFactoryInstance = "org.opensourcephysics.display.axes.CartesianType1Factory";

    public static AxisFactory newInstance() {
        String axisClass = defaultAxisFactoryInstance;
        try {
            axisClass = System.getProperty(axisProperty);
            if (axisClass == null) {
                axisClass = defaultAxisFactoryInstance;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Class<?> c = Class.forName(axisClass);
            return (AxisFactory)c.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static AxisFactory newInstance(String axisClass) {
        if (axisClass == null) {
            axisClass = defaultAxisFactoryInstance;
        }
        try {
            Class<?> c = Class.forName(axisClass);
            return (AxisFactory)c.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public abstract DrawableAxes createAxes(PlottingPanel var1);

    public static DrawableAxes createAxesType1(PlottingPanel panel) {
        return new CartesianInteractive(panel);
    }

    public static DrawableAxes createAxesType2(PlottingPanel panel) {
        return new CartesianType2(panel);
    }

    public static DrawableAxes createAxesType3(PlottingPanel panel) {
        return new CartesianType3(panel);
    }
}

