/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.ScientificField;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class CartesianInteractive
extends CartesianType1
implements Selectable {
    public static final int INSIDE = 0;
    public static final int HORZ_MIN = 1;
    public static final int HORZ_MAX = 2;
    public static final int VERT_MIN = 3;
    public static final int VERT_MAX = 4;
    public static final int HORZ_AXIS = 5;
    public static final int HORZ_AXIS_MIN = 6;
    public static final int HORZ_AXIS_MAX = 7;
    public static final int VERT_AXIS = 8;
    public static final int VERT_AXIS_MIN = 9;
    public static final int VERT_AXIS_MAX = 10;
    public static final int HORZ_VAR = 11;
    public static final int VERT_VAR = 12;
    Rectangle hitRect = new Rectangle();
    boolean drawHitRect;
    AxisMouseListener axisListener;
    KeyAdapter keyListener;
    int mouseRegion;
    Point mouseLoc;
    double mouseX;
    double mouseY;
    PlottingPanel plot;
    boolean enabled = true;
    boolean altDown;
    Cursor horzCenter;
    Cursor horzRight;
    Cursor horzLeft;
    Cursor vertCenter;
    Cursor vertUp;
    Cursor vertDown;
    Cursor move;
    ScaleSetter scaleSetter;
    JPanel scaleSetterPanel;
    List<ActionListener> axisListeners = new ArrayList<ActionListener>();

    public CartesianInteractive(PlottingPanel panel) {
        super(panel);
        this.plot = panel;
        this.axisListener = new AxisMouseListener();
        panel.addMouseListener(this.axisListener);
        panel.addMouseMotionListener(this.axisListener);
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!CartesianInteractive.this.enabled) {
                    return;
                }
                if (CartesianInteractive.this.mouseRegion == 0 && !CartesianInteractive.this.drawingPanel.isFixedScale() && e.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = true;
                    CartesianInteractive.this.plot.setMouseCursor(CartesianInteractive.this.getPreferredCursor());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!CartesianInteractive.this.enabled) {
                    return;
                }
                if (e.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = false;
                    CartesianInteractive.this.plot.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
            }
        };
        panel.addKeyListener(this.keyListener);
    }

    public int getMouseRegion() {
        return this.mouseRegion;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        super.draw(panel, g);
        if (this.drawHitRect) {
            g.drawRect(this.hitRect.x, this.hitRect.y, this.hitRect.width, this.hitRect.height);
        }
    }

    @Override
    public double getX() {
        return this.plot != null && Double.isNaN(this.mouseX) ? this.plot.pixToX(this.plot.getMouseIntX()) : this.mouseX;
    }

    @Override
    public double getY() {
        return this.plot != null && Double.isNaN(this.mouseY) ? this.plot.pixToY(this.plot.getMouseIntY()) : this.mouseY;
    }

    @Override
    public void setSelected(boolean selectable) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void toggleSelected() {
    }

    @Override
    public Cursor getPreferredCursor() {
        switch (this.mouseRegion) {
            case 6: {
                if (this.horzLeft == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzleft.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzLeft = GUIUtils.createCustomCursor(im, new Point(16, 16), "Horizontal Left", 10);
                }
                return this.horzLeft;
            }
            case 7: {
                if (this.horzRight == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzright.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzRight = GUIUtils.createCustomCursor(im, new Point(16, 16), "Horizontal Right", 11);
                }
                return this.horzRight;
            }
            case 5: {
                if (this.horzCenter == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/horzcenter.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.horzCenter = GUIUtils.createCustomCursor(im, new Point(16, 16), "Horizontal Center", 13);
                }
                return this.horzCenter;
            }
            case 9: {
                if (this.vertDown == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertdown.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertDown = GUIUtils.createCustomCursor(im, new Point(16, 16), "Vertical Down", 9);
                }
                return this.vertDown;
            }
            case 10: {
                if (this.vertUp == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertup.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertUp = GUIUtils.createCustomCursor(im, new Point(16, 16), "Vertical Up", 8);
                }
                return this.vertUp;
            }
            case 8: {
                if (this.vertCenter == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/vertcenter.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.vertCenter = GUIUtils.createCustomCursor(im, new Point(16, 16), "Vertical Center", 13);
                }
                return this.vertCenter;
            }
            case 0: {
                if (this.move == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/movecursor.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.move = GUIUtils.createCustomCursor(im, new Point(16, 16), "Move All Ways", 13);
                }
                return this.move;
            }
            case 11: 
            case 12: {
                return Cursor.getPredefinedCursor(12);
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void addAxisListener(ActionListener listener) {
        this.axisListeners.add(listener);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.drawingPanel.isFixedScale()) {
            return null;
        }
        if (this.mouseRegion >= 1) {
            return this;
        }
        if (this.mouseRegion == -1) {
            return this;
        }
        if (this.mouseRegion == 0 && this.altDown) {
            return this;
        }
        return null;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public boolean isMeasured() {
        return true;
    }

    @Override
    public double getXMin() {
        return this.drawingPanel.getXMin();
    }

    @Override
    public double getXMax() {
        return this.drawingPanel.getXMax();
    }

    @Override
    public double getYMin() {
        return this.drawingPanel.getYMin();
    }

    @Override
    public double getYMax() {
        return this.drawingPanel.getYMax();
    }

    public void hideScaleSetter() {
        if (this.scaleSetter != null && this.scaleSetter.isVisible()) {
            this.scaleSetter.setVisible(false);
            if (this.plot != null) {
                this.plot.repaint();
            }
        }
    }

    @Override
    public void resizeFonts(double factor, DrawingPanel panel) {
        super.resizeFonts(factor, panel);
        if (this.scaleSetter != null) {
            this.scaleSetter.updateFont();
        }
    }

    public void dispose() {
        this.plot.removeMouseListener(this.axisListener);
        this.plot.removeMouseMotionListener(this.axisListener);
        this.plot.removeKeyListener(this.keyListener);
        this.plot = null;
    }

    protected boolean hasHorzVariablesPopup() {
        return false;
    }

    protected JPopupMenu getHorzVariablesPopup() {
        return null;
    }

    protected boolean hasVertVariablesPopup() {
        return false;
    }

    protected JPopupMenu getVertVariablesPopup() {
        return null;
    }

    protected int findRegion(Point p, boolean isPress) {
        int l = this.drawingPanel.getLeftGutter();
        int r = this.drawingPanel.getRightGutter();
        int t = this.drawingPanel.getTopGutter();
        int b = this.drawingPanel.getBottomGutter();
        Dimension plotDim = this.drawingPanel.getSize();
        int reg = -1;
        int axisLen = plotDim.width - r - l;
        this.hitRect.setSize(axisLen / 4, 12);
        this.hitRect.setLocation(l + axisLen / 2 - this.hitRect.width / 2, plotDim.height - b - this.hitRect.height / 2);
        if (this.hitRect.contains(p)) {
            reg = 5;
        } else {
            this.hitRect.setLocation(l + 4, plotDim.height - b - this.hitRect.height / 2);
            if (this.hitRect.contains(p)) {
                reg = 6;
            } else {
                this.hitRect.setLocation(l + axisLen - this.hitRect.width - 4, plotDim.height - b - this.hitRect.height / 2);
                if (this.hitRect.contains(p)) {
                    reg = 7;
                } else {
                    axisLen = plotDim.height - t - b;
                    this.hitRect.setSize(12, axisLen / 4);
                    this.hitRect.setLocation(l - this.hitRect.width / 2, t + axisLen / 2 - this.hitRect.height / 2);
                    if (this.hitRect.contains(p)) {
                        reg = 8;
                    } else {
                        this.hitRect.setLocation(l - this.hitRect.width / 2, t + 4);
                        if (this.hitRect.contains(p)) {
                            reg = 10;
                        } else {
                            this.hitRect.setLocation(l - this.hitRect.width / 2, t + axisLen - this.hitRect.height - 4);
                            if (this.hitRect.contains(p)) {
                                reg = 9;
                            } else {
                                int offset = 0;
                                Graphics g = this.drawingPanel.getGraphics();
                                int xw = this.xLine.getWidth(g) + offset;
                                int xh = this.xLine.getHeight(g);
                                int yw = this.yLine.getHeight(g);
                                int yh = this.yLine.getWidth(g) + offset;
                                g.dispose();
                                this.hitRect.setSize(xw, xh);
                                int x = (int)(this.xLine.getX() - (double)(xw / 2));
                                int y = (int)(this.xLine.getY() - (double)(xh / 2) - (double)(this.xLine.getFontSize() / 3));
                                this.hitRect.setLocation(x, y);
                                if (this.hitRect.contains(p) && this.hasHorzVariablesPopup()) {
                                    reg = 11;
                                } else {
                                    this.hitRect.setSize(yw, yh);
                                    x = (int)(this.yLine.getX() - (double)(yw / 2) - (double)(this.yLine.getFontSize() / 3));
                                    y = (int)(this.yLine.getY() - (double)(yh / 2) - 1.0);
                                    this.hitRect.setLocation(x, y);
                                    if (this.hitRect.contains(p) && this.hasVertVariablesPopup()) {
                                        reg = 12;
                                    } else if (p.x >= l && p.y >= t && p.x <= plotDim.width - r && p.y <= plotDim.height - b) {
                                        reg = 0;
                                    } else {
                                        reg = this.getScaleSetter().findRegion(p, this.hitRect, plotDim, offset, l, r, t, b, isPress);
                                        return reg;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return reg;
    }

    public ScaleSetter getScaleSetter() {
        String s;
        if (this.scaleSetter == null) {
            this.scaleSetter = new ScaleSetter();
            if (this.plot != null) {
                this.plot.getGlassPane().add(this.scaleSetter);
            }
        }
        if (!(s = DialogsRes.SCALE_AUTO).equals(this.scaleSetter.autoscaleCheckbox.getText())) {
            this.scaleSetter.autoscaleCheckbox.setText(s);
        }
        return this.scaleSetter;
    }

    public void refreshDecimalSeparators() {
        this.htFormats.clear();
        if (this.scaleSetter != null) {
            this.scaleSetter.updateValues();
        }
    }

    class AxisMouseListener
    extends MouseInputAdapter {
        AxisMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.altDown = e.isAltDown();
            Point p = e.getPoint();
            CartesianInteractive.this.drawHitRect = false;
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(p, false);
            switch (CartesianInteractive.this.mouseRegion) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (!CartesianInteractive.this.drawingPanel.isFixedScale() && CartesianInteractive.this.scaleSetter != null) {
                        CartesianInteractive.this.getScaleSetter().setRegion(CartesianInteractive.this.mouseRegion);
                        CartesianInteractive.this.scaleSetter.setVisible(true);
                    }
                    return;
                }
                case 11: 
                case 12: {
                    CartesianInteractive.this.drawHitRect = true;
                    break;
                }
            }
            if (CartesianInteractive.this.scaleSetter != null) {
                CartesianInteractive.this.scaleSetter.hideIfInactive();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            double dx = 0.0;
            double dy = 0.0;
            double min = 0.0;
            double max = 0.0;
            switch (CartesianInteractive.this.mouseRegion) {
                case 0: {
                    if (!CartesianInteractive.this.altDown || CartesianInteractive.this.drawingPanel.isFixedScale()) {
                        return;
                    }
                    dx = (double)(CartesianInteractive.this.mouseLoc.x - e.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    dx = 0.0;
                    CartesianInteractive.this.plot.setPreferredMinMaxX(min, max);
                    dy = (double)(e.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                    break;
                }
                case 5: {
                    dx = (double)(CartesianInteractive.this.mouseLoc.x - e.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    break;
                }
                case 6: {
                    dx = (double)(2 * (CartesianInteractive.this.mouseLoc.x - e.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.getXMin() + dx;
                    max = CartesianInteractive.this.plot.isAutoscaleXMax() ? Double.NaN : CartesianInteractive.this.plot.getXMax();
                    break;
                }
                case 7: {
                    dx = (double)(2 * (CartesianInteractive.this.mouseLoc.x - e.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    min = CartesianInteractive.this.plot.isAutoscaleXMin() ? Double.NaN : CartesianInteractive.this.plot.getXMin();
                    max = CartesianInteractive.this.plot.getXMax() + dx;
                    break;
                }
                case 8: {
                    dy = (double)(e.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                    break;
                }
                case 9: {
                    dy = (double)(2 * (e.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.getYMin() + dy;
                    max = CartesianInteractive.this.plot.isAutoscaleYMax() ? Double.NaN : CartesianInteractive.this.plot.getYMax();
                    break;
                }
                case 10: {
                    dy = (double)(2 * (e.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    min = CartesianInteractive.this.plot.isAutoscaleYMin() ? Double.NaN : CartesianInteractive.this.plot.getYMin();
                    max = CartesianInteractive.this.plot.getYMax() + dy;
                }
            }
            if (dx != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxX(min, max);
            } else if (dy != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxY(min, max);
            }
            for (ActionListener listener : CartesianInteractive.this.axisListeners) {
                listener.actionPerformed(new ActionEvent(CartesianInteractive.this, e.getID(), "axis dragged"));
            }
            CartesianInteractive.this.plot.invalidateImage();
            CartesianInteractive.this.plot.repaint();
            CartesianInteractive.this.mouseLoc = e.getPoint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.plot.requestFocusInWindow();
            CartesianInteractive.this.altDown = e.isAltDown();
            CartesianInteractive.this.mouseLoc = e.getPoint();
            CartesianInteractive.this.mouseX = CartesianInteractive.this.plot.pixToX(CartesianInteractive.this.plot.getMouseIntX());
            CartesianInteractive.this.mouseY = CartesianInteractive.this.plot.pixToY(CartesianInteractive.this.plot.getMouseIntY());
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(CartesianInteractive.this.mouseLoc, true);
            switch (CartesianInteractive.this.mouseRegion) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (CartesianInteractive.this.scaleSetter != null && !CartesianInteractive.this.drawingPanel.isFixedScale()) {
                        CartesianInteractive.this.scaleSetter.setVisible(true);
                    }
                    return;
                }
                case 11: {
                    CartesianInteractive.this.drawHitRect = false;
                    CartesianInteractive.this.getHorzVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
                    break;
                }
                case 12: {
                    CartesianInteractive.this.drawHitRect = false;
                    CartesianInteractive.this.getVertVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
                    break;
                }
            }
            CartesianInteractive.this.plot.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            CartesianInteractive.this.mouseX = Double.NaN;
            CartesianInteractive.this.mouseY = Double.NaN;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!CartesianInteractive.this.enabled) {
                return;
            }
            Point p = e.getPoint();
            Rectangle rect = new Rectangle(CartesianInteractive.this.plot.getSize());
            if (!rect.contains(p) && CartesianInteractive.this.scaleSetter != null && "".equals(InputEvent.getModifiersExText(e.getModifiersEx()))) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }
    }

    public class ScaleSetter
    extends JPanel {
        Action scaleAction;
        JCheckBox autoscaleCheckbox;
        int region;
        boolean pinned;
        private String text;
        private String constraint;
        private Dimension size;
        private boolean paintDisabled;
        ScientificField scaleField;
        Dimension fieldDim;

        private ScaleSetter() {
            super(new BorderLayout());
            this.pinned = false;
            this.scaleField = new ScientificField(6, 3){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width -= 4;
                    return dim;
                }
            };
            this.fieldDim = this.scaleField.getPreferredSize();
            this.scaleAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double min;
                    ScaleSetter.this.scaleField.setBackground(Color.white);
                    ScaleSetter.this.pinned = false;
                    boolean auto = ScaleSetter.this.autoscaleCheckbox.isSelected();
                    boolean horzAxis = true;
                    double max = min = auto ? Double.NaN : ScaleSetter.this.scaleField.getValue();
                    switch (ScaleSetter.this.region) {
                        default: {
                            return;
                        }
                        case 1: {
                            max = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMax();
                            break;
                        }
                        case 2: {
                            min = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMin();
                            break;
                        }
                        case 3: {
                            horzAxis = false;
                            max = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMax();
                            break;
                        }
                        case 4: {
                            horzAxis = false;
                            double d = min = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMin();
                        }
                    }
                    if (horzAxis) {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxX(min, max);
                    } else {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxY(min, max);
                    }
                    ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.paintImmediately(0, 0, ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getWidth(), ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getHeight());
                    ScaleSetter.this.updateValues();
                }
            };
            this.autoscaleCheckbox = new JCheckBox();
            this.autoscaleCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 1));
            this.autoscaleCheckbox.setBackground(CartesianInteractive.this.drawingPanel.getBackground());
            this.autoscaleCheckbox.setHorizontalTextPosition(4);
            this.autoscaleCheckbox.addActionListener(this.scaleAction);
            this.scaleField.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                    ScaleSetter.this.scaleAction.actionPerformed(null);
                }
            });
            this.scaleField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (ScaleSetter.this.scaleField.getBackground() == Color.yellow) {
                        ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                        ScaleSetter.this.scaleAction.actionPerformed(null);
                    }
                }
            });
            this.scaleField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ScaleSetter.this.pinned = true;
                    if (e.getClickCount() == 2) {
                        ScaleSetter.this.scaleField.selectAll();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (ScaleSetter.this.pinned) {
                        return;
                    }
                    Point p = e.getPoint();
                    Point loc = ScaleSetter.this.scaleField.getLocation();
                    p.x += loc.x;
                    p.y += loc.y;
                    Rectangle rect = new Rectangle(((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.scaleSetter.getSize());
                    if (!rect.contains(p)) {
                        ScaleSetter.this.hideIfInactive();
                    }
                }
            });
            this.add((Component)this.scaleField, "Center");
            this.updateFont();
        }

        public int findRegion(Point p, Rectangle hitRect, Dimension plotDim, int offset, int l, int r, int t, int b, boolean isPress) {
            double xmin = CartesianInteractive.this.drawingPanel.getXMin();
            double xmax = CartesianInteractive.this.drawingPanel.getXMax();
            double ymin = CartesianInteractive.this.drawingPanel.getYMin();
            double ymax = CartesianInteractive.this.drawingPanel.getYMax();
            hitRect.setSize(this.fieldDim);
            hitRect.setLocation(l - 12, plotDim.height - b + 6 + offset);
            if (hitRect.contains(p)) {
                if (isPress) {
                    this.scaleField.setExpectedRange(xmin, xmax);
                }
                this.set(offset, "North", 1);
                return 1;
            }
            hitRect.setLocation(plotDim.width - r - this.fieldDim.width + 12, plotDim.height - b + 6 + offset);
            if (hitRect.contains(p)) {
                if (isPress) {
                    this.scaleField.setExpectedRange(xmin, xmax);
                }
                this.set(offset, "North", 2);
                return 2;
            }
            hitRect.setLocation(l - this.fieldDim.width - 1 - offset, plotDim.height - b - this.fieldDim.height + 8);
            if (hitRect.contains(p)) {
                if (isPress) {
                    this.scaleField.setExpectedRange(ymin, ymax);
                }
                this.set(offset, "East", 3);
                return 3;
            }
            hitRect.setLocation(l - this.fieldDim.width - 1 - offset, t - 8);
            if (hitRect.contains(p)) {
                if (isPress) {
                    this.scaleField.setExpectedRange(ymin, ymax);
                }
                this.set(offset, "East", 4);
                return 4;
            }
            return -1;
        }

        public void updateFont() {
            this.text = null;
            this.constraint = null;
            FontSizer.setFont(this);
            FontSizer.setFont(this.autoscaleCheckbox);
        }

        public void updateValues() {
            if (this.scaleField.getBackground() == Color.yellow) {
                return;
            }
            this.scaleField.refreshDecimalSeparators(false);
            switch (this.region) {
                case 1: {
                    this.scaleField.setValue(CartesianInteractive.this.drawingPanel.getXMin());
                    this.autoscaleCheckbox.setSelected(CartesianInteractive.this.drawingPanel.isAutoscaleXMin());
                    break;
                }
                case 2: {
                    this.scaleField.setValue(CartesianInteractive.this.drawingPanel.getXMax());
                    this.autoscaleCheckbox.setSelected(CartesianInteractive.this.drawingPanel.isAutoscaleXMax());
                    break;
                }
                case 3: {
                    this.scaleField.setValue(CartesianInteractive.this.drawingPanel.getYMin());
                    this.autoscaleCheckbox.setSelected(CartesianInteractive.this.drawingPanel.isAutoscaleYMin());
                    break;
                }
                case 4: {
                    this.scaleField.setValue(CartesianInteractive.this.drawingPanel.getYMax());
                    this.autoscaleCheckbox.setSelected(CartesianInteractive.this.drawingPanel.isAutoscaleYMax());
                }
            }
            this.scaleField.select(20, 20);
            this.scaleField.requestFocusInWindow();
        }

        public void set(int offset, String constraint, int region) {
            String text = this.scaleField.getText();
            boolean doValidate = false;
            if (this.constraint != constraint) {
                this.add((Component)this.autoscaleCheckbox, constraint);
                doValidate = true;
            } else if (!text.equals(this.text)) {
                doValidate = true;
            }
            if (doValidate) {
                this.size = this.getPreferredSize();
                this.validate();
            }
            this.text = text;
            this.constraint = constraint;
            Point fieldLoc = this.scaleField.getLocation();
            Point hitLoc = CartesianInteractive.this.hitRect.getLocation();
            switch (region) {
                case 1: {
                    this.setBounds(hitLoc.x - fieldLoc.x, hitLoc.y - fieldLoc.y - offset, this.size.width, this.size.height);
                    break;
                }
                case 2: {
                    this.setBounds(hitLoc.x - fieldLoc.x, hitLoc.y - fieldLoc.y - offset, this.size.width, this.size.height);
                    break;
                }
                case 3: {
                    this.setBounds(Math.max(hitLoc.x, 1) - fieldLoc.x, hitLoc.y - fieldLoc.y, this.size.width, this.size.height);
                    break;
                }
                case 4: {
                    this.setBounds(Math.max(hitLoc.x, 1) - fieldLoc.x, hitLoc.y - fieldLoc.y, this.size.width, this.size.height);
                }
            }
        }

        @Override
        public void setVisible(boolean b) {
            this.paintDisabled = false;
            if (b) {
                this.updateValues();
            }
            super.setVisible(b);
        }

        void hideIfInactive() {
            if (this.scaleField.getBackground() != Color.yellow && this.scaleField.getSelectedText() == null && !this.pinned) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }

        void setRegion(int mouseRegion) {
            if (this.region != mouseRegion) {
                this.autoscaleCheckbox.requestFocusInWindow();
                if (this.scaleField.getBackground() == Color.yellow) {
                    this.autoscaleCheckbox.setSelected(false);
                    this.scaleAction.actionPerformed(null);
                }
                this.region = mouseRegion;
                this.pinned = false;
            }
        }
    }
}

