/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPanel;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.tools.FontSizer;

public class CartesianType1
extends AbstractAxes
implements CartesianAxes,
Dimensioned {
    double yMax;
    double yMin;
    double xMax;
    double xMin;
    boolean xlog = false;
    boolean ylog = false;
    static final double LOG10SCALE = 1.0 / Math.log(10.0);
    double ytickMax;
    double ytickMin;
    double xtickMax;
    double xtickMin;
    int yExponent;
    int xExponent;
    FontMetrics labelFontMetrics = null;
    FontMetrics superscriptFontMetrics = null;
    FontMetrics titleFontMetrics = null;
    int gridCurJuke = 0;
    double gridBase;
    protected DrawableTextLine xLine = new DrawableTextLine("x", 0.0, 0.0);
    protected DrawableTextLine yLine = new DrawableTextLine("y", 0.0, 0.0);
    ArrayList<Double> xticks = null;
    ArrayList<Double> yticks = null;
    ArrayList<String> xticklabels = null;
    ArrayList<String> yticklabels = null;
    DecimalFormat numberFormat = new DecimalFormat();
    DecimalFormat scientificFormat = new DecimalFormat("0.0E0");
    boolean drawMajorXGrid = true;
    boolean drawMinorXGrid = false;
    boolean drawMajorYGrid = true;
    boolean drawMinorYGrid = false;
    private int topGutter = 25;
    private int bottomGutter = 45;
    private int leftGutter = 45;
    private int rightGutter = 25;
    private int tickLength = 5;
    private boolean adjustGutters = true;
    protected Hashtable<String, String> htFormats = new Hashtable();

    public CartesianType1(PlottingPanel panel) {
        super(panel);
        this.defaultTopGutter = this.topGutter;
        this.defaultBottomGutter = this.bottomGutter;
        this.defaultLeftGutter = this.leftGutter;
        this.defaultRightGutter = this.rightGutter;
        this.labelFont = new Font("Dialog", 0, 12);
        this.superscriptFont = new Font("Dialog", 0, 9);
        this.xLine.setJustification(0);
        this.xLine.setFont(this.labelFont);
        this.xLine.setPixelXY(true);
        this.yLine.setJustification(0);
        this.yLine.setFont(this.labelFont);
        this.yLine.setTheta(1.5707963267948966);
        this.yLine.setPixelXY(true);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.titleLine.setPixelXY(true);
        if (panel == null) {
            return;
        }
        panel.setPreferredGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
        this.measureFonts(panel);
        panel.setAxes(this);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), panel);
    }

    private int xToPix(double x, DrawingPanel panel) {
        double[] pixelMatrix = panel.getPixelMatrix();
        double pix = pixelMatrix[0] * x + pixelMatrix[4];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    private int yToPix(double y, DrawingPanel panel) {
        double[] pixelMatrix = panel.getPixelMatrix();
        double pix = pixelMatrix[3] * y + pixelMatrix[5];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    private int getLeftGutter(DrawingPanel panel) {
        int gutter = 40;
        if (this.ylog) {
            return gutter + 10;
        }
        int height = panel.getHeight() - this.topGutter - this.bottomGutter;
        int numberYTickMarks = 2 + height / (this.labelFontMetrics.getHeight() + 10);
        numberYTickMarks = (int)((double)numberYTickMarks / panel.getImageRatio());
        double yTickSize = this.roundUp((this.ytickMax - this.ytickMin) / (double)numberYTickMarks);
        double yStart = yTickSize * Math.ceil(this.ytickMin / yTickSize);
        int numfracdigits = this.numFracDigits(yTickSize);
        double chop = Math.abs(yTickSize / 100.0);
        if (yTickSize == 0.0 || Math.abs((this.ytickMax - yStart) / yTickSize) > 50.0) {
            return gutter;
        }
        double ypos = yStart;
        int sh = this.labelFontMetrics.getHeight();
        int i = 0;
        while (i <= numberYTickMarks) {
            String yticklabel = this.formatNum(ypos, numfracdigits, chop);
            int sw = this.labelFontMetrics.stringWidth(yticklabel);
            gutter = Math.max(sw + 2 * sh, gutter);
            ypos += yTickSize;
            ++i;
        }
        return Math.min(gutter, panel.getWidth());
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        double temp;
        if (!this.visible) {
            return;
        }
        this.topGutter = panel.getTopGutter();
        this.bottomGutter = panel.getBottomGutter();
        this.leftGutter = panel.getLeftGutter();
        this.rightGutter = panel.getRightGutter();
        this.yMax = panel.getYMax();
        this.yMin = panel.getYMin();
        this.xMax = panel.getXMax();
        this.xMin = panel.getXMin();
        if (this.xMax < this.xMin) {
            temp = this.xMax;
            this.xMax = this.xMin;
            this.xMin = temp;
        }
        if (this.yMax < this.yMin) {
            temp = this.yMax;
            this.yMax = this.yMin;
            this.yMin = temp;
        }
        this.setXRange(this.xMin, this.xMax);
        this.setYRange(this.yMin, this.yMax);
        if (this.adjustGutters) {
            this.leftGutter = Math.max(this.leftGutter, this.getLeftGutter(panel));
            if (this.leftGutter != panel.getLeftGutter()) {
                panel.setGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
            }
            panel.setPixelScale();
        }
        this.numberFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        this.scientificFormat.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        this.drawPlot(panel, g);
    }

    public void addXTick(String label, double position) {
        if (this.xticks == null) {
            this.xticks = new ArrayList();
            this.xticklabels = new ArrayList();
        }
        this.xticks.add(new Double(position));
        this.xticklabels.add(label);
    }

    public void addYTick(String label, double position) {
        if (this.yticks == null) {
            this.yticks = new ArrayList();
            this.yticklabels = new ArrayList();
        }
        this.yticks.add(new Double(position));
        this.yticklabels.add(label);
    }

    public void setLabelFont(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        this.labelFont = Font.decode(name);
    }

    @Override
    public void setTitle(String title, String font_name) {
        this.titleLine.setText(title);
        if (font_name == null || font_name.equals("")) {
            this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), this.drawingPanel);
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
        this.setTitleFont(font_name);
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), this.drawingPanel);
    }

    public void setTitleFont(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        this.titleFont = Font.decode(name);
        this.titleLine.setFont(this.titleFont);
    }

    @Override
    public void setXLabel(String label, String font_name) {
        this.xLine.setText(label);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.xLine.setFont(Font.decode(font_name));
        this.setLabelFont(font_name);
    }

    @Override
    public void setXLog(boolean xlog) {
        this.xlog = xlog;
    }

    @Override
    public void setYLabel(String label, String font_name) {
        this.yLine.setText(label);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.yLine.setFont(Font.decode(font_name));
        this.setLabelFont(font_name);
    }

    @Override
    public void setYLog(boolean ylog) {
        this.ylog = ylog;
    }

    @Override
    public String getTitle() {
        return this.titleLine.getText();
    }

    @Override
    public String getXLabel() {
        return this.xLine.getText();
    }

    @Override
    public boolean isXLog() {
        return this.xlog;
    }

    @Override
    public String getYLabel() {
        return this.yLine.getText();
    }

    @Override
    public boolean isYLog() {
        return this.ylog;
    }

    @Override
    public void resizeFonts(double factor, DrawingPanel panel) {
        super.resizeFonts(factor, panel);
        if (this.xLine == null) {
            return;
        }
        this.xLine.setFont(this.labelFont);
        this.yLine.setFont(this.labelFont);
        int left = (int)((double)this.defaultLeftGutter * factor);
        int bottom = (int)((double)this.defaultBottomGutter * factor);
        int top = (int)((double)this.defaultTopGutter * (1.0 + factor) / 2.0);
        if (this.getTitle() != null && !this.getTitle().equals("")) {
            top = (int)((double)this.defaultTopGutter * factor);
        }
        int right = (int)((double)this.defaultRightGutter * (1.0 + factor) / 2.0);
        panel.setPreferredGutters(left, top, right, bottom);
        this.measureFonts(panel);
    }

    public int getTickLength() {
        return this.tickLength;
    }

    protected void drawPlot(DrawingPanel panel, Graphics graphics) {
        int titlefontheight;
        Color foreground = panel.getForeground();
        int panelHeight = panel.getHeight();
        int panelWidth = panel.getWidth();
        graphics = graphics.create();
        graphics.clipRect(0, 0, panelWidth, panelHeight);
        graphics.setFont(this.labelFont);
        graphics.setColor(foreground);
        int lrx = panelWidth - this.rightGutter;
        int lry = panelHeight - this.bottomGutter;
        int vSpaceForTitle = titlefontheight = this.titleFontMetrics.getHeight();
        int labelheight = this.labelFontMetrics.getHeight();
        int halflabelheight = labelheight / 2;
        int yStartPosition = panelHeight - 5;
        int xStartPosition = panelWidth - 5 - OSPRuntime.macOffset;
        if (this.xlog) {
            this.xExponent = (int)Math.floor(this.xtickMin);
        }
        if (this.xExponent != 0 && this.xticks == null) {
            String superscript = Integer.toString(this.xExponent);
            xStartPosition -= this.superscriptFontMetrics.stringWidth(superscript);
            graphics.setFont(this.superscriptFont);
            if (!this.xlog) {
                graphics.drawString(superscript, xStartPosition, yStartPosition - halflabelheight);
                graphics.setFont(this.labelFont);
                graphics.drawString("x 10", xStartPosition -= this.labelFontMetrics.stringWidth("x 10"), yStartPosition);
            }
        }
        int height = panelHeight - this.topGutter - this.bottomGutter;
        int numberYTickMarks = 2 + height / (labelheight + 10);
        numberYTickMarks = (int)((double)numberYTickMarks / panel.getImageRatio());
        double yTickSize = this.roundUp((this.ytickMax - this.ytickMin) / (double)numberYTickMarks);
        double yStart = yTickSize * Math.ceil(this.ytickMin / yTickSize);
        int width = panelWidth - this.rightGutter - this.leftGutter;
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            graphics.fillRect(this.leftGutter, this.topGutter, width, height);
        }
        int xCoord1 = this.leftGutter + this.getTickLength();
        int xCoord2 = lrx - Math.abs(this.tickLength);
        int numfracdigits = this.numFracDigits(yTickSize);
        int yTickWidth = 12;
        if (this.yticks == null) {
            ArrayList<Double> ygrid = null;
            double yTmpStart = yStart;
            if (this.ylog) {
                ygrid = this.gridInit(yStart, yTickSize, true, null);
                yTmpStart = this.gridStep(ygrid, yStart, yTickSize, this.ylog);
            }
            boolean needExponent = this.ylog;
            boolean firstIteration = true;
            graphics.setColor(foreground);
            double chop = Math.abs(yTickSize / 100.0);
            int counter = numberYTickMarks;
            double ypos = yTmpStart;
            while (ypos <= this.ytickMax) {
                if (--counter < 0) break;
                String yticklabel = null;
                if (this.ylog) {
                    yticklabel = this.formatLogNum(ypos, numfracdigits);
                    if (yticklabel.indexOf(101) != -1) {
                        needExponent = false;
                    }
                } else {
                    yticklabel = this.formatNum(ypos, numfracdigits, chop);
                }
                int yCoord1 = 0;
                yCoord1 = this.ylog || this.yExponent == 0 ? this.yToPix(ypos, panel) : this.yToPix(ypos * Math.pow(10.0, this.yExponent), panel);
                int offset = labelheight / 4;
                if (firstIteration && !this.ylog) {
                    firstIteration = false;
                    offset = 0;
                }
                if (this.drawMajorYGrid && yCoord1 >= this.topGutter && yCoord1 <= lry) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                    graphics.setColor(foreground);
                }
                graphics.drawLine(this.leftGutter, yCoord1, xCoord1, yCoord1);
                graphics.drawLine(width + this.leftGutter - 1, yCoord1, xCoord2, yCoord1);
                int labelWidth = this.labelFontMetrics.stringWidth(yticklabel);
                graphics.drawString(yticklabel, this.leftGutter - labelWidth - 4, yCoord1 + offset);
                int sw = this.labelFontMetrics.stringWidth(yticklabel);
                yTickWidth = Math.max(yTickWidth, sw);
                ypos = this.gridStep(ygrid, ypos, yTickSize, this.ylog);
            }
            if (this.ylog || this.drawMinorYGrid) {
                ArrayList<Double> unlabeledgrid = this.gridInit(yStart, yTickSize, false, ygrid);
                if (unlabeledgrid.size() > 0) {
                    double tmpStep = yTickSize > 1.0 ? 1.0 : yTickSize;
                    double ypos2 = this.gridStep(unlabeledgrid, yStart, tmpStep, this.ylog);
                    while (ypos2 <= this.ytickMax) {
                        int yCoord1 = this.yToPix(ypos2, panel);
                        if (yCoord1 != this.topGutter && yCoord1 != lry) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(this.leftGutter + 1, yCoord1, lrx - 1, yCoord1);
                            graphics.setColor(foreground);
                        }
                        ypos2 = this.gridStep(unlabeledgrid, ypos2, tmpStep, this.ylog);
                    }
                }
                this.yExponent = needExponent ? (int)Math.floor(yTmpStart) : 0;
            }
            if (this.yExponent != 0) {
                graphics.drawString("x 10", 2, vSpaceForTitle);
                graphics.setFont(this.superscriptFont);
                graphics.drawString(Integer.toString(this.yExponent), this.labelFontMetrics.stringWidth("x 10") + 2, vSpaceForTitle - halflabelheight);
                graphics.setFont(this.labelFont);
            }
        } else {
            Iterator<Double> nt = this.yticks.iterator();
            for (String label : this.yticklabels) {
                int sw = this.labelFontMetrics.stringWidth(label);
                yTickWidth = Math.max(yTickWidth, sw);
                double ypos = nt.next();
                if (ypos > this.yMax || ypos < this.yMin) continue;
                int yCoord1 = this.yToPix(ypos * Math.pow(10.0, this.yExponent), panel);
                int offset = 0;
                if (ypos < (double)(lry - labelheight)) {
                    offset = halflabelheight;
                }
                graphics.drawLine(this.leftGutter, yCoord1, xCoord1, yCoord1);
                graphics.drawLine(width + this.leftGutter - 1, yCoord1, xCoord2, yCoord1);
                if (this.drawMajorYGrid && yCoord1 >= this.topGutter && yCoord1 <= lry) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                    graphics.setColor(foreground);
                }
                graphics.drawString(label, this.leftGutter - this.labelFontMetrics.stringWidth(label) - 3, yCoord1 + offset);
            }
        }
        int yCoord1 = this.topGutter + Math.abs(this.tickLength);
        int yCoord2 = lry - this.tickLength;
        int charwidth = this.labelFontMetrics.stringWidth("8");
        if (this.xticks == null) {
            int numberXTickMarks = 10;
            numberXTickMarks = (int)((double)numberXTickMarks / panel.getImageRatio());
            double xTickSize = 0.0;
            numfracdigits = 0;
            if (this.xlog) {
                numberXTickMarks = 4 + width / (charwidth * 6 + 10);
                numberXTickMarks = (int)((double)numberXTickMarks / panel.getImageRatio());
            } else {
                int count = 0;
                while (count++ <= 10) {
                    int inttemp;
                    xTickSize = this.roundUp((this.xtickMax - this.xtickMin) / (double)numberXTickMarks);
                    numfracdigits = this.numFracDigits(xTickSize);
                    int intdigits = this.numIntDigits(this.xtickMax);
                    if (intdigits < (inttemp = this.numIntDigits(this.xtickMin))) {
                        intdigits = inttemp;
                    }
                    int maxlabelwidth = charwidth * (numfracdigits + 2 + intdigits);
                    int savenx = numberXTickMarks;
                    numberXTickMarks = 2 + width / (maxlabelwidth + 10);
                    if ((numberXTickMarks = (int)((double)numberXTickMarks / panel.getImageRatio())) - savenx <= 1 || savenx - numberXTickMarks <= 1) break;
                }
            }
            xTickSize = this.xlog ? this.roundUp(0.8 * (this.xtickMax - this.xtickMin) / (double)numberXTickMarks) : this.roundUp((this.xtickMax - this.xtickMin) / (double)numberXTickMarks);
            numfracdigits = this.numFracDigits(xTickSize);
            double xStart = xTickSize * Math.ceil(this.xtickMin / xTickSize);
            ArrayList<Double> xgrid = null;
            double xTmpStart = xStart;
            if (this.xlog) {
                xStart = xTickSize * Math.floor(this.xtickMin / xTickSize);
                xgrid = this.gridInit(xStart, xTickSize, true, null);
                xTmpStart = this.gridRoundUp(xgrid, xStart);
            }
            boolean needExponent = this.xlog;
            graphics.setColor(foreground);
            double chop = Math.abs(yTickSize / 100.0);
            int counter = numberXTickMarks;
            double xpos = xTmpStart;
            while (xpos <= this.xtickMax) {
                if (--counter < 0) break;
                String xticklabel = null;
                boolean hasExponent = false;
                if (this.xlog) {
                    xticklabel = this.formatLogNum(xpos, numfracdigits);
                    if (xticklabel.indexOf(101) != -1) {
                        needExponent = false;
                        hasExponent = true;
                    }
                } else {
                    xticklabel = this.formatNum(xpos, numfracdigits, chop);
                }
                xCoord1 = this.xlog || this.xExponent == 0 ? this.xToPix(xpos, panel) : this.xToPix(xpos * Math.pow(10.0, this.xExponent), panel);
                graphics.drawLine(xCoord1, this.topGutter, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, height + this.topGutter - 1, xCoord1, yCoord2);
                if (this.drawMajorXGrid && xCoord1 >= this.leftGutter && xCoord1 <= lrx) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                    graphics.setColor(foreground);
                }
                graphics.drawLine(xCoord1, lry, xCoord1, yCoord2);
                int labxpos = xCoord1 - this.labelFontMetrics.stringWidth(xticklabel) / 2;
                if (hasExponent) {
                    graphics.drawString(xticklabel, labxpos + 7, lry + 3 + labelheight);
                } else {
                    graphics.drawString(xticklabel, labxpos, lry + 3 + labelheight);
                }
                xpos = this.gridStep(xgrid, xpos, xTickSize, this.xlog);
            }
            if (this.xlog || this.drawMinorXGrid) {
                double tmpStep = xTickSize > 1.0 ? 1.0 : xTickSize;
                xTmpStart = tmpStep * Math.ceil(this.xtickMin / tmpStep);
                ArrayList<Double> unlabeledgrid = this.gridInit(xTmpStart, tmpStep, false, xgrid);
                if (unlabeledgrid.size() > 0) {
                    double xpos2 = this.gridStep(unlabeledgrid, xTmpStart, tmpStep, this.xlog);
                    while (xpos2 <= this.xtickMax) {
                        xCoord1 = this.xToPix(xpos2, panel);
                        if (xCoord1 != this.leftGutter && xCoord1 != lrx) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(xCoord1, this.topGutter + 1, xCoord1, lry - 1);
                            graphics.setColor(foreground);
                        }
                        xpos2 = this.gridStep(unlabeledgrid, xpos2, tmpStep, this.xlog);
                    }
                }
                if (needExponent) {
                    this.xExponent = (int)Math.floor(xTmpStart);
                    graphics.setFont(this.superscriptFont);
                    graphics.drawString(Integer.toString(this.xExponent), xStartPosition, yStartPosition - halflabelheight);
                    graphics.setFont(this.labelFont);
                    graphics.drawString("x 10", xStartPosition -= this.labelFontMetrics.stringWidth("x 10"), yStartPosition);
                } else {
                    this.xExponent = 0;
                }
            }
        } else {
            Iterator<Double> nt = this.xticks.iterator();
            Iterator<String> nl = this.xticklabels.iterator();
            double preLength = 0.0;
            while (nl.hasNext()) {
                int labxpos;
                String label = nl.next();
                double xpos = nt.next();
                if (xpos > this.xMax || xpos < this.xMin || !((double)(labxpos = (xCoord1 = this.xToPix(xpos * Math.pow(10.0, this.xExponent), panel)) - this.labelFontMetrics.stringWidth(label) / 2) > preLength)) continue;
                preLength = xCoord1 + this.labelFontMetrics.stringWidth(label) / 2 + 10;
                graphics.drawString(label, labxpos, lry + 3 + labelheight);
                if (this.drawMajorXGrid && xCoord1 >= this.leftGutter && xCoord1 <= lrx) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                }
                graphics.setColor(foreground);
                graphics.drawLine(xCoord1, this.topGutter, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, height + this.topGutter - 1, xCoord1, yCoord2);
            }
        }
        graphics.setColor(foreground);
        if (this.titleLine != null) {
            this.titleLine.setX(panel.getLeftGutter() / 2 + (panel.getWidth() - panel.getRightGutter()) / 2);
            if ((double)panel.getTopGutter() > 1.2 * (double)this.labelFontMetrics.getHeight()) {
                this.titleLine.setY((double)panel.getTopGutter() - 0.6 * (double)this.labelFontMetrics.getHeight());
            } else {
                this.titleLine.setY((double)panel.getTopGutter() + 1.5 * (double)this.labelFontMetrics.getHeight());
            }
            this.titleLine.setColor(foreground);
            this.titleLine.draw(panel, graphics);
        }
        if (this.xLine != null) {
            double mid = (double)this.leftGutter / 2.0 + (double)(panel.getWidth() - this.rightGutter) / 2.0;
            this.xLine.setX(mid);
            int yoff = panel.getBottomGutter() - 2 * this.labelFontMetrics.getHeight();
            this.xLine.setY(panel.getHeight() - Math.max(0, yoff));
            this.xLine.setColor(foreground);
            this.xLine.draw(panel, graphics);
        }
        if (this.yLine != null) {
            double mid = (double)this.topGutter / 2.0 + (double)((panel.getHeight() - this.bottomGutter) / 2);
            this.yLine.setY(mid);
            double x = (double)(panel.getLeftGutter() - yTickWidth) - 0.7 * (double)this.labelFontMetrics.getHeight();
            this.yLine.setX(Math.max(12.0, x));
            this.yLine.setColor(foreground);
            this.yLine.draw(panel, graphics);
        }
        graphics.setColor(foreground);
        graphics.drawRect(this.leftGutter, this.topGutter, width - 1, height - 1);
        graphics.dispose();
    }

    private String formatLogNum(double num, int numfracdigits) {
        int exponent = (int)num;
        String results = exponent >= 0 && exponent < 10 ? "0" + exponent : (exponent < 0 && exponent > -10 ? "-0" + -exponent : Integer.toString(exponent));
        results = num >= 0.0 ? (num - (double)((int)num) < 0.001 ? "1e" + results : this.formatNum(Math.pow(10.0, num - (double)((int)num)), numfracdigits, 1.4E-45f)) : (-num - (double)((int)(-num)) < 0.001 ? "1e" + results : this.formatNum(Math.pow(10.0, num - (double)((int)num)) * 10.0, numfracdigits, 1.4E-45f));
        return results;
    }

    private String formatNum(double num, int numfracdigits, double chop) {
        DecimalFormat numberFormat;
        if (num == 0.0) {
            return "0";
        }
        String key = numfracdigits + " " + chop + " " + num;
        String val = this.htFormats.get(key);
        if (val != null) {
            return val;
        }
        if (Math.abs(num) < 0.01 && Math.abs(num) > chop) {
            numberFormat = this.scientificFormat;
        } else {
            numberFormat = this.numberFormat;
            ((NumberFormat)numberFormat).setMinimumFractionDigits(numfracdigits);
            ((NumberFormat)numberFormat).setMaximumFractionDigits(numfracdigits);
        }
        DecimalFormat df = numberFormat;
        char c = OSPRuntime.getCurrentDecimalSeparator();
        char cc = df.getDecimalFormatSymbols().getDecimalSeparator();
        if (!Character.valueOf(c).equals(Character.valueOf(cc))) {
            df.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        }
        val = numberFormat.format(num);
        this.htFormats.put(key, val);
        return val;
    }

    private ArrayList<Double> gridInit(double low, double step, boolean labeled, ArrayList<Double> oldgrid) {
        ArrayList<Double> grid = new ArrayList<Double>(10);
        double ratio = Math.pow(10.0, step);
        int ngrid = 1;
        if (labeled) {
            if (ratio <= 3.5) {
                if (ratio > 2.0) {
                    ngrid = 2;
                } else if (ratio > 1.26) {
                    ngrid = 5;
                } else if (ratio > 1.125) {
                    ngrid = 10;
                } else {
                    ngrid = (int)Math.rint(1.0 / step);
                    ngrid = 10;
                }
            }
        } else {
            ngrid = ratio > 10.0 ? 1 : (ratio > 3.0 ? 2 : (ratio > 2.0 ? 5 : (ratio > 1.125 ? 10 : 100)));
        }
        int oldgridi = 0;
        int i = 0;
        while (i < ngrid) {
            double gridval = (double)i * 1.0 / (double)ngrid * 10.0;
            double logval = LOG10SCALE * Math.log(gridval);
            if (logval == Double.NEGATIVE_INFINITY) {
                logval = 0.0;
            }
            if (oldgrid != null && oldgridi < oldgrid.size()) {
                while (oldgridi < oldgrid.size() && oldgrid.get(oldgridi) < logval) {
                    ++oldgridi;
                }
                if (oldgridi < oldgrid.size()) {
                    if (Math.abs(oldgrid.get(oldgridi) - logval) > 1.0E-5) {
                        grid.add(new Double(logval));
                    }
                } else {
                    grid.add(new Double(logval));
                }
            } else {
                grid.add(new Double(logval));
            }
            ++i;
        }
        this.gridCurJuke = 0;
        if (low == -0.0) {
            low = 0.0;
        }
        this.gridBase = Math.floor(low);
        double x = low - this.gridBase;
        this.gridCurJuke = -1;
        while (this.gridCurJuke + 1 < grid.size() && x >= grid.get(this.gridCurJuke + 1)) {
            ++this.gridCurJuke;
        }
        return grid;
    }

    private double gridRoundUp(ArrayList<Double> grid, double pos) {
        double x = pos - Math.floor(pos);
        int i = 0;
        while (i < grid.size() && x >= grid.get(i)) {
            ++i;
        }
        if (i >= grid.size()) {
            return pos;
        }
        return Math.floor(pos) + grid.get(i);
    }

    private double gridStep(ArrayList<Double> grid, double pos, double step, boolean logflag) {
        if (step == 0.0) {
            step = 1.0;
        }
        if (logflag) {
            if (++this.gridCurJuke >= grid.size()) {
                this.gridCurJuke = 0;
                this.gridBase += Math.ceil(step);
            }
            if (this.gridCurJuke >= grid.size()) {
                return pos + step;
            }
            return this.gridBase + grid.get(this.gridCurJuke);
        }
        if (pos + step == pos) {
            while (pos + step == pos) {
                step *= 2.0;
            }
            return pos + step;
        }
        return pos + step;
    }

    private void measureFonts(JPanel panel) {
        this.labelFontMetrics = panel.getFontMetrics(this.labelFont);
        this.superscriptFontMetrics = panel.getFontMetrics(this.superscriptFont);
        this.titleFontMetrics = panel.getFontMetrics(this.titleFont);
    }

    private int numFracDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && num != Math.floor(num)) {
            num *= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    private int numIntDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && (double)((int)num) != 0.0) {
            num /= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    private double roundUp(double val) {
        int exponent;
        val = (val *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log(val) * LOG10SCALE)))) > 5.0 ? 10.0 : (val > 2.0 ? 5.0 : (val > 1.0 ? 2.0 : 1.0));
        return val *= Math.pow(10.0, exponent);
    }

    private void setXRange(double min, double max) {
        double largest = Math.max(Math.abs(this.xMin), Math.abs(this.xMax));
        double range = Math.abs(this.xMax - this.xMin);
        this.xExponent = this.xMin >= 0.0 && this.xMax <= 1000.0 && range > 0.1 && !this.xlog ? 0 : (int)Math.floor(Math.log(largest) * LOG10SCALE);
        if (this.xExponent > 1 || this.xExponent < -1) {
            double xs = 1.0 / Math.pow(10.0, this.xExponent);
            this.xtickMin = this.xMin * xs;
            this.xtickMax = this.xMax * xs;
        } else {
            this.xtickMin = this.xMin;
            this.xtickMax = this.xMax;
            this.xExponent = 0;
        }
    }

    private void setYRange(double min, double max) {
        double largest = Math.max(Math.abs(this.yMin), Math.abs(this.yMax));
        this.yExponent = this.yMin >= 0.0 && this.yMax <= 1000.0 && !this.ylog ? 0 : (int)Math.floor(Math.log(largest) * LOG10SCALE);
        if (this.yExponent > 1 || this.yExponent < -1) {
            double ys = 1.0 / Math.pow(10.0, this.yExponent);
            this.ytickMin = this.yMin * ys;
            this.ytickMax = this.yMax * ys;
        } else {
            this.ytickMin = this.yMin;
            this.ytickMax = this.yMax;
            this.yExponent = 0;
        }
    }

    @Override
    public void setShowMajorXGrid(boolean showGrid) {
        this.drawMajorXGrid = showGrid;
        if (!showGrid) {
            this.drawMinorXGrid = showGrid;
        }
    }

    @Override
    public void setShowMinorXGrid(boolean showGrid) {
        this.drawMinorXGrid = showGrid;
    }

    @Override
    public void setShowMajorYGrid(boolean showGrid) {
        this.drawMajorYGrid = showGrid;
        if (!showGrid) {
            this.drawMinorYGrid = showGrid;
        }
    }

    @Override
    public void setShowMinorYGrid(boolean showGrid) {
        this.drawMinorYGrid = showGrid;
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public Dimension getInterior(DrawingPanel panel) {
        this.adjustGutters = panel.getDimensionSetter() == null;
        return null;
    }

    public void setTickLength(int len) {
        this.tickLength = len;
    }
}

