/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display.axes.YAxis;

public class CartesianType2
extends AbstractAxes
implements CartesianAxes {
    XAxis xaxis;
    YAxis yaxis;
    boolean xlog = false;
    boolean ylog = false;

    public CartesianType2(PlottingPanel panel) {
        super(panel);
        this.defaultLeftGutter = 50;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 50;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.xaxis = new XAxis();
        this.yaxis = new YAxis();
        this.xaxis.setLocationType(1);
        this.yaxis.setLocationType(1);
        if (panel == null) {
            return;
        }
        panel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        panel.setAxes(this);
    }

    @Override
    public void setXLabel(String s, String font_name) {
        this.xaxis.setTitle(s, font_name);
    }

    @Override
    public void setYLabel(String s, String font_name) {
        this.yaxis.setTitle(s, font_name);
    }

    @Override
    public String getXLabel() {
        return this.xaxis.axisLabel.getText();
    }

    @Override
    public String getYLabel() {
        return this.yaxis.axisLabel.getText();
    }

    @Override
    public String getTitle() {
        return this.titleLine.getText();
    }

    @Override
    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    @Override
    public void setXLog(boolean isLog) {
        this.xlog = isLog;
        if (isLog) {
            this.xaxis.setAxisType(1);
        } else {
            this.xaxis.setAxisType(0);
        }
    }

    @Override
    public void setYLog(boolean isLog) {
        this.ylog = isLog;
        if (isLog) {
            this.yaxis.setAxisType(1);
        } else {
            this.yaxis.setAxisType(0);
        }
    }

    @Override
    public boolean isXLog() {
        return this.xlog;
    }

    @Override
    public boolean isYLog() {
        return this.ylog;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            int gw = panel.getLeftGutter() + panel.getRightGutter();
            int gh = panel.getTopGutter() + panel.getBottomGutter();
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(Color.lightGray);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw - 1, panel.getHeight() - gh - 1);
        }
        this.xaxis.draw(panel, g);
        this.yaxis.draw(panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.setColor(panel.getForeground());
        this.titleLine.draw(panel, g);
    }

    @Override
    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    @Override
    public void setShowMajorXGrid(boolean showGrid) {
        this.xaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorXGrid(showGrid);
        }
    }

    @Override
    public void setShowMinorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMajorYGrid(boolean showGrid) {
        this.yaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorYGrid(showGrid);
        }
    }

    @Override
    public void setShowMinorYGrid(boolean showGrid) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }
}

