/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.DrawableAxes;

public class CustomAxes
extends AbstractAxes
implements DrawableAxes {
    Color gridColor = Color.lightGray;
    ArrayList<Drawable> drawableList = new ArrayList();

    public CustomAxes(PlottingPanel panel) {
        super(panel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (panel == null) {
            return;
        }
        panel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        panel.setAxes(this);
    }

    @Override
    public void setXLabel(String s, String font_name) {
    }

    @Override
    public void setYLabel(String s, String font_name) {
    }

    @Override
    public String getXLabel() {
        return "";
    }

    @Override
    public String getYLabel() {
        return "";
    }

    @Override
    public String getTitle() {
        return this.titleLine.getText();
    }

    @Override
    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    @Override
    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    @Override
    public void setShowMajorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorXGrid(boolean showGrid) {
    }

    @Override
    public void setShowMajorYGrid(boolean showGrid) {
    }

    @Override
    public void setShowMinorYGrid(boolean showGrid) {
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != panel.getBackground()) {
            g.setColor(this.interiorColor);
            int gw = panel.getLeftGutter() + panel.getRightGutter();
            int gh = panel.getTopGutter() + panel.getLeftGutter();
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(this.gridColor);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        }
        for (Drawable drawable : this.drawableList) {
            drawable.draw(panel, g);
        }
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }
}

